/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.misc;

import java.util.ArrayList;
import java.util.List;
import org.develnext.jphp.core.compiler.jvm.misc.StackFrame;
import org.objectweb.asm.tree.LabelNode;
import php.runtime.Memory;

public class LocalVariable {
    public final String name;
    public final int index;
    public final LabelNode label;
    private LabelNode endLabel;
    private Class clazz;
    private boolean isImmutable;
    private boolean isReference;
    private int level;
    private List<Memory> values;
    private List<StackFrame> frames;

    public LocalVariable(String name, int index, LabelNode label, Class clazz) {
        this.name = name;
        this.index = index;
        this.label = label;
        this.clazz = clazz;
        this.level = 0;
        this.isImmutable = true;
        this.values = new ArrayList<Memory>();
        this.frames = new ArrayList<StackFrame>();
    }

    public void addStackFrame(StackFrame frame) {
        this.frames.add(frame);
    }

    public List<StackFrame> getStackFrames() {
        return this.frames;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public void setReference(boolean reference) {
        this.isReference = reference;
    }

    public void pushLevel() {
        ++this.level;
    }

    public int popLevel() {
        if (this.values.size() >= this.level + 1) {
            this.values.remove(this.values.size() - 1);
        }
        --this.level;
        this.setValue(null);
        return this.level + 1;
    }

    public int getLevel() {
        return this.level;
    }

    public void setValue(Memory value) {
        if (this.values.size() < this.level) {
            this.values.add(value);
        } else if (this.values.size() > 0) {
            this.values.set(this.values.size() - 1, value);
        }
    }

    public Memory getValue() {
        return this.values.isEmpty() ? null : this.values.get(this.values.size() - 1);
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public void setImmutable(boolean immutable) {
        this.isImmutable = immutable;
    }

    public LabelNode getEndLabel() {
        return this.endLabel;
    }

    public void setEndLabel(LabelNode endLabel) {
        this.endLabel = endLabel;
    }
}

