/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement;

import java.util.Arrays;
import java.util.Collections;
import org.develnext.jphp.core.compiler.jvm.JvmCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.ClassStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.StmtCompiler;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExtendsStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FunctionStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.MethodStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceStmtToken;
import php.runtime.common.Modifier;
import php.runtime.lang.Generator;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.helper.GeneratorEntity;

public class GeneratorStmtCompiler
extends StmtCompiler<GeneratorEntity> {
    protected final FunctionStmtToken statement;

    public GeneratorStmtCompiler(JvmCompiler compiler, FunctionStmtToken statement) {
        super(compiler);
        this.statement = statement;
    }

    @Override
    public GeneratorEntity compile() {
        GeneratorEntity entity = new GeneratorEntity(this.getCompiler().getContext());
        entity.setReturnReference(this.statement.isReturnReference());
        entity.setInternalName(this.compiler.getModule().getInternalName() + "_generator" + this.statement.getId());
        entity.setId(this.statement.getGeneratorId());
        entity.setTrace(this.statement.toTraceInfo(this.compiler.getContext()));
        ClassStmtToken classStmtToken = new ClassStmtToken(this.statement.getMeta());
        classStmtToken.setNamespace(NamespaceStmtToken.getDefault());
        classStmtToken.setName(NameToken.valueOf(entity.getInternalName()));
        classStmtToken.setExtend(ExtendsStmtToken.valueOf(Generator.class.getSimpleName()));
        MethodStmtToken methodToken = new MethodStmtToken(this.statement);
        methodToken.setClazz(classStmtToken);
        methodToken.setGenerator(false);
        methodToken.setReturnReference(false);
        methodToken.setModifier(Modifier.PROTECTED);
        methodToken.setName(NameToken.valueOf("_run"));
        methodToken.setUses(this.statement.getArguments());
        methodToken.setArguments(Collections.emptyList());
        classStmtToken.setMethods(Arrays.asList(methodToken));
        ClassStmtCompiler classStmtCompiler = new ClassStmtCompiler(this.compiler, classStmtToken);
        classStmtCompiler.setSystem(true);
        classStmtCompiler.setInterfaceCheck(false);
        classStmtCompiler.setGeneratorEntity(entity);
        classStmtCompiler.setFunctionName(this.statement.getFulledName());
        ClassEntity clazzEntity = classStmtCompiler.compile();
        entity.getMethods().putAll(clazzEntity.getMethods());
        if (clazzEntity.getParent() != null) {
            entity.setParent(clazzEntity.getParent());
        }
        entity.setData(clazzEntity.getData());
        entity.setType(ClassEntity.Type.GENERATOR);
        entity.doneDeclare();
        return entity;
    }
}

