/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.syntax;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.develnext.jphp.core.syntax.Scope;
import org.develnext.jphp.core.syntax.generators.ClassGenerator;
import org.develnext.jphp.core.syntax.generators.ConstGenerator;
import org.develnext.jphp.core.syntax.generators.DeclareGenerator;
import org.develnext.jphp.core.syntax.generators.ExprGenerator;
import org.develnext.jphp.core.syntax.generators.FunctionGenerator;
import org.develnext.jphp.core.syntax.generators.Generator;
import org.develnext.jphp.core.syntax.generators.NameGenerator;
import org.develnext.jphp.core.syntax.generators.NamespaceGenerator;
import org.develnext.jphp.core.syntax.generators.ThrowGenerator;
import org.develnext.jphp.core.syntax.generators.TryCatchGenerator;
import org.develnext.jphp.core.syntax.generators.UseGenerator;
import org.develnext.jphp.core.syntax.generators.manually.BodyGenerator;
import org.develnext.jphp.core.syntax.generators.manually.SimpleExprGenerator;
import org.develnext.jphp.core.tokenizer.Tokenizer;
import org.develnext.jphp.core.tokenizer.token.CommentToken;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ClosureStmtToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.FulledNameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ConstStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FunctionStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.MethodStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceUseStmtToken;
import php.runtime.env.Context;
import php.runtime.env.Environment;

public class SyntaxAnalyzer {
    private Tokenizer tokenizer;
    private List<Token> tokens;
    private List<Token> tree;
    private List<Generator> generators;
    private final Map<Class<? extends Generator>, Generator> map = new HashMap<Class<? extends Generator>, Generator>();
    private NamespaceStmtToken namespace = NamespaceStmtToken.getDefault();
    private ClassStmtToken clazz;
    private FunctionStmtToken function;
    private Stack<FunctionStmtToken> closureStack;
    private Stack<Scope> scopeStack;
    private Stack<Scope> rootScopeStack = new Stack();
    private Map<String, ClassStmtToken> classes;
    private List<FunctionStmtToken> functions;
    private List<ConstStmtToken> constants;
    private List<ClosureStmtToken> closures;
    private Environment environment;
    private int generatorSize = 0;

    public SyntaxAnalyzer(Environment environment, Tokenizer tokenizer) {
        this(environment, tokenizer, null);
    }

    public void reset(Environment environment, Tokenizer tokenizer) {
        this.removeScope();
        this.generatorSize = 0;
        tokenizer.reset();
        this.environment = environment;
        this.tokenizer = tokenizer;
        this.function = null;
        this.classes.clear();
        this.functions.clear();
        this.constants.clear();
        this.closures.clear();
        this.closureStack.clear();
        this.tokens.clear();
        this.tree.clear();
        this.scopeStack.clear();
        this.addScope(true);
        this.process();
    }

    public SyntaxAnalyzer(Environment environment, Tokenizer tokenizer, FunctionStmtToken function) {
        if (tokenizer != null) {
            tokenizer.reset();
        }
        this.environment = environment;
        this.tokenizer = tokenizer;
        this.function = function;
        this.classes = new LinkedHashMap<String, ClassStmtToken>();
        this.functions = new ArrayList<FunctionStmtToken>();
        this.constants = new ArrayList<ConstStmtToken>();
        this.closures = new ArrayList<ClosureStmtToken>();
        this.closureStack = new Stack();
        this.tokens = new LinkedList<Token>();
        this.tree = new ArrayList<Token>();
        this.scopeStack = new Stack();
        this.generators = new ArrayList<Generator>(50);
        this.generators.add(new NamespaceGenerator(this));
        this.generators.add(new UseGenerator(this));
        this.generators.add(new DeclareGenerator(this));
        this.generators.add(new ClassGenerator(this));
        this.generators.add(new ConstGenerator(this));
        this.generators.add(new FunctionGenerator(this));
        this.generators.add(new TryCatchGenerator(this));
        this.generators.add(new ThrowGenerator(this));
        this.generators.add(new NameGenerator(this));
        this.generators.add(new SimpleExprGenerator(this));
        this.generators.add(new BodyGenerator(this));
        this.generators.add(new ExprGenerator(this));
        for (Generator generator : this.generators) {
            this.map.put(generator.getClass(), generator);
        }
        this.addScope(true);
        if (tokenizer != null) {
            this.process();
        }
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void registerClass(ClassStmtToken clazz) {
        this.classes.put(clazz.getFulledName().toLowerCase(), clazz);
        for (MethodStmtToken method : clazz.getMethods()) {
            if (!method.isGenerator()) continue;
            method.setGeneratorId(this.generatorSize++);
        }
    }

    public void registerFunction(FunctionStmtToken function) {
        if (function.getId() <= this.functions.size()) {
            function.setId(this.functions.size());
            if (function.isGenerator()) {
                function.setGeneratorId(this.generatorSize++);
            }
            this.functions.add(function);
        }
    }

    public void registerConstant(ConstStmtToken constant) {
        this.constants.add(constant);
    }

    public void registerClosure(ClosureStmtToken closure) {
        closure.setId(this.closures.size());
        if (closure.getFunction().isGenerator()) {
            closure.getFunction().setGeneratorId(this.generatorSize++);
        }
        this.closures.add(closure);
    }

    public Collection<ClassStmtToken> getClasses() {
        return this.classes.values();
    }

    public Collection<FunctionStmtToken> getFunctions() {
        return this.functions;
    }

    public Collection<ConstStmtToken> getConstants() {
        return this.constants;
    }

    public Collection<ClosureStmtToken> getClosures() {
        return this.closures;
    }

    public ClassStmtToken findClass(String name) {
        return this.classes.get(name.toLowerCase());
    }

    protected void process() {
        Token token;
        this.tokenizer.reset();
        this.tree.clear();
        while ((token = this.tokenizer.nextToken()) != null) {
            if (token instanceof CommentToken && ((CommentToken)token).getKind() != CommentToken.Kind.DOCTYPE) continue;
            this.tokens.add(token);
        }
        ListIterator<Token> iterator = this.tokens.listIterator();
        this.tree = this.process(iterator);
    }

    protected void registerToken(Token token) {
        if (token instanceof ClassStmtToken) {
            this.registerClass((ClassStmtToken)token);
        } else if (token instanceof FunctionStmtToken) {
            this.registerFunction((FunctionStmtToken)token);
        } else if (token instanceof ConstStmtToken) {
            this.registerConstant((ConstStmtToken)token);
        }
    }

    public List<Token> process(ListIterator<Token> iterator) {
        ArrayList<Token> result = new ArrayList<Token>();
        while (iterator.hasNext()) {
            Token gen = this.processNext(iterator);
            if (gen instanceof NamespaceStmtToken) {
                List<Token> tree = ((NamespaceStmtToken)gen).getTree();
                ((NamespaceStmtToken)gen).setTree(null);
                result.add(gen);
                this.registerToken(gen);
                result.addAll(tree);
                if (((NamespaceStmtToken)gen).isTokenRegistered()) continue;
                for (Token el : tree) {
                    this.registerToken(el);
                }
                continue;
            }
            result.add(gen);
            this.registerToken(gen);
        }
        return result;
    }

    public Token processNext(ListIterator<Token> iterator) {
        Token current = iterator.next();
        Token gen = this.generateToken(current, iterator);
        return gen == null ? current : gen;
    }

    public Scope addScope(boolean isRoot) {
        Scope scope = new Scope(this.scopeStack.empty() ? null : this.scopeStack.peek());
        this.scopeStack.push(scope);
        if (isRoot) {
            this.rootScopeStack.push(scope);
        }
        return scope;
    }

    public Scope addScope() {
        return this.addScope(false);
    }

    public Scope removeScope() {
        Scope scope = this.getScope();
        if (this.rootScopeStack.peek() == scope) {
            this.rootScopeStack.pop();
        } else {
            this.rootScopeStack.peek().appendScope(scope);
        }
        return this.scopeStack.pop();
    }

    public Scope getScope() {
        return this.scopeStack.peek();
    }

    public <T extends Generator> T generator(Class<T> clazz) {
        Generator generator = this.map.get(clazz);
        if (generator == null) {
            throw new AssertionError((Object)("Generator '" + clazz.getName() + "' not found"));
        }
        if (generator.isSingleton()) {
            return (T)generator;
        }
        Constructor<T> constructor = null;
        try {
            constructor = clazz.getConstructor(SyntaxAnalyzer.class);
            return (T)((Generator)constructor.newInstance(this));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Token generateToken(Token current, ListIterator<Token> iterator) {
        Token gen = null;
        for (Generator generator : this.generators) {
            if (generator.isAutomatic() && (gen = (Token)generator.getToken(current, iterator)) != null) break;
        }
        return gen;
    }

    public List<Token> getTree() {
        return this.tree;
    }

    public Context getContext() {
        return this.tokenizer.getContext();
    }

    public NamespaceStmtToken getNamespace() {
        return this.namespace;
    }

    public void setNamespace(NamespaceStmtToken namespace) {
        this.namespace = namespace;
    }

    public ClassStmtToken getClazz() {
        return this.clazz;
    }

    public void setClazz(ClassStmtToken clazz) {
        this.clazz = clazz;
    }

    public FunctionStmtToken getFunction(boolean absolute) {
        FunctionStmtToken func;
        if (!absolute && (func = this.peekClosure()) != null) {
            return func;
        }
        return this.function;
    }

    public FunctionStmtToken getFunction() {
        return this.getFunction(false);
    }

    public void setFunction(FunctionStmtToken function) {
        this.function = function;
    }

    public void pushClosure(FunctionStmtToken closure) {
        this.closureStack.push(closure);
    }

    public FunctionStmtToken peekClosure() {
        if (this.closureStack.empty()) {
            return null;
        }
        return this.closureStack.peek();
    }

    public FunctionStmtToken popClosure() {
        return this.closureStack.pop();
    }

    public ValueExprToken getRealName(ValueExprToken value, NamespaceUseStmtToken.UseType useType) {
        if (value == null) {
            return null;
        }
        if (value instanceof NameToken) {
            return this.getRealName((NameToken)value, useType);
        }
        return value;
    }

    public FulledNameToken getRealName(NameToken what, NamespaceUseStmtToken.UseType useType) {
        return SyntaxAnalyzer.getRealName(what, this.namespace, useType);
    }

    public FulledNameToken getRealName(NameToken what) {
        return this.getRealName(what, NamespaceUseStmtToken.UseType.CLASS);
    }

    public static FulledNameToken getRealName(NameToken what, NamespaceStmtToken namespace) {
        return SyntaxAnalyzer.getRealName(what, namespace, NamespaceUseStmtToken.UseType.CLASS);
    }

    public static FulledNameToken getRealName(NameToken what, NamespaceStmtToken namespace, NamespaceUseStmtToken.UseType useType) {
        ArrayList<NameToken> names;
        if (what instanceof FulledNameToken) {
            FulledNameToken fulledNameToken = (FulledNameToken)what;
            if (fulledNameToken.isProcessed(useType)) {
                return fulledNameToken;
            }
            if (fulledNameToken.isAnyProcessed()) {
                what = fulledNameToken.getLastName();
            }
        }
        String name = what.getName();
        if (namespace != null) {
            for (NamespaceUseStmtToken use : namespace.getUses()) {
                String string;
                if (use.getUseType() != useType) continue;
                if (use.getAs() == null) {
                    string = use.getName().getLastName().getName();
                    if ((useType != NamespaceUseStmtToken.UseType.CONSTANT || !name.equals(string)) && (useType == NamespaceUseStmtToken.UseType.CONSTANT || !name.equalsIgnoreCase(string))) continue;
                    FulledNameToken t = new FulledNameToken(use.getName());
                    t.setProcessed(useType);
                    return t;
                }
                string = use.getAs().getName();
                if ((useType != NamespaceUseStmtToken.UseType.CONSTANT || !name.equals(string)) && (useType == NamespaceUseStmtToken.UseType.CONSTANT || !name.equalsIgnoreCase(string))) continue;
                FulledNameToken t = new FulledNameToken(use.getName());
                t.setProcessed(useType);
                return t;
            }
        }
        ArrayList<NameToken> arrayList = names = namespace == null || namespace.getName() == null ? new ArrayList<NameToken>() : new ArrayList<NameToken>(namespace.getName().getNames());
        if (what instanceof FulledNameToken) {
            names.addAll(((FulledNameToken)what).getNames());
        } else {
            names.add(what);
        }
        FulledNameToken t = new FulledNameToken(what.getMeta(), names);
        t.setProcessed(useType);
        return t;
    }
}

