/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token.stmt;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.develnext.jphp.core.syntax.ExpressionInfo;
import org.develnext.jphp.core.syntax.VariableStats;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.CommentToken;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ArgumentStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.BodyStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.LabelStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.StmtToken;
import php.runtime.common.HintType;
import php.runtime.common.Modifier;

public class FunctionStmtToken
extends StmtToken {
    protected Modifier modifier;
    protected NamespaceStmtToken namespace;
    protected NameToken name;
    protected CommentToken docComment;
    protected boolean returnReference;
    protected boolean returnOptional;
    protected HintType returnHintType;
    protected NameToken returnHintTypeClass;
    protected List<ArgumentStmtToken> arguments;
    protected List<ArgumentStmtToken> uses;
    protected BodyStmtToken body;
    protected boolean interfacable;
    protected Map<String, LabelStmtToken> labels;
    protected Map<String, VariableStats> variables;
    protected Set<VariableExprToken> local;
    protected Set<VariableExprToken> staticLocal = new HashSet<VariableExprToken>();
    protected boolean dynamicLocal = false;
    protected boolean callsExist = false;
    protected boolean varsExists = false;
    protected boolean thisExists = false;
    protected boolean staticExists;
    public static final VariableExprToken thisVariable = VariableExprToken.valueOf("this");
    protected int id;
    protected int generatorId = -1;
    protected boolean isStatic = false;
    protected boolean isGenerator = false;
    private Map<Token, ExpressionInfo> typeInfo;

    public FunctionStmtToken(TokenMeta meta) {
        super(meta, TokenType.T_FUNCTION);
        this.variables = new LinkedHashMap<String, VariableStats>();
    }

    public Set<VariableExprToken> getStaticLocal() {
        return this.staticLocal;
    }

    public void setStaticLocal(Set<VariableExprToken> staticLocal) {
        this.staticLocal = staticLocal;
    }

    public static VariableExprToken getThisVariable() {
        return thisVariable;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean aStatic) {
        this.isStatic = aStatic;
    }

    public boolean isStaticExists() {
        return this.staticExists;
    }

    public void setStaticExists(boolean staticExists) {
        this.staticExists = staticExists;
    }

    public NamespaceStmtToken getNamespace() {
        return this.namespace;
    }

    public void setNamespace(NamespaceStmtToken namespace) {
        this.namespace = namespace;
    }

    public NameToken getName() {
        return this.name;
    }

    public void setName(NameToken name) {
        this.name = name;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public void setModifier(Modifier modifier) {
        this.modifier = modifier;
    }

    public List<ArgumentStmtToken> getUses() {
        return this.uses;
    }

    public void setUses(List<ArgumentStmtToken> uses) {
        this.uses = uses;
    }

    public boolean isReturnReference() {
        return this.returnReference;
    }

    public void setReturnReference(boolean returnReference) {
        this.returnReference = returnReference;
    }

    public List<ArgumentStmtToken> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<ArgumentStmtToken> arguments) {
        this.arguments = arguments;
    }

    public BodyStmtToken getBody() {
        return this.body;
    }

    public void setBody(BodyStmtToken body) {
        this.body = body;
    }

    public boolean isInterfacable() {
        return this.interfacable;
    }

    public void setInterfacable(boolean interfacable) {
        this.interfacable = interfacable;
    }

    public Set<VariableExprToken> getLocal() {
        return this.local;
    }

    public void setLocal(Set<VariableExprToken> local) {
        this.local = local;
        this.thisExists = local.contains(thisVariable);
    }

    public void setLabels(Map<String, LabelStmtToken> labels) {
        this.labels = labels;
    }

    public boolean isDynamicLocal() {
        return this.dynamicLocal;
    }

    public void setDynamicLocal(boolean dynamicLocal) {
        this.dynamicLocal = dynamicLocal;
    }

    public boolean isGenerator() {
        return this.isGenerator;
    }

    public void setGenerator(boolean isGenerator) {
        this.isGenerator = isGenerator;
    }

    public boolean isCallsExist() {
        return this.callsExist;
    }

    public void setCallsExist(boolean callsExist) {
        this.callsExist = callsExist;
    }

    public boolean isReference(VariableExprToken variable) {
        VariableStats stats = this.variable(variable);
        return this.dynamicLocal || stats.isArrayAccess() || stats.isPassed() || stats.isReference();
    }

    public boolean isUnstableVariable(VariableExprToken variable) {
        return this.variable(variable).isUnstable();
    }

    public boolean isVarsExists() {
        return this.varsExists;
    }

    public void setVarsExists(boolean varsExists) {
        this.varsExists = varsExists;
    }

    public boolean isMutable() {
        return this.varsExists || this.callsExist;
    }

    public String getFulledName(char delimiter) {
        return this.namespace == null || this.namespace.getName() == null ? (this.name == null ? null : this.name.getName()) : this.namespace.getName().toName(delimiter) + delimiter + this.name.getName();
    }

    public String getFulledName() {
        return this.getFulledName('\\');
    }

    public void setThisExists(boolean thisExists) {
        this.thisExists = thisExists;
    }

    public boolean isThisExists() {
        return this.thisExists;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public boolean addLabel(LabelStmtToken labelStmtToken) {
        if (this.labels == null) {
            this.labels = new LinkedHashMap<String, LabelStmtToken>();
        }
        return this.labels.put(labelStmtToken.getName().toLowerCase(), labelStmtToken) == null;
    }

    public LabelStmtToken findLabel(String name) {
        if (this.labels == null) {
            return null;
        }
        return this.labels.get(name.toLowerCase());
    }

    public VariableStats variable(String name) {
        VariableStats stats = this.variables.get(name);
        if (stats == null) {
            stats = new VariableStats();
            this.variables.put(name, stats);
        }
        return stats;
    }

    public VariableStats variable(VariableExprToken token) {
        return this.variable(token.getName());
    }

    public boolean isUnusedVariable(VariableExprToken token) {
        return !this.dynamicLocal && this.variable(token).isUnused();
    }

    public CommentToken getDocComment() {
        return this.docComment;
    }

    public void setDocComment(CommentToken docComment) {
        this.docComment = docComment;
    }

    public int getGeneratorId() {
        return this.generatorId;
    }

    public void setGeneratorId(int generatorId) {
        this.generatorId = generatorId;
    }

    public void setTypeInfo(Map<Token, ExpressionInfo> typeInfo) {
        this.typeInfo = typeInfo;
    }

    public Map<Token, ExpressionInfo> getTypeInfo() {
        return this.typeInfo;
    }

    public boolean isReturnOptional() {
        return this.returnOptional;
    }

    public void setReturnOptional(boolean returnOptional) {
        this.returnOptional = returnOptional;
    }

    public HintType getReturnHintType() {
        return this.returnHintType;
    }

    public void setReturnHintType(HintType returnHintType) {
        this.returnHintType = returnHintType;
    }

    public NameToken getReturnHintTypeClass() {
        return this.returnHintTypeClass;
    }

    public void setReturnHintTypeClass(NameToken returnHintTypeClass) {
        this.returnHintTypeClass = returnHintTypeClass;
    }

    public Map<String, LabelStmtToken> getLabels() {
        return this.labels;
    }

    public Map<String, VariableStats> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableStats> variables) {
        this.variables = variables;
    }
}

