/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes.text;

import com.sun.javafx.tk.Toolkit;
import java.io.InputStream;
import java.util.List;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import php.runtime.annotation.Reflection;
import php.runtime.common.Messages;
import php.runtime.env.Environment;
import php.runtime.lang.BaseWrapper;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\text\\UXFont")
public class UXFont
extends BaseWrapper<Font> {
    private OwnerObject ownerObject;

    public UXFont(Environment env, Font wrappedObject) {
        super(env, wrappedObject);
    }

    public UXFont(Environment env, Font wrappedObject, OwnerObject ownerObject) {
        super(env, wrappedObject);
        this.ownerObject = ownerObject;
    }

    public UXFont(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    private OwnerObject requestOwnerObject(Environment env, String property) {
        if (this.ownerObject == null) {
            env.exception(Messages.ERR_READONLY_PROPERTY.fetch(this.getReflection().getName(), property), new Object[0]);
        }
        return this.ownerObject;
    }

    @Reflection.Signature
    public void __construct(double size) {
        this.__wrappedObject = new Font(size);
    }

    @Reflection.Signature
    public void __construct(double size, String name) {
        this.__wrappedObject = new Font(name, size);
    }

    @Reflection.Setter
    public void setSize(Environment env, double size) {
        this.__wrappedObject = this.withSize(size);
        this.requestOwnerObject(env, "size").assignFont((Font)this.__wrappedObject);
    }

    @Reflection.Getter
    public double getSize() {
        return ((Font)this.getWrappedObject()).getSize();
    }

    @Reflection.Setter
    public void setName(Environment env, String name) {
        this.__wrappedObject = this.withName(name);
        this.requestOwnerObject(env, "name").assignFont((Font)this.__wrappedObject);
    }

    @Reflection.Getter
    public String getName() {
        return ((Font)this.getWrappedObject()).getName();
    }

    @Reflection.Setter
    public void setFamily(Environment env, String name) {
        this.__wrappedObject = this.withName(name);
        this.requestOwnerObject(env, "family").assignFont((Font)this.__wrappedObject);
    }

    @Reflection.Getter
    public String getFamily() {
        return ((Font)this.getWrappedObject()).getFamily();
    }

    @Reflection.Setter
    public void setBold(Environment env, boolean bold) {
        this.__wrappedObject = bold ? this.withBold() : this.withThin();
        this.requestOwnerObject(env, "bold").assignFont((Font)this.__wrappedObject);
    }

    @Reflection.Getter
    public boolean getBold() {
        return ((Font)this.getWrappedObject()).getStyle().toUpperCase().contains("BOLD");
    }

    @Reflection.Setter
    public void setItalic(Environment env, boolean italic) {
        this.__wrappedObject = italic ? this.withItalic() : this.withoutItalic();
        this.requestOwnerObject(env, "italic").assignFont((Font)this.__wrappedObject);
    }

    @Reflection.Getter
    public boolean getItalic() {
        return ((Font)this.getWrappedObject()).getStyle().toUpperCase().contains("ITALIC");
    }

    @Reflection.Signature
    public static List<String> getFamilies() {
        return Font.getFamilies();
    }

    @Reflection.Signature
    public static List<String> getFontNames() {
        return Font.getFontNames();
    }

    @Reflection.Signature
    public static List<String> getFontNames(String family) {
        return Font.getFontNames((String)family);
    }

    @Reflection.Signature
    public static Font getDefault() {
        return Font.getDefault();
    }

    @Reflection.Signature
    public Font withItalic() {
        return this.withNameAndSize(((Font)this.getWrappedObject()).getName(), ((Font)this.getWrappedObject()).getSize(), null, true);
    }

    @Reflection.Signature
    public Font withoutItalic() {
        return this.withNameAndSize(((Font)this.getWrappedObject()).getName(), ((Font)this.getWrappedObject()).getSize(), null, false);
    }

    @Reflection.Signature
    public Font withRegular() {
        return this.withNameAndSize(((Font)this.getWrappedObject()).getName(), ((Font)this.getWrappedObject()).getSize(), null, false);
    }

    @Reflection.Signature
    public Font withBold() {
        return this.withNameAndSize(((Font)this.getWrappedObject()).getName(), ((Font)this.getWrappedObject()).getSize(), true, null);
    }

    @Reflection.Signature
    public Font withThin() {
        return this.withNameAndSize(((Font)this.getWrappedObject()).getName(), ((Font)this.getWrappedObject()).getSize(), false, null);
    }

    @Reflection.Signature
    public Font withName(String name) {
        return this.withNameAndSize(name, ((Font)this.getWrappedObject()).getSize());
    }

    @Reflection.Signature
    public Font withSize(double size) {
        return this.withNameAndSize(((Font)this.getWrappedObject()).getName(), size);
    }

    @Reflection.Signature
    public Font withNameAndSize(String name, double size) {
        return this.withNameAndSize(name, size, null, null);
    }

    @Reflection.Signature
    public String generateStyle() {
        String result = "-fx-font-family: " + this.getFamily() + ";\n";
        result = result + "-fx-font-size: " + this.getSize() + ";\n";
        result = result + "-fx-font-weight: " + (this.getBold() ? "bold" : "normal") + ";\n";
        result = result + "-fx-font-style: " + (this.getItalic() ? "italic" : "normal") + ";";
        return result;
    }

    protected Font withNameAndSize(String name, double size, Boolean bold, Boolean italic) {
        FontPosture posture;
        Font font = (Font)this.getWrappedObject();
        FontWeight weight = bold != null && bold != false ? FontWeight.BOLD : FontWeight.THIN;
        FontPosture fontPosture = posture = italic != null && italic != false ? FontPosture.ITALIC : FontPosture.REGULAR;
        if (font.getStyle().toUpperCase().contains("BOLD")) {
            weight = FontWeight.BOLD;
        }
        if (font.getStyle().toUpperCase().contains("ITALIC")) {
            posture = FontPosture.ITALIC;
        }
        return Font.font((String)name, (FontWeight)weight, (FontPosture)posture, (double)size);
    }

    @Reflection.Signature
    public static Font of(String family, int size) {
        return Font.font((String)family, (double)size);
    }

    @Reflection.Signature
    public static Font of(String family, int size, FontWeight fontWeight) {
        return Font.font((String)family, (FontWeight)fontWeight, (double)size);
    }

    @Reflection.Signature
    public static Font of(String family, int size, FontWeight fontWeight, boolean italic) {
        return Font.font((String)family, (FontWeight)fontWeight, (FontPosture)(italic ? FontPosture.ITALIC : FontPosture.REGULAR), (double)size);
    }

    @Reflection.Signature
    public static Font load(InputStream stream, double size) {
        return Font.loadFont((InputStream)stream, (double)size);
    }

    @Reflection.Getter
    public float getLineHeight() {
        return Toolkit.getToolkit().getFontLoader().getFontMetrics((Font)this.getWrappedObject()).getLineHeight();
    }

    public static double getLineHeight(Font font) {
        Text text = new Text("A");
        text.setFont(font);
        return text.getLayoutBounds().getHeight();
    }

    @Reflection.Signature
    public double calculateTextWidth(String atext) {
        Text text = new Text(atext);
        text.setFont((Font)this.getWrappedObject());
        return text.getLayoutBounds().getWidth();
    }

    public static double calculateTextWidth(String atext, Font font) {
        Text text = new Text(atext);
        text.setFont(font);
        return text.getLayoutBounds().getWidth();
    }

    static interface WrappedInterface {
        @Reflection.Property
        public String style();
    }

    public static interface OwnerObject {
        public void assignFont(Font var1);
    }
}

