/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.effect;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.effect.Effect;
import org.develnext.jphp.ext.javafx.support.effect.ChainableEffect;

public class EffectPipeline {
    private List<ChainableEffect> effects;
    private ReadOnlyObjectWrapper<Effect> chainedEffect = new ReadOnlyObjectWrapper();

    public EffectPipeline() {
        this.effects = new ArrayList<ChainableEffect>();
    }

    public void clear() {
        this.effects.clear();
        this.refreshChainedEffect();
    }

    public void add(int i, Effect effect) {
        ChainableEffect chainableEffect = new ChainableEffect(effect);
        this.effects.add(i, chainableEffect);
        this.refreshChainedEffect();
    }

    public void add(Effect effect) {
        this.add(this.effects.size(), effect);
    }

    public void addAll(List<Effect> effects) {
        for (Effect effect : effects) {
            this.effects.add(new ChainableEffect(effect));
        }
        this.refreshChainedEffect();
    }

    public void remove(Effect effect) {
        ChainableEffect deleted = null;
        for (ChainableEffect chainableEffect : this.effects) {
            if (!chainableEffect.getEffect().equals(effect)) continue;
            deleted = chainableEffect;
            break;
        }
        if (deleted != null) {
            this.effects.remove(deleted);
        }
        this.refreshChainedEffect();
    }

    public boolean has(Effect effect) {
        for (ChainableEffect chainableEffect : this.effects) {
            if (!chainableEffect.getEffect().equals(effect)) continue;
            return true;
        }
        return false;
    }

    public void disable(Effect effect) {
        for (ChainableEffect chainableEffect : this.effects) {
            if (!chainableEffect.getEffect().equals(effect)) continue;
            chainableEffect.setDisabled(true);
        }
        this.refreshChainedEffect();
    }

    public void enable(Effect effect) {
        for (ChainableEffect chainableEffect : this.effects) {
            if (!chainableEffect.getEffect().equals(effect)) continue;
            chainableEffect.setDisabled(false);
        }
        this.refreshChainedEffect();
    }

    public boolean isEnabled(Effect effect) {
        for (ChainableEffect chainableEffect : this.effects) {
            if (!chainableEffect.getEffect().equals(effect)) continue;
            return !chainableEffect.isDisabled();
        }
        return false;
    }

    public void refreshChainedEffect() {
        ChainableEffect firstEffect = null;
        ChainableEffect lastEffect = null;
        for (ChainableEffect nextEffect : this.effects) {
            nextEffect.setInput(null);
            if (nextEffect.isDisabled()) continue;
            if (firstEffect == null) {
                lastEffect = firstEffect = nextEffect;
                continue;
            }
            lastEffect.setInput(nextEffect);
            lastEffect = nextEffect;
        }
        this.chainedEffect.setValue((Object)(firstEffect == null ? null : firstEffect.getEffect()));
    }

    public List<Effect> all() {
        ArrayList<Effect> result = new ArrayList<Effect>();
        for (ChainableEffect effect : this.effects) {
            result.add(effect.getEffect());
        }
        return result;
    }

    public int count() {
        return this.effects.size();
    }

    public Effect getChainedEffect() {
        return (Effect)this.chainedEffect.get();
    }

    public ReadOnlyObjectProperty<Effect> chainedEffectProperty() {
        return this.chainedEffect.getReadOnlyProperty();
    }
}

