/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.zend.ext.standard;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.develnext.jphp.zend.ext.support.NaturalOrderComparator;
import php.runtime.Memory;
import php.runtime.annotation.Runtime;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.RecursiveException;
import php.runtime.ext.core.MathFunctions;
import php.runtime.ext.support.compile.FunctionsContainer;
import php.runtime.invoke.Invoker;
import php.runtime.lang.ForeachIterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.KeyValueMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ReferenceMemory;

public class ArrayFunctions
extends FunctionsContainer {
    @Runtime.Immutable(ignoreRefs=true)
    public static boolean in_array(Environment env, TraceInfo trace, Memory needle, @Runtime.Reference Memory array, boolean strict) {
        if (ArrayFunctions.expecting(env, trace, 2, array, Memory.Type.ARRAY)) {
            ForeachIterator iterator = array.getNewIterator(env, false, false);
            while (iterator.next()) {
                if (!(strict ? needle.identical(iterator.getValue()) : needle.equal(iterator.getValue()))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Runtime.Immutable(ignoreRefs=true)
    public static boolean in_array(Environment env, TraceInfo trace, Memory needle, @Runtime.Reference Memory array) {
        return ArrayFunctions.in_array(env, trace, needle, array, false);
    }

    @Runtime.Immutable(ignoreRefs=true)
    public static boolean array_key_exists(Environment env, TraceInfo trace, Memory key, @Runtime.Reference Memory array) {
        if (ArrayFunctions.expecting(env, trace, 2, array, Memory.Type.ARRAY)) {
            ArrayMemory tmp = array.toValue(ArrayMemory.class);
            return tmp.get(key) != null;
        }
        return false;
    }

    @Runtime.Immutable(ignoreRefs=true)
    public static boolean key_exists(Environment env, TraceInfo trace, Memory key, @Runtime.Reference Memory array) {
        return ArrayFunctions.array_key_exists(env, trace, key, array);
    }

    public static Memory reset(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        if (ArrayFunctions.expectingReference(env, trace, array, "reset") && ArrayFunctions.expecting(env, trace, 1, array, Memory.Type.ARRAY)) {
            ArrayMemory memory = array.toValue(ArrayMemory.class);
            return memory.resetCurrentIterator().toImmutable();
        }
        return Memory.FALSE;
    }

    public static Memory next(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        if (ArrayFunctions.expectingReference(env, trace, array, "next") && ArrayFunctions.expecting(env, trace, 1, array, Memory.Type.ARRAY)) {
            ArrayMemory memory = array.toValue(ArrayMemory.class);
            ForeachIterator iterator = memory.getCurrentIterator();
            if (iterator.next()) {
                return iterator.getValue().toImmutable();
            }
            return Memory.FALSE;
        }
        return Memory.FALSE;
    }

    public static Memory prev(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        if (ArrayFunctions.expectingReference(env, trace, array, "prev") && ArrayFunctions.expecting(env, trace, 1, array, Memory.Type.ARRAY)) {
            ArrayMemory memory = array.toValue(ArrayMemory.class);
            ForeachIterator iterator = memory.getCurrentIterator();
            if (iterator.prev()) {
                return iterator.getValue().toImmutable();
            }
            return Memory.FALSE;
        }
        return Memory.FALSE;
    }

    public static Memory current(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        if (ArrayFunctions.expectingReference(env, trace, array, "current") && ArrayFunctions.expecting(env, trace, 1, array, Memory.Type.ARRAY)) {
            Memory value = array.toValue(ArrayMemory.class).getCurrentIterator().getValue();
            return value == null ? Memory.FALSE : value.toImmutable();
        }
        return Memory.FALSE;
    }

    public static Memory key(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        if (ArrayFunctions.expectingReference(env, trace, array, "key") && ArrayFunctions.expecting(env, trace, 1, array, Memory.Type.ARRAY)) {
            Memory value = array.toValue(ArrayMemory.class).getCurrentIterator().getMemoryKey();
            return value == null ? Memory.FALSE : value;
        }
        return Memory.FALSE;
    }

    public static Memory pos(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        return ArrayFunctions.current(env, trace, array);
    }

    public static Memory end(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        if (ArrayFunctions.expectingReference(env, trace, array, "end") && ArrayFunctions.expecting(env, trace, 1, array, Memory.Type.ARRAY)) {
            ForeachIterator iterator = array.toValue(ArrayMemory.class).getCurrentIterator();
            if (iterator.end()) {
                return iterator.getValue().toImmutable();
            }
            return Memory.FALSE;
        }
        return Memory.FALSE;
    }

    public static Memory each(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        if (ArrayFunctions.expectingReference(env, trace, array, "each") && ArrayFunctions.expecting(env, trace, 1, array, Memory.Type.ARRAY)) {
            ForeachIterator iterator = array.toValue(ArrayMemory.class).getCurrentIterator();
            if (iterator.next()) {
                Memory value = iterator.getValue().toImmutable();
                Memory key = iterator.getMemoryKey();
                ArrayMemory result = new ArrayMemory();
                result.refOfIndex(1L).assign(value);
                result.refOfIndex("value").assign(value);
                result.refOfIndex(0L).assign(key);
                result.refOfIndex("key").assign(key);
                return result.toConstant();
            }
            return Memory.FALSE;
        }
        return Memory.FALSE;
    }

    private static Memory _array_merge(Environment env, TraceInfo trace, boolean recursive, Memory array, Memory ... arrays) {
        if (!array.isArray()) {
            env.warning(trace, "Argument %s is not an array", 1);
            return Memory.NULL;
        }
        if (arrays == null || arrays.length == 0) {
            return array;
        }
        ArrayMemory result = (ArrayMemory)array.toImmutable();
        int i = 2;
        HashSet<Integer> used = recursive ? new HashSet<Integer>() : null;
        for (Memory el : arrays) {
            if (!el.isArray()) {
                env.warning(trace, "Argument %s is not an array", i);
                continue;
            }
            if (used != null) {
                used.add(el.getPointer(true));
            }
            result.merge((ArrayMemory)el, recursive, used);
            if (used != null) {
                used.remove(el.getPointer(true));
            }
            ++i;
        }
        return result;
    }

    public static Memory array_merge(Environment env, TraceInfo trace, Memory array, Memory ... arrays) {
        return ArrayFunctions._array_merge(env, trace, false, array, arrays);
    }

    public static Memory array_merge_recursive(Environment env, TraceInfo trace, Memory array, Memory ... arrays) {
        try {
            return ArrayFunctions._array_merge(env, trace, true, array, arrays);
        }
        catch (RecursiveException e) {
            env.warning(trace, "recursion detected", new Object[0]);
            return Memory.NULL;
        }
    }

    public static boolean shuffle(Environment env, TraceInfo trace, @Runtime.Reference Memory value) {
        if (ArrayFunctions.expectingReference(env, trace, value, "shuffle") && ArrayFunctions.expecting(env, trace, 1, value, Memory.Type.ARRAY)) {
            ArrayMemory array = value.toValue(ArrayMemory.class);
            array.shuffle(MathFunctions.RANDOM);
            return true;
        }
        return false;
    }

    public static Memory array_map(Environment env, TraceInfo trace, Memory callback, Memory _array, Memory ... arrays) throws Throwable {
        ForeachIterator[] iterators;
        Invoker invoker = ArrayFunctions.expectingCallback(env, trace, 1, callback);
        if (invoker == null) {
            return Memory.NULL;
        }
        ArrayMemory result = new ArrayMemory();
        if (!ArrayFunctions.expecting(env, trace, 2, _array, Memory.Type.ARRAY)) {
            return Memory.NULL;
        }
        if (arrays == null) {
            iterators = new ForeachIterator[]{_array.getNewIterator(env, false, false)};
        } else {
            iterators = new ForeachIterator[1 + arrays.length];
            iterators[0] = _array.getNewIterator(env, false, false);
            for (int i = 0; i < arrays.length; ++i) {
                if (!ArrayFunctions.expecting(env, trace, i + 3, arrays[i], Memory.Type.ARRAY)) {
                    return Memory.NULL;
                }
                iterators[i + 1] = arrays[i].getNewIterator(env, false, false);
            }
        }
        Memory[] args = new Memory[iterators.length];
        while (true) {
            int i = 0;
            boolean done = true;
            for (ForeachIterator iterator : iterators) {
                if (iterator.next()) {
                    args[i] = iterator.getValue();
                    done = false;
                } else {
                    args[i] = Memory.NULL;
                }
                ++i;
            }
            if (done) break;
            result.add(invoker.call(args));
        }
        return result.toConstant();
    }

    public static Memory array_filter(Environment env, TraceInfo trace, Memory input, Memory callback) throws Throwable {
        if (!ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            return Memory.NULL;
        }
        Invoker invoker = null;
        if (callback != null && callback.toBoolean() && (invoker = ArrayFunctions.expectingCallback(env, trace, 2, callback)) == null) {
            return Memory.NULL;
        }
        ArrayMemory result = new ArrayMemory();
        ForeachIterator iterator = input.getNewIterator(env, true, false);
        while (iterator.next()) {
            Object key = iterator.getKey();
            Memory value = iterator.getValue();
            if (invoker == null ? !value.toBoolean() : !invoker.call(value).toBoolean()) continue;
            result.put(key, value.toImmutable());
        }
        return result.toConstant();
    }

    public static Memory array_filter(Environment env, TraceInfo trace, Memory input) throws Throwable {
        return ArrayFunctions.array_filter(env, trace, input, null);
    }

    public static Memory array_reduce(Environment env, TraceInfo trace, Memory input, Memory callback, Memory initial) throws Throwable {
        if (!ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            return Memory.NULL;
        }
        Invoker invoker = ArrayFunctions.expectingCallback(env, trace, 2, callback);
        if (invoker == null) {
            return Memory.NULL;
        }
        ArrayMemory array = input.toValue(ArrayMemory.class);
        if (array.size() == 0) {
            return Memory.NULL;
        }
        Memory result = initial;
        ForeachIterator iterator = array.getNewIterator(env, true, false);
        while (iterator.next()) {
            Memory el = iterator.getValue();
            result = invoker.call(result, el);
        }
        return result.toValue();
    }

    public static Memory array_reduce(Environment env, TraceInfo trace, Memory input, Memory callback) throws Throwable {
        return ArrayFunctions.array_reduce(env, trace, input, callback, Memory.NULL);
    }

    public static boolean array_walk(Environment env, TraceInfo trace, @Runtime.Reference Memory input, Memory callback, Memory userData) throws Throwable {
        if (!ArrayFunctions.expectingReference(env, trace, input, "array_walk")) {
            return false;
        }
        if (!ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            return false;
        }
        Invoker invoker = ArrayFunctions.expectingCallback(env, trace, 2, callback);
        if (invoker == null) {
            return false;
        }
        ForeachIterator iterator = input.getNewIterator(env, true, false);
        while (iterator.next()) {
            Memory item = iterator.getValue();
            Memory key = iterator.getMemoryKey();
            invoker.call(item, key, userData);
        }
        return true;
    }

    public static boolean array_walk(Environment env, TraceInfo trace, @Runtime.Reference Memory input, Memory callback) throws Throwable {
        return ArrayFunctions.array_walk(env, trace, input, callback, Memory.NULL);
    }

    public static boolean _array_walk_recursive(Environment env, TraceInfo trace, Memory input, Invoker invoker, Memory userData, Set<Integer> used) throws Throwable {
        if (used == null) {
            used = new HashSet<Integer>();
        }
        ForeachIterator iterator = input.getNewIterator(env, true, false);
        while (iterator.next()) {
            Memory item = iterator.getValue();
            if (item.isArray()) {
                if (used.add(item.getPointer())) {
                    boolean result = ArrayFunctions._array_walk_recursive(env, trace, item, invoker, userData, used);
                    used.remove(item.getPointer());
                    if (result) continue;
                    return false;
                }
                env.warning(trace, "array_walk_recursive(): recursion detected", new Object[0]);
                continue;
            }
            Memory key = iterator.getMemoryKey();
            invoker.call(item, key, userData);
        }
        return true;
    }

    public static boolean array_walk_recursive(Environment env, TraceInfo trace, @Runtime.Reference Memory input, Memory callback, Memory userData) throws Throwable {
        if (!ArrayFunctions.expectingReference(env, trace, input, "array_walk_recursive")) {
            return false;
        }
        if (!ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            return false;
        }
        Invoker invoker = ArrayFunctions.expectingCallback(env, trace, 2, callback);
        if (invoker == null) {
            return false;
        }
        HashSet<Integer> used = new HashSet<Integer>();
        used.add(input.getPointer());
        return ArrayFunctions._array_walk_recursive(env, trace, input, invoker, userData, used);
    }

    public static boolean array_walk_recursive(Environment env, TraceInfo trace, Memory input, Memory callback) throws Throwable {
        return ArrayFunctions.array_walk_recursive(env, trace, input, callback, Memory.NULL);
    }

    public static Memory array_flip(Environment env, TraceInfo trace, Memory input) {
        if (!ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            return Memory.NULL;
        }
        ArrayMemory result = new ArrayMemory();
        ForeachIterator iterator = input.getNewIterator(env, false, false);
        while (iterator.next()) {
            result.put(ArrayMemory.toKey(iterator.getValue()), iterator.getMemoryKey());
        }
        return result.toConstant();
    }

    public static Memory array_reverse(Environment env, TraceInfo trace, Memory input, boolean saveKeys) {
        if (!ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            return Memory.NULL;
        }
        ArrayMemory array = input.toValue(ArrayMemory.class);
        ArrayMemory result = new ArrayMemory();
        ForeachIterator iterator = input.getNewIterator(env, false, false);
        Memory[] values = new Memory[array.size()];
        Object[] keys = saveKeys ? new Object[values.length] : null;
        int i = 0;
        while (iterator.next()) {
            if (saveKeys) {
                keys[i] = iterator.getKey();
            }
            values[i] = iterator.getValue().toImmutable();
            ++i;
        }
        for (i = values.length - 1; i >= 0; --i) {
            if (saveKeys) {
                result.put(keys[i], values[i]);
                continue;
            }
            result.add(values[i]);
        }
        return result.toConstant();
    }

    public static Memory array_reverse(Environment env, TraceInfo trace, Memory input) {
        return ArrayFunctions.array_reverse(env, trace, input, false);
    }

    public static Memory array_rand(Environment env, TraceInfo trace, Memory input, int numReq) {
        int i;
        if (!ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            return Memory.NULL;
        }
        ArrayMemory array = input.toValue(ArrayMemory.class);
        int size = array.size();
        if (size < numReq || numReq < 1) {
            env.warning(trace, "array_rand(): Second argument has to be between 1 and the number of elements in the array", new Object[0]);
            return Memory.NULL;
        }
        if (numReq == 1) {
            return array.getRandomElementKey(MathFunctions.RANDOM);
        }
        ForeachIterator iterator = input.getNewIterator(env, false, false);
        HashSet<Integer> rands = new HashSet<Integer>();
        for (i = 0; i < numReq; ++i) {
            while (!rands.add(MathFunctions.rand(0L, size - 1).toInteger())) {
            }
        }
        ArrayMemory result = new ArrayMemory();
        i = -1;
        while (iterator.next()) {
            if (!rands.contains(++i)) continue;
            result.add(iterator.getMemoryKey());
            if (result.size() < numReq) continue;
            break;
        }
        return result.toConstant();
    }

    public static Memory array_rand(Environment env, TraceInfo trace, Memory input) {
        return ArrayFunctions.array_rand(env, trace, input, 1);
    }

    public static Memory array_pop(Environment env, TraceInfo trace, @Runtime.Reference Memory input) {
        if (!ArrayFunctions.expectingReference(env, trace, input, "array_pop")) {
            return Memory.NULL;
        }
        if (!ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            return Memory.NULL;
        }
        Memory value = input.toValue(ArrayMemory.class).pop();
        return value == null ? Memory.NULL : value.toImmutable();
    }

    public static Memory array_push(Environment env, TraceInfo trace, @Runtime.Reference Memory input, Memory var, Memory ... args) {
        if (!ArrayFunctions.expectingReference(env, trace, input, "array_push")) {
            return Memory.NULL;
        }
        if (!ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            return Memory.NULL;
        }
        ArrayMemory array = input.toValue(ArrayMemory.class);
        array.add(var);
        if (args != null) {
            for (Memory arg : args) {
                array.add(arg);
            }
        }
        return LongMemory.valueOf(array.size());
    }

    public static Memory array_shift(Environment env, TraceInfo trace, @Runtime.Reference Memory input) {
        if (!ArrayFunctions.expectingReference(env, trace, input, "array_shift")) {
            return Memory.NULL;
        }
        if (!ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            return Memory.NULL;
        }
        Memory value = input.toValue(ArrayMemory.class).shift();
        return value == null ? Memory.NULL : value.toImmutable();
    }

    public static Memory array_unshift(Environment env, TraceInfo trace, @Runtime.Reference Memory input, Memory var, Memory ... args) {
        Memory[] tmp;
        Memory[] memoryArray;
        if (!ArrayFunctions.expectingReference(env, trace, input, "array_unshift")) {
            return Memory.NULL;
        }
        if (!ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            return Memory.NULL;
        }
        ArrayMemory array = input.toValue(ArrayMemory.class);
        if (args == null) {
            Memory[] memoryArray2 = new Memory[1];
            memoryArray = memoryArray2;
            memoryArray2[0] = var;
        } else {
            memoryArray = tmp = new Memory[args.length + 1];
        }
        if (args != null) {
            tmp[0] = var;
            System.arraycopy(args, 0, tmp, 1, args.length);
        }
        array.unshift(tmp);
        return LongMemory.valueOf(array.size());
    }

    public static Memory array_values(Environment env, TraceInfo trace, Memory input) {
        if (!ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            return Memory.NULL;
        }
        Memory[] values = input.toValue(ArrayMemory.class).values();
        return ArrayMemory.of(values).toConstant();
    }

    public static Memory array_keys(Environment env, TraceInfo trace, Memory input) {
        return ArrayFunctions.array_keys(env, trace, input, null);
    }

    public static Memory array_keys(Environment env, TraceInfo trace, Memory input, Memory search) {
        return ArrayFunctions.array_keys(env, trace, input, search, false);
    }

    public static Memory array_keys(Environment env, TraceInfo trace, Memory input, Memory search, boolean strict) {
        if (!ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            return Memory.NULL;
        }
        ArrayMemory result = new ArrayMemory();
        ForeachIterator iterator = input.getNewIterator(env, false, false);
        while (iterator.next()) {
            if (search == null) {
                result.add(iterator.getMemoryKey());
                continue;
            }
            if (strict && iterator.getValue().identical(search)) {
                result.add(iterator.getMemoryKey());
                continue;
            }
            if (!iterator.getValue().equal(search)) continue;
            result.add(iterator.getMemoryKey());
        }
        return result.toConstant();
    }

    public static Memory array_pad(Environment env, TraceInfo trace, Memory input, int padSize, Memory padValue) {
        if (ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            ArrayMemory array = input.toValue(ArrayMemory.class);
            int size = array.size();
            int needSize = Math.abs(padSize);
            ArrayMemory result = input.toImmutable().toValue(ArrayMemory.class);
            if (size == needSize) {
                return result;
            }
            result.checkCopied();
            int count = needSize - size;
            if (padSize >= 0) {
                for (int i = 0; i < needSize - size; ++i) {
                    result.add(padValue);
                }
            } else {
                result.unshift(padValue, count);
            }
            return result;
        }
        return Memory.NULL;
    }

    public static Memory array_product(Environment env, TraceInfo trace, Memory input) {
        if (ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            ForeachIterator iterator = input.getNewIterator(env, false, false);
            Memory result = Memory.CONST_INT_1;
            while (iterator.next()) {
                result = result.mul(iterator.getValue());
            }
            return result;
        }
        return Memory.NULL;
    }

    public static Memory array_sum(Environment env, TraceInfo trace, Memory input) {
        if (ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            ForeachIterator iterator = input.getNewIterator(env, false, false);
            Memory result = Memory.CONST_INT_0;
            while (iterator.next()) {
                result = result.plus(iterator.getValue());
            }
            return result;
        }
        return Memory.NULL;
    }

    public static Memory array_change_key_case(Environment env, TraceInfo trace, Memory input, int _case) {
        if (ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            ArrayMemory result = new ArrayMemory();
            ForeachIterator iterator = input.getNewIterator(env, false, false);
            while (iterator.next()) {
                Object key = iterator.getKey();
                if (key instanceof String) {
                    String str = (String)key;
                    str = _case == 0 ? str.toLowerCase() : str.toUpperCase();
                    result.put(str, iterator.getValue().toImmutable());
                    continue;
                }
                result.put(key, iterator.getValue().toImmutable());
            }
            return result.toConstant();
        }
        return Memory.NULL;
    }

    public static Memory array_change_key_case(Environment env, TraceInfo trace, Memory input) {
        return ArrayFunctions.array_change_key_case(env, trace, input, 0);
    }

    public static Memory array_chunk(Environment env, TraceInfo trace, Memory input, int size, boolean saveKeys) {
        if (ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            if (size < 1) {
                env.warning(trace, "array_chunk(): Size parameter expected to be greater than 0", new Object[0]);
                return Memory.NULL;
            }
            ArrayMemory result = new ArrayMemory();
            ArrayMemory item = null;
            ForeachIterator iterator = input.getNewIterator(env, false, false);
            int i = 0;
            while (iterator.next()) {
                if (i == 0) {
                    item = new ArrayMemory();
                    result.add(item);
                }
                if (saveKeys) {
                    item.put(iterator.getKey(), iterator.getValue().toImmutable());
                } else {
                    item.add(iterator.getValue().toImmutable());
                }
                if (++i != size) continue;
                i = 0;
            }
            return result.toConstant();
        }
        return Memory.NULL;
    }

    public static Memory array_chunk(Environment env, TraceInfo trace, Memory input, int size) {
        return ArrayFunctions.array_chunk(env, trace, input, size, false);
    }

    public static Memory array_column(Environment env, TraceInfo trace, Memory input, Memory columnKey, Memory indexKey) {
        if (ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            if (columnKey.isNull() && indexKey.isNull()) {
                return ArrayFunctions.array_values(env, trace, input);
            }
            ArrayMemory result = new ArrayMemory();
            ForeachIterator iterator = input.getNewIterator(env, false, false);
            while (iterator.next()) {
                Memory value = iterator.getValue();
                if (indexKey.isNull()) {
                    result.add(value.valueOfIndex(columnKey).toImmutable());
                    continue;
                }
                if (columnKey.isNull()) {
                    result.refOfIndex(value.valueOfIndex(indexKey)).assign(value.toImmutable());
                    continue;
                }
                result.refOfIndex(value.valueOfIndex(indexKey)).assign(value.valueOfIndex(columnKey));
            }
            return result.toConstant();
        }
        return Memory.NULL;
    }

    public static Memory array_column(Environment env, TraceInfo trace, Memory input, Memory columnKey) {
        return ArrayFunctions.array_column(env, trace, input, columnKey, Memory.NULL);
    }

    public static Memory array_combine(Environment env, TraceInfo trace, Memory keys, Memory values) {
        if (ArrayFunctions.expecting(env, trace, 1, keys, Memory.Type.ARRAY) && ArrayFunctions.expecting(env, trace, 2, values, Memory.Type.ARRAY)) {
            int size2;
            ArrayMemory _keys = keys.toValue(ArrayMemory.class);
            ArrayMemory _values = values.toValue(ArrayMemory.class);
            int size1 = _keys.size();
            if (size1 != (size2 = _values.size())) {
                env.warning(trace, "array_combine(): Both parameters should have an equal number of elements", new Object[0]);
                return Memory.FALSE;
            }
            ArrayMemory result = new ArrayMemory();
            if (size1 == 0) {
                return result.toConstant();
            }
            ForeachIterator iteratorKeys = _keys.getNewIterator(env, false, false);
            ForeachIterator iteratorValues = _values.getNewIterator(env, false, false);
            while (iteratorKeys.next()) {
                iteratorValues.next();
                result.refOfIndex(iteratorKeys.getValue()).assign(iteratorValues.getValue().toImmutable());
            }
            return result.toConstant();
        }
        return Memory.FALSE;
    }

    public static Memory array_count_values(Environment env, TraceInfo trace, Memory input) {
        if (ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            ArrayMemory counts = new ArrayMemory();
            ForeachIterator iterator = input.getNewIterator(env, false, false);
            boolean warning = false;
            block3: while (iterator.next()) {
                Memory value = iterator.getValue();
                switch (value.getRealType()) {
                    case INT: 
                    case STRING: {
                        ReferenceMemory count = counts.getOrCreate(value);
                        ((Memory)count).assign(((Memory)count).inc());
                        continue block3;
                    }
                }
                if (warning) continue;
                env.warning(trace, "array_count_values(): Can only count STRING and INTEGER values!", new Object[0]);
                warning = true;
            }
            return counts.toConstant();
        }
        return Memory.NULL;
    }

    public static Memory array_search(Environment env, TraceInfo trace, Memory input, Memory needle, boolean strict) {
        if (ArrayFunctions.expecting(env, trace, 1, input, Memory.Type.ARRAY)) {
            ForeachIterator iterator = input.getNewIterator(env, false, false);
            while (iterator.next()) {
                Memory value = iterator.getValue();
                if (strict && needle.identical(value)) {
                    return iterator.getMemoryKey();
                }
                if (!needle.equal(value)) continue;
                return iterator.getMemoryKey();
            }
            return Memory.FALSE;
        }
        return Memory.FALSE;
    }

    private static Memory _range_double(Environment env, TraceInfo trace, double low, double high, double step) {
        ArrayMemory result = new ArrayMemory();
        long i = 0L;
        boolean error_occurred = false;
        if (step < 0.0) {
            step *= -1.0;
        }
        if (low > high) {
            if (low - high < step || step <= 0.0) {
                error_occurred = true;
            } else {
                double value = low;
                while (value >= high) {
                    result.add(value);
                    value = low - (double)(++i) * step;
                }
            }
        } else if (high > low) {
            if (high - low < step || step <= 0.0) {
                error_occurred = true;
            } else {
                double value = low;
                while (value <= high) {
                    result.add(value);
                    value = low + (double)(++i) * step;
                }
            }
        } else {
            result.add(low);
        }
        if (error_occurred) {
            env.warning(trace, "range(): step exceeds the specified range", new Object[0]);
            return Memory.FALSE;
        }
        return result.toConstant();
    }

    private static Memory _range_long(Environment env, TraceInfo trace, long low, long high, long step) {
        ArrayMemory result = new ArrayMemory();
        boolean error_occurred = false;
        if (step < 0L) {
            step *= -1L;
        }
        if (low > high) {
            if (low - high < step || step <= 0L) {
                error_occurred = true;
            } else {
                while (low >= high) {
                    result.add(low);
                    low -= step;
                }
            }
        } else if (high > low) {
            if (high - low < step || step <= 0L) {
                error_occurred = true;
            } else {
                while (low <= high) {
                    result.add(low);
                    low += step;
                }
            }
        } else {
            result.add(low);
        }
        if (error_occurred) {
            env.warning(trace, "range(): step exceeds the specified range", new Object[0]);
            return Memory.FALSE;
        }
        return result.toConstant();
    }

    public static Memory range(Environment env, TraceInfo trace, Memory low, Memory high, Memory step) {
        if (low.getRealType() == Memory.Type.DOUBLE || high.getRealType() == Memory.Type.DOUBLE || step.getRealType() == Memory.Type.DOUBLE) {
            return ArrayFunctions._range_double(env, trace, low.toDouble(), high.toDouble(), step.toDouble());
        }
        return ArrayFunctions._range_long(env, trace, low.toLong(), high.toLong(), step.toLong());
    }

    public static Memory range(Environment env, TraceInfo trace, Memory low, Memory high) {
        return ArrayFunctions.range(env, trace, low, high, Memory.CONST_INT_1);
    }

    public static Memory array_fill(int start, int num, Memory value) {
        ArrayMemory result = new ArrayMemory();
        if (start >= 0) {
            for (int i = start; i < start + num; ++i) {
                if (start == 0) {
                    result.add(value);
                    continue;
                }
                result.refOfIndex(i).assign(value);
            }
        } else {
            result.refOfIndex(start).assign(value);
            for (int i = 0; i < num - 1; ++i) {
                result.refOfIndex(i).assign(value);
            }
        }
        return result.toConstant();
    }

    public static Memory array_fill_keys(Environment env, TraceInfo trace, Memory keys, Memory value) {
        if (ArrayFunctions.expecting(env, trace, 1, keys, Memory.Type.ARRAY)) {
            ForeachIterator iterator = keys.getNewIterator(env);
            ArrayMemory result = new ArrayMemory();
            while (iterator.next()) {
                result.refOfIndex(iterator.getValue()).assign(value.toImmutable());
            }
            return result.toConstant();
        }
        return new ArrayMemory().toConstant();
    }

    public static Memory array_unique(Environment env, TraceInfo trace, Memory array) {
        return ArrayFunctions.array_unique(env, trace, array, 0);
    }

    public static Memory array_unique(Environment env, TraceInfo trace, Memory array, int flag) {
        if (ArrayFunctions.expecting(env, trace, 1, array, Memory.Type.ARRAY)) {
            TreeSet<Object> keys = new TreeSet<Object>();
            ArrayMemory newArray = new ArrayMemory();
            ForeachIterator iterator = array.getNewIterator(env);
            while (iterator.next()) {
                Object key;
                switch (flag) {
                    case 1: {
                        key = iterator.getValue().toLong();
                        break;
                    }
                    case 2: {
                        key = iterator.getValue().toBinaryString();
                        break;
                    }
                    case 5: {
                        key = iterator.getValue().toString();
                        break;
                    }
                    default: {
                        key = iterator.getValue().toString();
                    }
                }
                if (!keys.add(key)) continue;
                newArray.put(iterator.getKey(), iterator.getValue().toImmutable());
            }
            return newArray.toConstant();
        }
        return Memory.NULL;
    }

    public static Memory array_replace(Environment env, TraceInfo trace, Memory array, Memory replacement, Memory ... replacements) {
        if (ArrayFunctions.expecting(env, trace, 1, array, Memory.Type.ARRAY) && ArrayFunctions.expecting(env, trace, 2, replacement, Memory.Type.ARRAY)) {
            ArrayMemory result = array.toValue(ArrayMemory.class).duplicate();
            for (int i = 0; i < (replacements == null ? 0 : replacements.length) + 1; ++i) {
                if (i > 0 && !ArrayFunctions.expecting(env, trace, i + 2, replacement = replacements[i - 1], Memory.Type.ARRAY)) {
                    return Memory.NULL;
                }
                ForeachIterator iterator = replacement.getNewIterator(env);
                while (iterator.next()) {
                    result.put(iterator.getKey(), iterator.getValue().toImmutable());
                }
            }
            return result;
        }
        return Memory.NULL;
    }

    protected static Memory _array_diff_impl(Environment env, TraceInfo trace, Memory array1, Memory array, Memory[] arrays, ArrayDiffCallback callback) throws Throwable {
        if (ArrayFunctions.expecting(env, trace, 1, array1, Memory.Type.ARRAY) && ArrayFunctions.expecting(env, trace, 2, array, Memory.Type.ARRAY)) {
            ForeachIterator iterator = array1.getNewIterator(env);
            ArrayMemory result = new ArrayMemory();
            while (iterator.next()) {
                Memory value = iterator.getValue();
                boolean exists = false;
                for (int i = 0; i < (arrays == null ? 0 : arrays.length) + 1; ++i) {
                    if (i > 0 && !ArrayFunctions.expecting(env, trace, i + 2, array = arrays[i - 1], Memory.Type.ARRAY)) {
                        return Memory.NULL;
                    }
                    ForeachIterator newIterator = array.getNewIterator(env);
                    while (newIterator.next()) {
                        if (!callback.apply(iterator.getMemoryKey(), value, newIterator.getMemoryKey(), newIterator.getValue())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) break;
                }
                if (exists) continue;
                result.put(iterator.getKey(), value.toImmutable());
            }
            return result.toConstant();
        }
        return Memory.NULL;
    }

    public static Memory array_diff(Environment env, TraceInfo trace, Memory array1, Memory array, Memory ... arrays) throws Throwable {
        return ArrayFunctions._array_diff_impl(env, trace, array1, array, arrays, new ArrayDiffCallback(){

            @Override
            public boolean apply(Memory keyValue, Memory value, Memory keyComparable, Memory comparable) {
                return value.toString().equals(comparable.toString());
            }
        });
    }

    public static Memory array_diff_key(Environment env, TraceInfo trace, Memory array1, Memory array, Memory ... arrays) throws Throwable {
        return ArrayFunctions._array_diff_impl(env, trace, array1, array, arrays, new ArrayDiffCallback(){

            @Override
            public boolean apply(Memory keyValue, Memory value, Memory keyComparable, Memory comparable) {
                return keyValue.equal(keyComparable);
            }
        });
    }

    public static Memory array_diff_assoc(Environment env, TraceInfo trace, Memory array1, Memory array, Memory ... arrays) throws Throwable {
        return ArrayFunctions._array_diff_impl(env, trace, array1, array, arrays, new ArrayDiffCallback(){

            @Override
            public boolean apply(Memory keyValue, Memory value, Memory keyComparable, Memory comparable) {
                return keyValue.equal(keyComparable) && value.toString().equals(comparable.toString());
            }
        });
    }

    protected static Memory _array_udiff_impl(Environment env, TraceInfo trace, Memory array1, Memory array, final boolean assoc, Memory ... arrays) throws Throwable {
        if (arrays == null) {
            ArrayFunctions.expectingCallback(env, trace, 3, Memory.NULL);
            return Memory.NULL;
        }
        Memory callback = arrays[arrays.length - 1];
        final Invoker expectingCallback = ArrayFunctions.expectingCallback(env, trace, arrays.length + 2, callback);
        if (expectingCallback != null) {
            return ArrayFunctions._array_diff_impl(env, trace, array1, array, Arrays.copyOf(arrays, arrays.length - 1), new ArrayDiffCallback(){

                @Override
                public boolean apply(Memory keyValue, Memory value, Memory keyComparable, Memory comparable) throws Throwable {
                    if (assoc && keyValue.notEqual(keyComparable)) {
                        return false;
                    }
                    Memory memory = expectingCallback.call(value, comparable);
                    return memory.toInteger() == 0;
                }
            });
        }
        return Memory.NULL;
    }

    public static Memory array_udiff(Environment env, TraceInfo trace, Memory array1, Memory array, Memory ... arrays) throws Throwable {
        return ArrayFunctions._array_udiff_impl(env, trace, array1, array, false, arrays);
    }

    public static Memory array_udiff_assoc(Environment env, TraceInfo trace, Memory array1, Memory array, Memory ... arrays) throws Throwable {
        return ArrayFunctions._array_udiff_impl(env, trace, array1, array, true, arrays);
    }

    public static Memory array_slice(Environment env, TraceInfo trace, Memory array, int offset) {
        return ArrayFunctions.array_slice(env, trace, array, offset, Memory.NULL);
    }

    public static Memory array_slice(Environment env, TraceInfo trace, Memory array, int offset, Memory length) {
        return ArrayFunctions.array_slice(env, trace, array, offset, length, false);
    }

    public static Memory array_slice(Environment env, TraceInfo trace, Memory array, int offset, Memory length, boolean preserveKeys) {
        if (ArrayFunctions.expecting(env, trace, 1, array, Memory.Type.ARRAY)) {
            ArrayMemory arrayMemory = array.toValue(ArrayMemory.class);
            try {
                return (length.isNull() ? arrayMemory.slice(offset, preserveKeys) : arrayMemory.slice(offset, length.toInteger(), preserveKeys)).toConstant();
            }
            catch (IndexOutOfBoundsException e) {
                return new ArrayMemory().toConstant();
            }
        }
        return Memory.NULL;
    }

    protected static Comparator<Memory> makeComparatorForUSort(final Environment env, final Invoker invoker) {
        return new Comparator<Memory>(){

            @Override
            public int compare(Memory o1, Memory o2) {
                if (invoker == null) {
                    return 0;
                }
                try {
                    return invoker.call(o1, o2).toInteger();
                }
                catch (Throwable throwable) {
                    env.forwardThrow(throwable);
                    return 0;
                }
            }
        };
    }

    protected static Comparator makeComparatorForSort(int flags, final boolean revert) {
        switch (flags) {
            case 1: {
                return new Comparator<Memory>(){

                    @Override
                    public int compare(Memory o1, Memory o2) {
                        return (o1 = o1.toNumeric()).equal(o2 = o2.toNumeric()) ? 0 : (o1.greater(o2) ? 1 : -1) * (revert ? -1 : 1);
                    }
                };
            }
            case 10: 
            case 13: {
                return new Comparator<Memory>(){

                    @Override
                    public int compare(Memory o1, Memory o2) {
                        String s2;
                        String s1 = o1.toString();
                        int cmp = s1.compareToIgnoreCase(s2 = o2.toString());
                        return cmp == 0 ? 0 : (cmp < 0 ? -1 : 1) * (revert ? -1 : 1);
                    }
                };
            }
            case 2: 
            case 5: {
                return new Comparator<Memory>(){

                    @Override
                    public int compare(Memory o1, Memory o2) {
                        String s2;
                        String s1 = o1.toString();
                        int cmp = s1.compareTo(s2 = o2.toString());
                        return cmp == 0 ? 0 : (cmp < 0 ? -1 : 1) * (revert ? -1 : 1);
                    }
                };
            }
            case 14: {
                return new NaturalOrderComparator(true, revert);
            }
            case 6: {
                return new NaturalOrderComparator(false, revert);
            }
        }
        return new Comparator<Memory>(){

            @Override
            public int compare(Memory o1, Memory o2) {
                return o1.compareTo(o2) * (revert ? -1 : 1);
            }
        };
    }

    protected static boolean _sort_impl(Environment env, TraceInfo trace, @Runtime.Reference Memory array, int flags, boolean revert) {
        return ArrayFunctions._sort_impl(env, trace, array, ArrayFunctions.makeComparatorForSort(flags, revert));
    }

    protected static boolean _sort_impl(Environment env, TraceInfo trace, @Runtime.Reference Memory array, Comparator comparator) {
        if (ArrayFunctions.expecting(env, trace, 1, array, Memory.Type.ARRAY)) {
            ArrayMemory arrayMemory = array.toValue(ArrayMemory.class);
            Memory[] values = arrayMemory.values();
            arrayMemory.clear();
            try {
                Arrays.sort(values, comparator);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            for (Memory value : values) {
                arrayMemory.add(value);
            }
            return true;
        }
        return false;
    }

    public static boolean sort(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        return ArrayFunctions.sort(env, trace, array, 0);
    }

    public static boolean sort(Environment env, TraceInfo trace, @Runtime.Reference Memory array, int flags) {
        return ArrayFunctions._sort_impl(env, trace, array, flags, false);
    }

    public static boolean rsort(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        return ArrayFunctions.rsort(env, trace, array, 0);
    }

    public static boolean rsort(Environment env, TraceInfo trace, @Runtime.Reference Memory array, int flags) {
        return ArrayFunctions._sort_impl(env, trace, array, flags, true);
    }

    protected static boolean _asort_impl(Environment env, TraceInfo trace, @Runtime.Reference Memory array, int flags, boolean revert) {
        return ArrayFunctions._asort_impl(env, trace, array, ArrayFunctions.makeComparatorForSort(flags, revert));
    }

    protected static boolean _asort_impl(Environment env, TraceInfo trace, @Runtime.Reference Memory array, Comparator comparator) {
        if (ArrayFunctions.expecting(env, trace, 1, array, Memory.Type.ARRAY)) {
            ArrayMemory arrayMemory = array.toValue(ArrayMemory.class);
            Memory[] values = new Memory[arrayMemory.size()];
            ForeachIterator iterator = arrayMemory.getNewIterator(env);
            int i = 0;
            while (iterator.next()) {
                values[i++] = new KeyValueMemory(iterator.getMemoryKey(), iterator.getValue());
            }
            arrayMemory.clear();
            try {
                Arrays.sort(values, comparator);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            for (Memory value : values) {
                arrayMemory.add(value);
            }
            return true;
        }
        return false;
    }

    public static boolean asort(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        return ArrayFunctions.asort(env, trace, array, 0);
    }

    public static boolean asort(Environment env, TraceInfo trace, @Runtime.Reference Memory array, int flags) {
        return ArrayFunctions._asort_impl(env, trace, array, flags, false);
    }

    public static boolean arsort(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        return ArrayFunctions.arsort(env, trace, array, 0);
    }

    public static boolean arsort(Environment env, TraceInfo trace, @Runtime.Reference Memory array, int flags) {
        return ArrayFunctions._asort_impl(env, trace, array, flags, true);
    }

    public static boolean natsort(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        return ArrayFunctions._asort_impl(env, trace, array, 6, false);
    }

    public static boolean natcasesort(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        return ArrayFunctions._asort_impl(env, trace, array, 14, false);
    }

    protected static boolean _ksort_impl(Environment env, TraceInfo trace, @Runtime.Reference Memory array, int flags, boolean revert) {
        return ArrayFunctions._ksort_impl(env, trace, array, ArrayFunctions.makeComparatorForSort(flags, revert));
    }

    protected static boolean _ksort_impl(Environment env, TraceInfo trace, @Runtime.Reference Memory array, Comparator comparator) {
        if (ArrayFunctions.expecting(env, trace, 1, array, Memory.Type.ARRAY)) {
            ArrayMemory arrayMemory = array.toValue(ArrayMemory.class);
            Memory[] values = new Memory[arrayMemory.size()];
            ForeachIterator iterator = arrayMemory.getNewIterator(env);
            int i = 0;
            while (iterator.next()) {
                values[i++] = iterator.getMemoryKey();
            }
            try {
                Arrays.sort(values, comparator);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            ArrayMemory newArray = new ArrayMemory();
            for (Memory value : values) {
                newArray.refOfIndex(value).assign(arrayMemory.valueOfIndex(value));
                arrayMemory.remove(value);
            }
            array.assign(newArray);
            return true;
        }
        return false;
    }

    public static boolean ksort(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        return ArrayFunctions.ksort(env, trace, array, 0);
    }

    public static boolean ksort(Environment env, TraceInfo trace, @Runtime.Reference Memory array, int flags) {
        return ArrayFunctions._ksort_impl(env, trace, array, flags, false);
    }

    public static boolean krsort(Environment env, TraceInfo trace, @Runtime.Reference Memory array) {
        return ArrayFunctions.krsort(env, trace, array, 0);
    }

    public static boolean krsort(Environment env, TraceInfo trace, @Runtime.Reference Memory array, int flags) {
        return ArrayFunctions._ksort_impl(env, trace, array, flags, true);
    }

    protected static boolean _usort_impl(Environment env, TraceInfo trace, @Runtime.Reference Memory array, Memory callback) {
        Invoker invoker = ArrayFunctions.expectingCallback(env, trace, 2, callback);
        if (invoker != null) {
            return ArrayFunctions._sort_impl(env, trace, array, ArrayFunctions.makeComparatorForUSort(env, invoker));
        }
        return false;
    }

    public static boolean usort(Environment env, TraceInfo trace, @Runtime.Reference Memory array, Memory callback) {
        return ArrayFunctions._usort_impl(env, trace, array, callback);
    }

    protected static boolean _uasort_impl(Environment env, TraceInfo trace, @Runtime.Reference Memory array, Memory callback) {
        Invoker invoker = ArrayFunctions.expectingCallback(env, trace, 2, callback);
        if (invoker != null) {
            return ArrayFunctions._asort_impl(env, trace, array, ArrayFunctions.makeComparatorForUSort(env, invoker));
        }
        return false;
    }

    public static boolean uasort(Environment env, TraceInfo trace, @Runtime.Reference Memory array, Memory callback) {
        return ArrayFunctions._uasort_impl(env, trace, array, callback);
    }

    protected static boolean _uksort_impl(Environment env, TraceInfo trace, @Runtime.Reference Memory array, Memory callback) {
        Invoker invoker = ArrayFunctions.expectingCallback(env, trace, 2, callback);
        if (invoker != null) {
            return ArrayFunctions._ksort_impl(env, trace, array, ArrayFunctions.makeComparatorForUSort(env, invoker));
        }
        return false;
    }

    public static boolean uksort(Environment env, TraceInfo trace, @Runtime.Reference Memory array, Memory callback) {
        return ArrayFunctions._uksort_impl(env, trace, array, callback);
    }

    static interface ArrayDiffCallback {
        public boolean apply(Memory var1, Memory var2, Memory var3, Memory var4) throws Throwable;
    }
}

