/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.zend.ext.standard;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.ext.support.compile.FunctionsContainer;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringMemory;

public class BCMathFunctions
extends FunctionsContainer {
    private static final BigDecimal DECIMAL_TWO = new BigDecimal(2);
    private static final BigInteger INTEGER_MAX = new BigInteger("2147483647");

    private static int getScale(Environment env) {
        Memory value = env.getConfigValue("bcmath.scale");
        return value == null ? 0 : value.toInteger();
    }

    private static BigDecimal toBigDecimal(Memory value) {
        try {
            switch (value.type) {
                case DOUBLE: {
                    return BigDecimal.valueOf(value.toDouble());
                }
                case INT: {
                    return BigDecimal.valueOf(value.toLong());
                }
            }
            return new BigDecimal(value.toString());
        }
        catch (NumberFormatException ex) {
            return BigDecimal.ZERO;
        }
        catch (IllegalArgumentException ex) {
            return BigDecimal.ZERO;
        }
    }

    public static Memory bcadd(Environment env, Memory left, Memory right, int scale) {
        BigDecimal bd1 = BCMathFunctions.toBigDecimal(left);
        BigDecimal bd2 = BCMathFunctions.toBigDecimal(right);
        BigDecimal bd = bd1.add(bd2);
        bd = bd.setScale(scale, RoundingMode.DOWN);
        return new StringMemory(bd.toPlainString());
    }

    public static Memory bcadd(Environment env, Memory left, Memory right) {
        return BCMathFunctions.bcadd(env, left, right, BCMathFunctions.getScale(env));
    }

    public static int bccomp(Environment env, Memory left, Memory right, int scale) {
        BigDecimal bd1 = BCMathFunctions.toBigDecimal(left);
        BigDecimal bd2 = BCMathFunctions.toBigDecimal(right);
        bd1 = bd1.setScale(scale, RoundingMode.DOWN);
        bd2 = bd2.setScale(scale, RoundingMode.DOWN);
        return bd1.compareTo(bd2);
    }

    public static int bccomp(Environment env, Memory left, Memory right) {
        return BCMathFunctions.bccomp(env, left, right, BCMathFunctions.getScale(env));
    }

    public static Memory bcdiv(Environment env, Memory left, Memory right, int scale) {
        BigDecimal bd1 = BCMathFunctions.toBigDecimal(left);
        BigDecimal bd2 = BCMathFunctions.toBigDecimal(right);
        if (bd2.compareTo(BigDecimal.ZERO) == 0) {
            return Memory.NULL;
        }
        BigDecimal result = scale > 0 ? bd1.divide(bd2, scale + 2, RoundingMode.DOWN) : bd1.divide(bd2, 2, RoundingMode.DOWN);
        result = result.setScale(scale, RoundingMode.DOWN);
        return new StringMemory(result.toPlainString());
    }

    public static Memory bcdiv(Environment env, Memory left, Memory right) {
        return BCMathFunctions.bcdiv(env, left, right, BCMathFunctions.getScale(env));
    }

    public static Memory bcmod(Memory left, Memory modus) {
        BigDecimal base = BCMathFunctions.toBigDecimal(left).setScale(0, RoundingMode.DOWN);
        BigDecimal mod = BCMathFunctions.toBigDecimal(modus).setScale(0, RoundingMode.DOWN);
        if (mod.compareTo(BigDecimal.ZERO) == 0) {
            return Memory.NULL;
        }
        return new StringMemory(base.remainder(mod, MathContext.UNLIMITED).toString());
    }

    public static Memory bcmul(Environment env, Memory left, Memory right, int scale) {
        BigDecimal bd2;
        BigDecimal bd1 = BCMathFunctions.toBigDecimal(left);
        BigDecimal bd = bd1.multiply(bd2 = BCMathFunctions.toBigDecimal(right));
        if (bd.compareTo(BigDecimal.ZERO) == 0) {
            if (scale > 0) {
                return new StringMemory("0.0");
            }
            return new StringMemory("0");
        }
        bd = bd.setScale(scale, RoundingMode.DOWN);
        bd = bd.stripTrailingZeros();
        return new StringMemory(bd.toPlainString());
    }

    public static Memory bcmul(Environment env, Memory left, Memory right) {
        return BCMathFunctions.bcmul(env, left, right, BCMathFunctions.getScale(env));
    }

    public static boolean bcscale(Environment env, int scale) {
        env.getConfigValue("bcmath.scale", LongMemory.valueOf(scale));
        return true;
    }

    public static String bcpow(Environment env, Memory base, Memory exp, int scale) {
        BigDecimal baseD = BCMathFunctions.toBigDecimal(base);
        BigDecimal expD = BCMathFunctions.toBigDecimal(exp);
        BigInteger expI = expD.toBigInteger();
        return BCMathFunctions.bcpowImpl(baseD, expI, scale).toPlainString();
    }

    public static String bcpow(Environment env, Memory base, Memory exp) {
        return BCMathFunctions.bcpow(env, base, exp, BCMathFunctions.getScale(env));
    }

    private static BigDecimal bcpowImpl(BigDecimal base, BigInteger exp, int scale) {
        boolean isNeg;
        if (exp.compareTo(BigInteger.ZERO) == 0) {
            return BigDecimal.ONE;
        }
        if (exp.compareTo(BigInteger.ZERO) < 0) {
            isNeg = true;
            exp = exp.negate();
        } else {
            isNeg = false;
        }
        BigDecimal result = BigDecimal.ZERO;
        while (exp.compareTo(BigInteger.ZERO) > 0) {
            BigInteger expSub = exp.min(INTEGER_MAX);
            exp = exp.subtract(expSub);
            result = result.add(base.pow(expSub.intValue()));
        }
        if (isNeg) {
            result = BigDecimal.ONE.divide(result, scale + 2, RoundingMode.DOWN);
        }
        if ((result = result.setScale(scale, RoundingMode.DOWN)).compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        result = result.stripTrailingZeros();
        return result;
    }

    public static String bcpowmod(Environment env, Memory _base, Memory _exp, Memory _modulus, int scale) {
        BigDecimal base = BCMathFunctions.toBigDecimal(_base);
        BigDecimal exp = BCMathFunctions.toBigDecimal(_exp);
        BigDecimal modulus = BCMathFunctions.toBigDecimal(_modulus);
        if (base.scale() != 0) {
            BigInteger expI = exp.toBigInteger();
            BigDecimal pow = BCMathFunctions.bcpowImpl(base, expI, scale);
            return pow.remainder(modulus, MathContext.UNLIMITED).toString();
        }
        BigInteger baseI = base.toBigInteger();
        BigInteger expI = exp.toBigInteger();
        BigInteger modulusI = modulus.toBigInteger();
        BigInteger result = baseI.modPow(expI, modulusI);
        return result.toString();
    }

    public static String bcpowmod(Environment env, Memory _base, Memory _exp, Memory _modulus) {
        return BCMathFunctions.bcpowmod(env, _base, _exp, _modulus, BCMathFunctions.getScale(env));
    }

    public static Memory bcsqrt(Environment env, Memory operand, int scale) {
        int cscale;
        BigDecimal initialGuess;
        BigDecimal value = BCMathFunctions.toBigDecimal(operand);
        int compareToZero = value.compareTo(BigDecimal.ZERO);
        if (compareToZero < 0) {
            return Memory.NULL;
        }
        if (compareToZero == 0) {
            return new StringMemory("0");
        }
        int compareToOne = value.compareTo(BigDecimal.ONE);
        if (compareToOne == 0) {
            return new StringMemory("1");
        }
        if (compareToOne < 1) {
            initialGuess = BigDecimal.ONE;
            cscale = value.scale();
        } else {
            BigInteger integerPart = value.toBigInteger();
            int length = integerPart.toString().length();
            if (length % 2 == 0) {
                --length;
            }
            initialGuess = BigDecimal.ONE.movePointRight(length /= 2);
            cscale = Math.max(scale, value.scale()) + 2;
        }
        BigDecimal guess = initialGuess;
        for (int iteration = 0; iteration < 50; ++iteration) {
            BigDecimal lastGuess = guess;
            guess = value.divide(guess, cscale, RoundingMode.DOWN);
            guess = guess.add(lastGuess);
            if (lastGuess.equals(guess = guess.divide(DECIMAL_TWO, cscale, RoundingMode.DOWN))) break;
        }
        value = guess;
        value = value.setScale(scale, RoundingMode.DOWN);
        return new StringMemory(value.toPlainString());
    }

    public static Memory bcsqrt(Environment env, Memory operand) {
        return BCMathFunctions.bcsqrt(env, operand, BCMathFunctions.getScale(env));
    }

    public static String bcsub(Environment env, Memory left, Memory right, int scale) {
        BigDecimal bd1 = BCMathFunctions.toBigDecimal(left);
        BigDecimal bd2 = BCMathFunctions.toBigDecimal(right);
        return bd1.subtract(bd2).setScale(scale, RoundingMode.DOWN).toPlainString();
    }

    public static String bcsub(Environment env, Memory left, Memory right) {
        return BCMathFunctions.bcsub(env, left, right, BCMathFunctions.getScale(env));
    }
}

