/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.FileObject;
import php.runtime.ext.core.classes.stream.MiscStream;
import php.runtime.lang.BaseObject;
import php.runtime.lang.ForeachIterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\lang\\Process")
public class WrapProcess
extends BaseObject {
    protected Process process;
    protected ProcessBuilder processBuilder;

    public WrapProcess(Environment env, Process process) {
        super(env);
        this.process = process;
    }

    public WrapProcess(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="commands", type=HintType.ARRAY), @Reflection.Arg(value="directory", optional=@Reflection.Optional(value="NULL")), @Reflection.Arg(value="environment", type=HintType.ARRAY, optional=@Reflection.Optional(value="NULL"))})
    public Memory __construct(Environment env, Memory ... args) {
        this.processBuilder = args[0].isNull() ? new ProcessBuilder(new String[0]) : new ProcessBuilder(args[0].toValue(ArrayMemory.class).toStringArray());
        if (!args[1].isNull()) {
            this.processBuilder.directory(FileObject.valueOf(args[1]));
        }
        if (!args[2].isNull()) {
            ForeachIterator iterator = args[2].getNewIterator(env);
            while (iterator.next()) {
                this.processBuilder.environment().put(iterator.getKey().toString(), iterator.getValue().toString());
            }
        }
        return Memory.NULL;
    }

    protected Process getProcess() {
        if (this.process == null) {
            throw new IllegalStateException("Process is not started, use the start() method to initialize it");
        }
        return this.process;
    }

    @Reflection.Signature
    public Memory start(Environment env, Memory ... args) throws IOException {
        if (this.processBuilder == null) {
            throw new IllegalStateException("Process is final and it cannot start new ones");
        }
        Process process1 = this.processBuilder.start();
        WrapProcess wrapProcess = new WrapProcess(env, process1);
        wrapProcess.processBuilder = this.processBuilder;
        return new ObjectMemory(wrapProcess);
    }

    @Reflection.Signature
    public Memory startAndWait(Environment env, Memory ... args) throws IOException, InterruptedException {
        Memory r = this.start(env, args);
        r.toObject(WrapProcess.class).process.waitFor();
        return r;
    }

    @Reflection.Signature
    public Memory getExitValue(Environment env, Memory ... args) {
        try {
            return LongMemory.valueOf(this.getProcess().exitValue());
        }
        catch (IllegalThreadStateException e) {
            return Memory.NULL;
        }
    }

    @Reflection.Signature
    public Memory getInput(Environment env, Memory ... args) {
        return new ObjectMemory(new MiscStream(env, this.getProcess().getInputStream()));
    }

    @Reflection.Signature
    public Memory getOutput(Environment env, Memory ... args) {
        return new ObjectMemory(new MiscStream(env, this.getProcess().getOutputStream()));
    }

    @Reflection.Signature
    public Memory getError(Environment env, Memory ... args) {
        return new ObjectMemory(new MiscStream(env, this.getProcess().getErrorStream()));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="force", optional=@Reflection.Optional(value="false"))})
    public void destroy(Environment env, Memory ... args) throws Throwable {
        if (args[0].toBoolean()) {
            Process process = this.getProcess();
            Method destroyForcibly = process.getClass().getMethod("destroyForcibly", new Class[0]);
            try {
                destroyForcibly.invoke((Object)process, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        } else {
            this.getProcess().destroy();
        }
    }
}

