/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.lib;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.annotation.Runtime;
import php.runtime.env.Environment;
import php.runtime.lang.BaseObject;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\lib\\Char")
public class CharUtils
extends BaseObject {
    private static final char CHAR_UNDEFINED = '\uffff';

    public CharUtils(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    private Memory __construct(Environment env, Memory ... args) {
        return Memory.NULL;
    }

    protected static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    protected static char chr(Memory arg) {
        String s = arg.toString();
        if (s.length() > 0) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory ord(Environment env, Memory ... args) {
        return LongMemory.valueOf(args[0].toChar());
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="code")})
    public static Memory of(Environment env, Memory ... args) {
        return StringMemory.valueOf((char)args[0].toInteger());
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="code")})
    public static Memory count(Environment env, Memory ... args) {
        return LongMemory.valueOf(Character.charCount(args[0].toInteger()));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char1"), @Reflection.Arg(value="char2")})
    public static Memory compare(Environment env, Memory ... args) {
        return LongMemory.valueOf(CharUtils.chr(args[0]) - CharUtils.chr(args[1]));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory upper(Environment env, Memory ... args) {
        return StringMemory.valueOf(Character.toUpperCase(CharUtils.chr(args[0])));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory lower(Environment env, Memory ... args) {
        return StringMemory.valueOf(Character.toLowerCase(CharUtils.chr(args[0])));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory title(Environment env, Memory ... args) {
        return StringMemory.valueOf(Character.toTitleCase(CharUtils.chr(args[0])));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory isSpace(Environment env, Memory ... args) {
        return Character.isSpaceChar(CharUtils.chr(args[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory isDigit(Environment env, Memory ... args) {
        return Character.isDigit(CharUtils.chr(args[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory isLetter(Environment env, Memory ... args) {
        return Character.isLetter(CharUtils.chr(args[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory isLetterOrDigit(Environment env, Memory ... args) {
        return Character.isLetterOrDigit(CharUtils.chr(args[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory isLower(Environment env, Memory ... args) {
        return Character.isLowerCase(CharUtils.chr(args[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory isUpper(Environment env, Memory ... args) {
        return Character.isUpperCase(CharUtils.chr(args[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory isTitle(Environment env, Memory ... args) {
        return Character.isTitleCase(CharUtils.chr(args[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory isWhitespace(Environment env, Memory ... args) {
        return Character.isWhitespace(CharUtils.chr(args[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory isISOControl(Environment env, Memory ... args) {
        return Character.isISOControl(CharUtils.chr(args[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory isDefined(Environment env, Memory ... args) {
        return Character.isDefined(CharUtils.chr(args[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory isMirrored(Environment env, Memory ... args) {
        return Character.isMirrored(CharUtils.chr(args[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory isLowSurrogate(Environment env, Memory ... args) {
        return Character.isLowSurrogate(CharUtils.chr(args[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory isHighSurrogate(Environment env, Memory ... args) {
        return Character.isHighSurrogate(CharUtils.chr(args[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory isPrintable(Environment env, Memory ... args) {
        return CharUtils.isPrintableChar(CharUtils.chr(args[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="char")})
    public static Memory number(Environment env, Memory ... args) {
        return LongMemory.valueOf(Character.getNumericValue(CharUtils.chr(args[0])));
    }
}

