/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.lib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.annotation.Runtime;
import php.runtime.common.Callback;
import php.runtime.common.DigestUtils;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.lib.StrUtils;
import php.runtime.ext.core.classes.stream.FileObject;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.ext.core.classes.util.WrapRegex;
import php.runtime.invoke.Invoker;
import php.runtime.invoke.RunnableInvoker;
import php.runtime.lang.BaseObject;
import php.runtime.lang.ForeachIterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\lib\\fs")
public class FsUtils
extends BaseObject {
    public static final int BUFFER_SIZE = 8192;
    private static final char CHAR_UNDEFINED = '\uffff';
    private static final Set<String> winSystemNames = new HashSet<String>(Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"));
    private static final char[] deniedNameChars = new char[]{'*', '?', '\"', '>', '<', '|', ':', '/', '\\'};

    public FsUtils(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    private Memory __construct(Environment env, Memory ... args) {
        return Memory.NULL;
    }

    private static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    @Reflection.Signature
    public static String abs(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            return new File(path).getAbsolutePath();
        }
    }

    @Reflection.Signature
    public static boolean valid(String name) {
        if (name.trim().isEmpty()) {
            return false;
        }
        for (char c : deniedNameChars) {
            if (name.indexOf(c) <= -1) continue;
            return false;
        }
        if (name.equals(".") || name.startsWith("./") || name.startsWith(".\\")) {
            return false;
        }
        int length = name.length();
        boolean onlySpecs = true;
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (ch != '.' && ch != '/' && ch != '\\') {
                onlySpecs = false;
            }
            if (FsUtils.isPrintableChar(ch)) continue;
            return false;
        }
        if (onlySpecs) {
            return false;
        }
        return !System.getProperty("os.name").toLowerCase().contains("win") || !winSystemNames.contains(name.toUpperCase());
    }

    @Reflection.Signature
    public static String name(String path) {
        return new File(path).getName();
    }

    @Reflection.Signature
    public static String ext(String path) {
        String name = new File(path).getName();
        int indexOf = name.lastIndexOf(46);
        if (indexOf > -1) {
            return name.substring(indexOf + 1);
        }
        return null;
    }

    @Reflection.Signature
    public static boolean hasExt(Environment env, String path) {
        return FsUtils.ext(path) != null;
    }

    @Reflection.Signature
    public static boolean hasExt(Environment env, String path, Memory extensions) {
        return FsUtils.hasExt(env, path, extensions, true);
    }

    @Reflection.Signature
    public static boolean hasExt(Environment env, String path, Memory extensions, boolean ignoreCase) {
        HashSet<String> exts = new HashSet<String>();
        if (extensions.isTraversable()) {
            ForeachIterator iterator = extensions.getNewIterator(env);
            while (iterator.next()) {
                String value = iterator.getValue().toString();
                if (ignoreCase) {
                    value = value.toLowerCase();
                }
                exts.add(value);
            }
        } else {
            exts.add(ignoreCase ? extensions.toString().toLowerCase() : extensions.toString());
        }
        String ext = FsUtils.ext(path);
        if (ignoreCase && ext != null) {
            ext = ext.toLowerCase();
        }
        return exts.contains(ext);
    }

    @Reflection.Signature
    public static String nameNoExt(String path) {
        String name = new File(path).getName();
        int indexOf = name.lastIndexOf(46);
        if (indexOf > -1) {
            name = name.substring(0, indexOf);
        }
        return name;
    }

    @Reflection.Signature
    public static String pathNoExt(String path) {
        String name = new File(path).getPath();
        int indexOf = name.lastIndexOf(46);
        if (indexOf > -1) {
            name = name.substring(0, indexOf);
        }
        return name;
    }

    @Reflection.Signature
    public static long size(String path) {
        return new File(path).length();
    }

    @Reflection.Signature
    public static long time(String path) {
        return new File(path).lastModified();
    }

    @Reflection.Signature
    public static boolean isFile(String path) {
        return new File(path).isFile();
    }

    @Reflection.Signature
    public static boolean isDir(String path) {
        return new File(path).isDirectory();
    }

    @Reflection.Signature
    public static boolean isHidden(String path) {
        return new File(path).isHidden();
    }

    @Reflection.Signature
    public static String normalize(String path) {
        return new File(path).getPath();
    }

    @Reflection.Signature
    public static String parent(String path) {
        return new File(path).getParent();
    }

    @Reflection.Signature
    public static boolean ensureParent(String path) {
        File parent = new File(path).getParentFile();
        if (parent == null) {
            return true;
        }
        if (!parent.isDirectory()) {
            return parent.mkdirs();
        }
        return true;
    }

    @Reflection.Signature
    public static boolean exists(String path) {
        return new File(path).exists();
    }

    @Reflection.Signature
    @Runtime.FastMethod
    public static Memory separator(Environment env, Memory ... args) {
        return StringMemory.valueOf(File.separator);
    }

    @Reflection.Signature
    @Runtime.FastMethod
    public static Memory pathSeparator(Environment env, Memory ... args) {
        return StringMemory.valueOf(File.pathSeparator);
    }

    @Reflection.Signature
    public static boolean makeDir(String path) {
        return new File(path).mkdirs();
    }

    @Reflection.Signature
    public static boolean makeFile(String path) {
        String parent = FsUtils.parent(path);
        if (parent != null && !FsUtils.isDir(path) && !FsUtils.makeDir(parent)) {
            return false;
        }
        try {
            return new File(path).createNewFile();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Reflection.Signature
    public static boolean delete(String path) {
        return new File(path).delete();
    }

    @Reflection.Signature
    public static Memory get(Environment env, String input) throws Throwable {
        return FsUtils.get(env, input, null, "r");
    }

    @Reflection.Signature
    public static Memory get(Environment env, String input, @Reflection.Nullable String charset) throws Throwable {
        return FsUtils.get(env, input, charset, "r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature
    public static Memory get(Environment env, String input, @Reflection.Nullable String charset, String mode) throws Throwable {
        Stream stream = Stream.create(env, input, mode);
        try {
            Memory memory = env.invokeMethod(stream, "readFully", new Memory[0]);
            if (charset == null || charset.trim().isEmpty()) {
                Memory memory2 = memory;
                return memory2;
            }
            Memory memory3 = StrUtils.decode(env, memory, StringMemory.valueOf(charset));
            return memory3;
        }
        finally {
            env.invokeMethod(stream, "close", new Memory[0]);
        }
    }

    @Reflection.Signature
    public static long copy(InputStream input, OutputStream output) throws IOException {
        return FsUtils.copy(input, output, null, 8192);
    }

    @Reflection.Signature
    public static long copy(InputStream input, OutputStream output, @Reflection.Nullable Invoker callback) throws IOException {
        return FsUtils.copy(input, output, callback, 8192);
    }

    @Reflection.Signature
    public static long copy(InputStream input, OutputStream output, @Reflection.Nullable Invoker callback, int bufferSize) throws IOException {
        int n;
        long nread = 0L;
        byte[] buf = new byte[bufferSize];
        BufferedInputStream inputStream = new BufferedInputStream(input, bufferSize);
        BufferedOutputStream outputStream = new BufferedOutputStream(output, bufferSize);
        while ((n = inputStream.read(buf)) > 0) {
            outputStream.write(buf, 0, n);
            if (callback == null || callback.callAny(nread += (long)n, n).toValue() != Memory.FALSE) continue;
        }
        outputStream.flush();
        return nread;
    }

    @Reflection.Signature
    public static Memory hash(InputStream source) throws NoSuchAlgorithmException {
        return FsUtils.hash(source, "MD5", null);
    }

    @Reflection.Signature
    public static Memory hash(InputStream source, String algo) throws NoSuchAlgorithmException {
        return FsUtils.hash(source, algo, null);
    }

    @Reflection.Signature
    public static Memory hash(InputStream source, String algo, @Reflection.Nullable Invoker invoker) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(algo);
        byte[] buffer = new byte[8192];
        try {
            int len;
            int sum = 0;
            while ((len = source.read(buffer)) > 0) {
                messageDigest.update(buffer, 0, len);
                if (invoker == null || invoker.callAny(sum += len, len).toValue() != Memory.FALSE) continue;
            }
            return StringMemory.valueOf(DigestUtils.bytesToHex(messageDigest.digest()));
        }
        catch (FileNotFoundException e) {
            return Memory.NULL;
        }
        catch (IOException e) {
            return Memory.NULL;
        }
    }

    public static void scan(String path, ScanProgressHandler scanProgressHandler) {
        FsUtils.scan(path, scanProgressHandler, 0);
    }

    public static void scan(String path, ScanProgressHandler scanProgressHandler, int maxDepth) {
        FsUtils.scan(path, scanProgressHandler, maxDepth, 1);
    }

    public static void scan(String path, final ScanProgressHandler scanProgressHandler, final int maxDepth, final int _depth) {
        if (maxDepth > 0 && _depth > maxDepth) {
            return;
        }
        File file = new File(path);
        file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!scanProgressHandler.isSubIsFirst()) {
                    scanProgressHandler.call(pathname, _depth);
                }
                if (pathname.isDirectory()) {
                    FsUtils.scan(pathname.getPath(), scanProgressHandler, maxDepth, _depth + 1);
                }
                if (scanProgressHandler.isSubIsFirst()) {
                    scanProgressHandler.call(pathname, _depth);
                }
                return false;
            }
        });
    }

    private static Memory scanFilter(final Environment env, ArrayMemory props) {
        final FilterProperties filterProperties = props.toBean(env, FilterProperties.class);
        return RunnableInvoker.make(env, new Callback<Memory, Memory[]>(){

            @Override
            public Memory call(Memory[] args) {
                if (args == null || args.length == 0) {
                    return Memory.NULL;
                }
                Memory file = args[0];
                File path = file.instanceOf(FileObject.class) ? file.toObject(FileObject.class).getFile() : new File(file.toString());
                Set extensions = filterProperties.extensions;
                Set excludeExtensions = filterProperties.excludeExtensions;
                if (filterProperties.excludeDirs && path.isDirectory()) {
                    return Memory.NULL;
                }
                if (filterProperties.excludeFiles && path.isFile()) {
                    return Memory.NULL;
                }
                if (filterProperties.excludeHidden && path.isHidden()) {
                    return Memory.NULL;
                }
                if (filterProperties.minSize > 0L && path.length() < filterProperties.minSize) {
                    return Memory.NULL;
                }
                if (filterProperties.maxSize != Long.MAX_VALUE && path.length() > filterProperties.maxSize) {
                    return Memory.NULL;
                }
                if (filterProperties.minTime > 0L && path.lastModified() < filterProperties.minTime) {
                    return Memory.NULL;
                }
                if (filterProperties.maxTime != Long.MAX_VALUE && path.lastModified() > filterProperties.maxTime) {
                    return Memory.NULL;
                }
                String ext = FsUtils.ext(path.getPath());
                if (extensions != null && extensions.size() > 0 && !extensions.contains(ext)) {
                    return Memory.NULL;
                }
                if (excludeExtensions != null && excludeExtensions.size() > 0 && excludeExtensions.contains(ext)) {
                    return Memory.NULL;
                }
                if (filterProperties.namePattern != null && filterProperties.namePattern.isNotNull()) {
                    boolean matches;
                    if (filterProperties.namePattern.instanceOf(WrapRegex.class)) {
                        WrapRegex regex = filterProperties.namePattern.toObject(WrapRegex.class);
                        matches = regex.test(env, StringMemory.valueOf(path.getName())).toBoolean();
                    } else {
                        matches = path.getName().matches(filterProperties.namePattern.toString());
                    }
                    if (!matches) {
                        return Memory.NULL;
                    }
                }
                if (filterProperties.getCallback() != null) {
                    Memory ret = filterProperties.getCallback().callNoThrow(args);
                    if (ret.isNotNull() && ret.toValue() != Memory.FALSE) {
                        return ret.toImmutable();
                    }
                    return Memory.NULL;
                }
                return file;
            }
        });
    }

    @Reflection.Signature
    public static Memory scan(Environment env, String path) {
        return FsUtils.scan(env, path, null, 0);
    }

    @Reflection.Signature
    public static Memory scan(Environment env, String path, @Reflection.Nullable Memory progress) {
        return FsUtils.scan(env, path, progress, 0);
    }

    @Reflection.Signature
    public static Memory scan(Environment env, String path, @Reflection.Nullable Memory progress, int maxDepth) {
        return FsUtils.scan(env, path, progress, maxDepth, false);
    }

    @Reflection.Signature
    public static Memory scan(final Environment env, String path, @Reflection.Nullable Memory filter, int maxDepth, boolean filesIsFirst) {
        final ArrayMemory result = new ArrayMemory();
        if (filter.isArray()) {
            filter = FsUtils.scanFilter(env, filter.toValue(ArrayMemory.class));
        }
        final Invoker progress = Invoker.create(env, filter);
        FsUtils.scan(path, new ScanProgressHandler(filesIsFirst){

            @Override
            public boolean call(File pathname, int depth) {
                if (progress != null) {
                    Memory ret = progress.callAny(pathname, depth);
                    if (ret.isNotNull() && ret.toValue() != Memory.FALSE) {
                        result.add(ret.toImmutable());
                    }
                } else {
                    result.add(new FileObject(env, pathname));
                }
                return true;
            }
        }, maxDepth);
        return result;
    }

    @Reflection.Signature
    public static ArrayMemory clean(Environment env, String path) {
        return FsUtils.clean(env, path, Memory.NULL);
    }

    @Reflection.Signature
    public static ArrayMemory clean(final Environment env, String path, @Reflection.Nullable Memory filter) {
        ArrayMemory result = new ArrayMemory();
        final ArrayMemory success = new ArrayMemory();
        final ArrayMemory error = new ArrayMemory();
        final ArrayMemory skip = new ArrayMemory();
        result.put("success", success);
        result.put("error", error);
        result.put("skip", skip);
        boolean isFilter = filter.isArray();
        if (isFilter) {
            filter = FsUtils.scanFilter(env, filter.toValue(ArrayMemory.class));
        }
        final Invoker checker = Invoker.create(env, filter);
        FsUtils.scan(path, new ScanProgressHandler(true){

            @Override
            public boolean call(File file, int depth) {
                Memory value = ObjectMemory.valueOf(new FileObject(env, file));
                if (checker == null || checker.callAny(file, depth).toBoolean()) {
                    if (FsUtils.delete(file.getPath())) {
                        success.add(value);
                    } else {
                        error.add(value);
                    }
                } else {
                    skip.add(value);
                }
                return true;
            }
        });
        return result.toConstant();
    }

    @Reflection.Signature
    public static boolean rename(String path, String newName) {
        String parent = FsUtils.parent(path);
        return new File(path).renameTo(new File((parent != null ? parent + File.separator : "") + newName));
    }

    @Reflection.Signature
    public static boolean move(String path, String newPath) {
        return new File(path).renameTo(new File(newPath));
    }

    public static abstract class ScanProgressHandler {
        protected final boolean subIsFirst;

        protected ScanProgressHandler(boolean subIsFirst) {
            this.subIsFirst = subIsFirst;
        }

        public boolean isSubIsFirst() {
            return this.subIsFirst;
        }

        public abstract boolean call(File var1, int var2);
    }

    public static class FilterProperties {
        private Memory namePattern;
        private Set<String> extensions;
        private Set<String> excludeExtensions;
        private boolean excludeDirs;
        private boolean excludeFiles;
        private boolean excludeHidden;
        private Invoker callback;
        private long minSize = 0L;
        private long maxSize = Long.MAX_VALUE;
        private long minTime = 0L;
        private long maxTime = Long.MAX_VALUE;

        public Set<String> getExtensions() {
            return this.extensions;
        }

        public void setExtensions(Set<String> extensions) {
            this.extensions = extensions;
        }

        public Set<String> getExcludeExtensions() {
            return this.excludeExtensions;
        }

        public void setExcludeExtensions(Set<String> excludeExtensions) {
            this.excludeExtensions = excludeExtensions;
        }

        public boolean isExcludeDirs() {
            return this.excludeDirs;
        }

        public void setExcludeDirs(boolean excludeDirs) {
            this.excludeDirs = excludeDirs;
        }

        public boolean isExcludeFiles() {
            return this.excludeFiles;
        }

        public void setExcludeFiles(boolean excludeFiles) {
            this.excludeFiles = excludeFiles;
        }

        public boolean isExcludeHidden() {
            return this.excludeHidden;
        }

        public void setExcludeHidden(boolean excludeHidden) {
            this.excludeHidden = excludeHidden;
        }

        public Invoker getCallback() {
            return this.callback;
        }

        public void setCallback(Invoker callback) {
            this.callback = callback;
        }

        public long getMinSize() {
            return this.minSize;
        }

        public void setMinSize(long minSize) {
            this.minSize = minSize;
        }

        public long getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(long maxSize) {
            this.maxSize = maxSize;
        }

        public long getMinTime() {
            return this.minTime;
        }

        public void setMinTime(long minTime) {
            this.minTime = minTime;
        }

        public long getMaxTime() {
            return this.maxTime;
        }

        public void setMaxTime(long maxTime) {
            this.maxTime = maxTime;
        }

        public Memory getNamePattern() {
            return this.namePattern;
        }

        public void setNamePattern(Memory namePattern) {
            this.namePattern = namePattern;
        }
    }
}

