/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.java.JavaClass;
import php.runtime.ext.java.JavaObject;
import php.runtime.ext.java.JavaReflection;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.support.MemoryUtils;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\lang\\JavaMethod")
public final class JavaMethod
extends JavaReflection {
    protected Method method;
    protected MemoryUtils.Converter[] converters;
    protected MemoryUtils.Converter resultConverter;
    protected Class<?>[] paramTypes;

    public JavaMethod(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public void setMethod(Method method) {
        this.method = method;
        method.setAccessible(true);
        this.paramTypes = method.getParameterTypes();
        this.converters = MemoryUtils.getConverters(this.paramTypes);
        this.resultConverter = MemoryUtils.getConverter(method.getReturnType());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="object", typeClass="php\\lang\\JavaObject", optional=@Reflection.Optional(value="NULL"))})
    public Memory invoke(Environment env, Memory ... args) {
        int len = args.length - 1;
        if (len < this.paramTypes.length || len > this.paramTypes.length) {
            JavaMethod.exception(env, new IllegalArgumentException("Invalid argument count"));
        }
        Object[] passed = new Object[len];
        int i = 0;
        for (MemoryUtils.Converter converter : this.converters) {
            Memory arg = args[i + 1];
            passed[i] = arg.instanceOf("php\\lang\\JavaObject") ? ((JavaObject)arg.toValue(ObjectMemory.class).value).getObject() : (converter != null ? converter.run(args[i + 1]) : null);
            ++i;
        }
        Object obj = args[0].isNull() ? null : ((JavaObject)args[0].toValue(ObjectMemory.class).value).getObject();
        try {
            Object result = this.method.invoke(obj, passed);
            if (result == null) {
                return Memory.NULL;
            }
            if (this.resultConverter != null) {
                return MemoryUtils.valueOf(result);
            }
            if (this.method.getReturnType() == Void.TYPE) {
                return Memory.NULL;
            }
            return new ObjectMemory(JavaObject.of(env, result));
        }
        catch (IllegalAccessException e) {
            JavaMethod.exception(env, e);
        }
        catch (InvocationTargetException e) {
            JavaMethod.exception(env, e.getTargetException());
        }
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="object", typeClass="php\\lang\\JavaObject", optional=@Reflection.Optional(value="NULL")), @Reflection.Arg(value="arguments", type=HintType.ARRAY, optional=@Reflection.Optional)})
    public Memory invokeArgs(Environment env, Memory ... args) {
        Memory[] tmp = args[1].toValue(ArrayMemory.class).values();
        Memory[] passed = new Memory[tmp.length + 1];
        System.arraycopy(tmp, 0, passed, 1, tmp.length);
        passed[0] = args[0];
        return this.invoke(env, passed);
    }

    @Reflection.Signature
    public Memory isStatic(Environment env, Memory ... args) {
        return Modifier.isStatic(this.method.getModifiers()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isFinal(Environment env, Memory ... args) {
        return Modifier.isFinal(this.method.getModifiers()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isPrivate(Environment env, Memory ... args) {
        return Modifier.isPrivate(this.method.getModifiers()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isProtected(Environment env, Memory ... args) {
        return Modifier.isProtected(this.method.getModifiers()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isPublic(Environment env, Memory ... args) {
        return Modifier.isPublic(this.method.getModifiers()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isAbstract(Environment env, Memory ... args) {
        return Modifier.isAbstract(this.method.getModifiers()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isNative(Environment env, Memory ... args) {
        return Modifier.isNative(this.method.getModifiers()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isSynchronized(Environment env, Memory ... args) {
        return Modifier.isSynchronized(this.method.getModifiers()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory getDeclaringClass(Environment env, Memory ... args) {
        return new ObjectMemory(JavaClass.of(env, this.method.getDeclaringClass()));
    }

    @Reflection.Signature
    public Memory getReturnedType(Environment env, Memory ... args) {
        return new ObjectMemory(JavaClass.of(env, this.method.getReturnType()));
    }

    @Reflection.Signature
    public Memory getModifiers(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.method.getModifiers());
    }

    @Reflection.Signature
    public Memory getName(Environment env, Memory ... args) {
        return StringMemory.valueOf(this.method.getName());
    }

    @Reflection.Signature
    public Memory isVarArgs(Environment env, Memory ... args) {
        return this.method.isVarArgs() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="annotationClass")})
    public Memory isAnnotationPresent(Environment env, Memory ... args) {
        try {
            return this.method.isAnnotationPresent(Class.forName(args[0].toString())) ? Memory.TRUE : Memory.FALSE;
        }
        catch (ClassCastException | ClassNotFoundException e) {
            JavaMethod.exception(env, e);
            return Memory.NULL;
        }
    }

    @Reflection.Signature
    public Memory getParameterTypes(Environment env, Memory ... args) {
        ArrayMemory result = new ArrayMemory();
        for (Class<?> el : this.method.getParameterTypes()) {
            result.add(new ObjectMemory(JavaClass.of(env, el)));
        }
        return result.toConstant();
    }

    @Reflection.Signature
    public Memory getParameterCount(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.method.getParameterTypes().length);
    }

    public static JavaMethod of(Environment env, Method method) {
        JavaMethod javaMethod = new JavaMethod(env, env.fetchClass("php\\lang\\JavaMethod"));
        javaMethod.setMethod(method);
        return javaMethod;
    }

    public static Object[] makePassed(Environment env, MemoryUtils.Converter[] converters, Memory ... args) {
        Object[] passed = new Object[converters.length];
        int i = 0;
        for (MemoryUtils.Converter converter : converters) {
            Memory arg = args[i];
            passed[i] = arg.instanceOf("php\\lang\\JavaObject") ? ((JavaObject)arg.toValue(ObjectMemory.class).value).getObject() : (converter != null ? converter.run(args[i]) : null);
            ++i;
        }
        return passed;
    }
}

