/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.support.compile;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import php.runtime.Memory;
import php.runtime.annotation.Runtime;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.CriticalException;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.support.MemoryUtils;

public class CompileFunction {
    public String name;
    public Method[] methods;
    private Method methodVarArgs;
    private int methodVarArgsCount;
    private int minArgs = Integer.MAX_VALUE;
    private int maxArgs = 0;

    public CompileFunction(String name) {
        this.name = name;
        this.methods = new Method[5];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompileFunction)) {
            return false;
        }
        CompileFunction that = (CompileFunction)o;
        return this.name.equals(that.name);
    }

    public int getMinArgs() {
        return this.minArgs;
    }

    public int getMaxArgs() {
        return this.maxArgs;
    }

    public Method addMethod(java.lang.reflect.Method method) {
        return this.addMethod(method, false);
    }

    public void mergeFunction(CompileFunction function) {
        if (this.methods.length < function.methods.length) {
            this.methods = Arrays.copyOf(this.methods, function.methods.length);
        }
        for (int i = 0; i < function.methods.length; ++i) {
            if (function.methods[i] == null) continue;
            this.methods[i] = function.methods[i];
        }
        if (function.methodVarArgs != null) {
            this.methodVarArgs = function.methodVarArgs;
        }
        this.minArgs = Math.min(this.minArgs, function.minArgs);
        this.maxArgs = Math.max(this.maxArgs, function.maxArgs);
    }

    public Method addMethod(java.lang.reflect.Method method, boolean asImmutable) {
        boolean ignore;
        Class<?> type;
        int i;
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        if (method.isVarArgs()) {
            if (this.methodVarArgs != null) {
                throw new IllegalArgumentException("Cannot add two var-args methods");
            }
            this.methodVarArgs = new Method(method, 0, asImmutable);
            int count = 0;
            Class<?>[] types = method.getParameterTypes();
            for (i = 0; i < types.length; ++i) {
                type = types[i];
                if (type == Environment.class || type == TraceInfo.class || type == Memory[].class) continue;
                ignore = false;
                for (Annotation el : paramAnnotations[i]) {
                    if (!el.annotationType().equals(Runtime.GetLocals.class)) continue;
                    if (type != ArrayMemory.class) {
                        throw new RuntimeException("@Runtime.GetLocals: param type must be ArrayMemory");
                    }
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                ++count;
            }
            if (count < this.minArgs) {
                this.minArgs = count;
            }
            this.methodVarArgsCount = count;
            this.maxArgs = Integer.MAX_VALUE;
            if (this.methodVarArgsCount < this.methods.length && this.methods[this.methodVarArgsCount] != null) {
                throw new IllegalArgumentException("Method '" + this.name + "' with " + this.methodVarArgsCount + " args already exists");
            }
        }
        Class<?>[] types = method.getParameterTypes();
        int count = 0;
        for (i = 0; i < types.length; ++i) {
            type = types[i];
            if (type == Environment.class || type == TraceInfo.class) continue;
            ignore = false;
            for (Annotation el : paramAnnotations[i]) {
                if (!el.annotationType().equals(Runtime.GetLocals.class)) continue;
                if (type != ArrayMemory.class) {
                    throw new RuntimeException("@Runtime.GetLocals: param type must be ArrayMemory");
                }
                ignore = true;
                break;
            }
            if (ignore) continue;
            ++count;
        }
        if (count < this.minArgs) {
            this.minArgs = count;
        }
        if (count > this.maxArgs) {
            this.maxArgs = count;
        }
        if (count >= this.methods.length) {
            Method[] newMethods = new Method[Math.max(this.methods.length * 2, count + 1)];
            System.arraycopy(this.methods, 0, newMethods, 0, this.methods.length);
            this.methods = newMethods;
        }
        if (this.methods[count] != null) {
            throw new IllegalArgumentException("Method " + this.name + " with " + count + " args already exists");
        }
        this.methods[count] = this.createMethod(method, count, asImmutable);
        return this.methods[count];
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean delete(int paramCount) {
        if (paramCount < this.minArgs) {
            return false;
        }
        Method method = null;
        if (paramCount < this.methods.length && paramCount >= 0) {
            this.methods[paramCount] = null;
            return true;
        }
        if (this.methodVarArgsCount <= paramCount) {
            this.methodVarArgs = null;
            return true;
        }
        if (paramCount > this.maxArgs) {
            for (int i = this.methods.length - 1; i >= 0; --i) {
                method = this.methods[i];
                if (method == null) continue;
                this.methods[i] = null;
                return true;
            }
        }
        return false;
    }

    public Method find(int paramCount) {
        if (paramCount < this.minArgs) {
            return null;
        }
        Method method = null;
        if (paramCount < this.methods.length && paramCount >= 0) {
            method = this.methods[paramCount];
        }
        if (method == null && this.methodVarArgsCount <= paramCount) {
            method = this.methodVarArgs;
        }
        if (method == null && paramCount > this.maxArgs) {
            for (int i = this.methods.length - 1; i >= 0; --i) {
                method = this.methods[i];
                if (method == null) continue;
                return method;
            }
        }
        return method;
    }

    protected Method createMethod(java.lang.reflect.Method method, int count, boolean asImmutable) {
        return new Method(method, count, asImmutable);
    }

    public static class Method {
        public boolean isImmutable;
        public final boolean isImmutableIgnoreRefs;
        public final java.lang.reflect.Method method;
        public final MemoryUtils.Converter<?>[] converters;
        public final Annotation[][] parameterAnnotations;
        public final Class<?>[] parameterTypes;
        public final Class<?> resultType;
        public final boolean[] references;
        public final boolean[] mutableValues;
        public final int argsCount;

        public Method(java.lang.reflect.Method method, int argsCount, boolean _asImmutable) {
            Runtime.Immutable annotation;
            this.argsCount = argsCount;
            this.method = method;
            this.parameterTypes = method.getParameterTypes();
            this.converters = new MemoryUtils.Converter[this.parameterTypes.length];
            int i = 0;
            for (Class<?> type : this.parameterTypes) {
                this.converters[i++] = this.getConverterForArgument(type);
            }
            if (method.isVarArgs()) {
                this.converters[this.converters.length - 1] = null;
            }
            this.parameterAnnotations = method.getParameterAnnotations();
            this.resultType = method.getReturnType();
            boolean bl = this.isImmutable = method.isAnnotationPresent(Runtime.Immutable.class) || _asImmutable;
            this.isImmutableIgnoreRefs = this.isImmutable ? (annotation = method.getAnnotation(Runtime.Immutable.class)) != null && annotation.ignoreRefs() : false;
            this.references = new boolean[this.parameterTypes.length];
            this.mutableValues = new boolean[this.parameterTypes.length];
            i = 0;
            for (Class<?> type : this.parameterTypes) {
                for (Annotation annotation2 : this.parameterAnnotations[i]) {
                    if (annotation2.annotationType() == Runtime.Reference.class) {
                        this.references[i] = true;
                        if (this.isImmutableIgnoreRefs) continue;
                        this.isImmutable = false;
                        continue;
                    }
                    if (annotation2.annotationType() != Runtime.MutableValue.class) continue;
                    this.mutableValues[i] = true;
                }
                ++i;
            }
            if (this.resultType == Void.TYPE) {
                this.isImmutable = false;
            }
        }

        protected MemoryUtils.Converter<?> getConverterForArgument(Class<?> type) {
            return MemoryUtils.getConverter(type);
        }

        public boolean isPresentAnnotationOfParam(int index, Class<? extends Annotation> clazz) {
            assert (index >= 0 && index < this.parameterAnnotations.length);
            for (Annotation el : this.parameterAnnotations[index]) {
                if (!el.annotationType().equals(clazz)) continue;
                return true;
            }
            return false;
        }

        public boolean isVarArg() {
            return this.method.isVarArgs();
        }

        public Memory call(Environment env, Memory ... arguments) {
            Class<?>[] types = this.parameterTypes;
            Object[] passed = new Object[types.length];
            int i = 0;
            int j = 0;
            for (Class<?> clazz : types) {
                boolean isRef = this.references[i];
                boolean mutableValue = this.mutableValues[i];
                MemoryUtils.Converter<?> converter = this.converters[i];
                if (clazz == Memory.class) {
                    passed[i] = isRef ? arguments[j] : (mutableValue ? arguments[j].toImmutable() : arguments[j].toValue());
                    ++j;
                } else if (converter != null) {
                    passed[i] = converter.run(arguments[j]);
                    ++j;
                } else if (clazz == Environment.class) {
                    passed[i] = env;
                } else if (clazz == TraceInfo.class) {
                    passed[i] = env.trace();
                } else {
                    if (i == types.length - 1 && types[i] == Memory[].class) {
                        Memory[] arg = new Memory[arguments.length - i + 1];
                        if (!isRef) {
                            for (int k = 0; k < arg.length; ++k) {
                                arg[i] = arguments[i].toImmutable();
                            }
                        } else {
                            System.arraycopy(arguments, j, arg, 0, arg.length);
                        }
                        passed[i] = arg;
                        break;
                    }
                    env.error(env.trace(), ErrorType.E_CORE_ERROR, "Cannot call this method dynamically", new Object[0]);
                    passed[i] = Memory.NULL;
                }
                ++i;
            }
            try {
                if (this.resultType == Void.TYPE) {
                    this.method.invoke(null, passed);
                    return Memory.NULL;
                }
                return MemoryUtils.valueOf(this.method.invoke(null, passed));
            }
            catch (InvocationTargetException e) {
                return env.__throwException(e);
            }
            catch (IllegalAccessException e) {
                throw new CriticalException(e);
            }
        }
    }
}

