/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.invoke;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.Function;
import php.runtime.common.Messages;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.invoke.InvokeArgumentHelper;
import php.runtime.invoke.ObjectInvokeHelper;
import php.runtime.invoke.cache.FunctionCallCache;
import php.runtime.invoke.cache.MethodCallCache;
import php.runtime.lang.IObject;
import php.runtime.lang.exception.BaseTypeError;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ConstantEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.PropertyEntity;
import php.runtime.reflection.support.TypeChecker;

public final class InvokeHelper {
    private InvokeHelper() {
    }

    public static void checkAccess(Environment env, TraceInfo trace, MethodEntity method) {
        int access = method.canAccess(env);
        if (access == 0) {
            return;
        }
        ClassEntity contextCls = env.getLastClassOnStack();
        String context = contextCls == null ? "" : contextCls.getName();
        switch (access) {
            case 1: {
                env.error(trace, ErrorType.E_ERROR, Messages.ERR_CALL_TO_PROTECTED_METHOD, method.getClazz().getName() + "::" + method.getName(), context);
            }
            case 2: {
                env.error(trace, ErrorType.E_ERROR, Messages.ERR_CALL_TO_PRIVATE_METHOD, method.getClazz().getName() + "::" + method.getName(), context);
            }
        }
    }

    public static void checkAccess(Environment env, TraceInfo trace, PropertyEntity property) {
        switch (property.canAccess(env)) {
            case 1: {
                env.error(trace, ErrorType.E_ERROR, Messages.ERR_ACCESS_TO_PROTECTED_PROPERTY, property.getClazz().getName(), property.getName());
            }
            case 2: {
                env.error(trace, ErrorType.E_ERROR, Messages.ERR_ACCESS_TO_PRIVATE_PROPERTY, property.getClazz().getName(), property.getName());
            }
        }
    }

    public static void checkAccess(Environment env, TraceInfo trace, ConstantEntity constant, boolean lateStaticCall) {
        switch (constant.canAccess(env, null, lateStaticCall)) {
            case 1: {
                env.error(trace, ErrorType.E_ERROR, Messages.ERR_ACCESS_TO_PROTECTED_CONSTANT, constant.getClazz().getName(), constant.getName());
            }
            case 2: {
                env.error(trace, ErrorType.E_ERROR, Messages.ERR_ACCESS_TO_PRIVATE_CONSTANT, constant.getClazz().getName(), constant.getName());
            }
        }
    }

    public static Memory callAny(Memory method, Memory[] args, Environment env, TraceInfo trace) throws Throwable {
        if ((method = method.toValue()).isObject()) {
            return ObjectInvokeHelper.invokeMethod(method, null, null, env, trace, args);
        }
        if (method.isArray()) {
            Memory one = null;
            Memory two = null;
            for (Memory el : (ArrayMemory)method) {
                if (one == null) {
                    one = el;
                    continue;
                }
                if (two != null) break;
                two = el;
            }
            if (one == null || two == null) {
                env.error(trace, Messages.ERR_CALL_TO_UNDEFINED_FUNCTION.fetch(method.toString()), new Object[0]);
                return Memory.NULL;
            }
            String methodName = two.toString();
            if (one.isObject()) {
                return ObjectInvokeHelper.invokeMethod(one, methodName, methodName.toLowerCase(), env, trace, args);
            }
            String className = one.toString();
            ClassEntity magic = env.fetchMagicClass(className);
            if (magic != null) {
                className = magic.getName();
            }
            return InvokeHelper.callStaticDynamic(env, trace, className, className.toLowerCase(), methodName, methodName.toLowerCase(), args, null, 0);
        }
        String methodName = method.toString();
        int p = methodName.indexOf("::");
        if (p > -1) {
            String className = methodName.substring(0, p);
            methodName = methodName.substring(p + 2, methodName.length());
            return InvokeHelper.callStaticDynamic(env, trace, className, className.toLowerCase(), methodName, methodName.toLowerCase(), args, null, 0);
        }
        return InvokeHelper.call(env, trace, methodName.toLowerCase(), methodName, args, null, 0);
    }

    public static Memory checkReturnType(Environment env, TraceInfo trace, Memory result, final MethodEntity method) {
        return InvokeHelper.checkReturnType(env, trace, result, new Function<String>(){

            @Override
            public String call() {
                ClassEntity clazz = method.getClazz();
                switch (clazz.getType()) {
                    case CLOSURE: {
                        return "{closure}";
                    }
                }
                return clazz.getName() + "::" + method.getName();
            }
        }, method.getReturnTypeChecker(), method.isReturnTypeNullable());
    }

    public static Memory checkReturnType(Environment env, TraceInfo trace, Memory result, final FunctionEntity function) {
        return InvokeHelper.checkReturnType(env, trace, result, new Function<String>(){

            @Override
            public String call() {
                return function.getName();
            }
        }, function.getReturnTypeChecker(), function.isReturnTypeNullable());
    }

    public static Memory checkReturnType(Environment env, TraceInfo trace, Memory result, Function<String> callName, TypeChecker typeChecker, boolean nullable) {
        if (typeChecker == null) {
            return result;
        }
        if (!typeChecker.check(env, result, nullable, null)) {
            ModuleEntity module = env.getModuleManager().findModule(trace);
            Memory newReturn = typeChecker.apply(env, result, nullable, module != null && module.isStrictTypes());
            if (newReturn == null) {
                String given = result.isObject() ? result.toValue(ObjectMemory.class).getReflection().getName() : result.getRealType().toString();
                env.exception(trace, BaseTypeError.class, Messages.ERR_RETURN_TYPE_INVALID.fetch(callName.call(), typeChecker.getHumanString(), given), new Object[0]);
                return null;
            }
            return newReturn;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Memory call(Environment env, TraceInfo trace, FunctionEntity function, Memory[] args) throws Throwable {
        Memory result = function.getImmutableResultTyped(env, trace);
        Memory[] passed = null;
        if (result != null && !function.hasParameters() && args == null) {
            return result;
        }
        passed = InvokeArgumentHelper.makeArguments(env, args, function.getParameters(), function.getName(), null, null, trace);
        if (result != null) {
            return result;
        }
        if (trace != null && function.isUsesStackTrace()) {
            env.pushCall(trace, null, args, function.getName(), null, null);
        }
        try {
            result = function.invoke(env, trace, passed);
        }
        finally {
            if (trace != null && function.isUsesStackTrace()) {
                env.popCall();
            }
        }
        return result;
    }

    public static Memory call(Environment env, TraceInfo trace, String sign, String originName, Memory[] args, FunctionCallCache callCache, int cacheIndex) throws Throwable {
        FunctionEntity function = null;
        if (callCache != null) {
            function = (FunctionEntity)callCache.get(env, cacheIndex);
        }
        if (function == null && (function = env.fetchFunction(originName, sign)) != null && callCache != null) {
            callCache.put(env, cacheIndex, function);
        }
        if (function == null) {
            int p;
            if (!sign.isEmpty() && sign.charAt(0) != '\\' && (p = sign.lastIndexOf(92)) > -1) {
                function = env.fetchFunction(originName.substring(p + 1), sign.substring(p + 1));
            }
            if (function == null) {
                env.error(trace, Messages.ERR_CALL_TO_UNDEFINED_FUNCTION.fetch(originName), new Object[0]);
                return Memory.NULL;
            }
            if (callCache != null) {
                callCache.put(env, cacheIndex, function);
            }
        }
        return InvokeHelper.call(env, trace, function, args);
    }

    public static Memory callStaticDynamic(Environment env, TraceInfo trace, String originClassName, String className, String originMethodName, String methodName, Memory[] args, MethodCallCache callCache, int cacheIndex) throws Throwable {
        return InvokeHelper.callStatic(env, trace, className, methodName, originClassName, originMethodName, args, callCache, cacheIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Memory callStatic(Environment env, TraceInfo trace, String className, String methodName, String originClassName, String originMethodName, Memory[] args, MethodCallCache callCache, int cacheIndex) throws Throwable {
        Memory result;
        IObject maybeObject;
        MethodEntity entity;
        if (callCache != null && (entity = (MethodEntity)callCache.get(env, cacheIndex)) != null) {
            return InvokeHelper.callStatic(env, trace, entity, originClassName, args, false);
        }
        ClassEntity classEntity = env.fetchClass(originClassName, className, true);
        MethodEntity method = classEntity == null ? null : classEntity.findMethod(methodName);
        Memory[] passed = null;
        boolean isMagic = false;
        if (method == null) {
            maybeObject = env.getLateObject();
            if (maybeObject != null && maybeObject.getReflection().isInstanceOf(classEntity)) {
                return ObjectInvokeHelper.invokeMethod((Memory)new ObjectMemory(maybeObject), originMethodName, methodName, env, trace, args);
            }
            if (classEntity != null && classEntity.methodMagicCallStatic != null) {
                method = classEntity.methodMagicCallStatic;
                isMagic = true;
                passed = new Memory[]{new StringMemory(originMethodName), ArrayMemory.of(args)};
            } else if (classEntity == null) {
                env.error(trace, Messages.ERR_CLASS_NOT_FOUND.fetch(originClassName), new Object[0]);
                return Memory.NULL;
            }
        }
        if (method == null) {
            env.error(trace, Messages.ERR_CALL_TO_UNDEFINED_METHOD.fetch(originClassName + "::" + originMethodName), new Object[0]);
            return Memory.NULL;
        }
        if (!method.isStatic()) {
            maybeObject = env.getLateObject();
            if (maybeObject != null && maybeObject.getReflection().isInstanceOf(classEntity)) {
                return ObjectInvokeHelper.invokeMethod(maybeObject, method, env, trace, args, true);
            }
            env.error(trace, ErrorType.E_STRICT, Messages.ERR_NON_STATIC_METHOD_CALLED_DYNAMICALLY, originClassName, originMethodName);
        }
        if (callCache != null && !isMagic) {
            callCache.put(env, cacheIndex, method);
        }
        InvokeHelper.checkAccess(env, trace, method);
        if (passed == null) {
            passed = InvokeArgumentHelper.makeArguments(env, args, method.getParameters(), originClassName, originMethodName, originClassName, trace);
        }
        if ((result = method.getImmutableResultTyped(env, trace)) != null) {
            return result;
        }
        try {
            if (trace != null) {
                env.pushCall(trace, null, args, originMethodName, method.getClazz().getName(), originClassName);
            }
            Memory memory = method.invokeStatic(env, trace, passed);
            return memory;
        }
        finally {
            if (trace != null) {
                env.popCall();
            }
        }
    }

    public static Memory callStatic(Environment env, TraceInfo trace, MethodEntity method, Memory[] args) throws Throwable {
        return InvokeHelper.callStatic(env, trace, method, null, args, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Memory callStatic(Environment env, TraceInfo trace, MethodEntity method, @Reflection.Nullable String staticClass, Memory[] args, boolean checkAccess) throws Throwable {
        Memory result;
        if (checkAccess) {
            InvokeHelper.checkAccess(env, trace, method);
        }
        if ((result = method.getImmutableResultTyped(env, trace)) != null) {
            return result;
        }
        String originClassName = method.getClazz().getName();
        String originMethodName = method.getName();
        String staticClazz = staticClass == null ? originClassName : staticClass;
        Memory[] passed = InvokeArgumentHelper.makeArguments(env, args, method.getParameters(), originClassName, originMethodName, staticClass, trace);
        try {
            if (trace != null && method.isUsesStackTrace()) {
                env.pushCall(trace, null, passed, originMethodName, originClassName, staticClazz);
            }
            Memory memory = method.invokeStatic(env, passed);
            return memory;
        }
        finally {
            if (trace != null && method.isUsesStackTrace()) {
                env.popCall();
            }
        }
    }

    public static void checkReturnReference(Memory memory, Environment env, TraceInfo trace) {
        if (memory.isImmutable()) {
            env.warning(trace, Messages.ERR_RETURN_NOT_REFERENCE.fetch(new Object[0]), new Object[0]);
        }
    }

    public static void checkYieldReference(Memory memory, Environment env, TraceInfo trace) {
        if (memory.isImmutable()) {
            env.error(trace, ErrorType.E_NOTICE, Messages.ERR_YIELD_NOT_REFERENCE.fetch(new Object[0]), new Object[0]);
        }
    }
}

