/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.lang;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.invoke.Invoker;
import php.runtime.invoke.ObjectInvokeHelper;
import php.runtime.lang.BaseObject;
import php.runtime.lang.support.IStaticVariables;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ParameterEntity;

@Reflection.Name(value="Closure")
public abstract class Closure
extends BaseObject
implements IStaticVariables,
Cloneable {
    protected Memory[] uses;
    private Map<String, ReferenceMemory> statics;
    protected Memory self = Memory.NULL;
    protected String scope = null;

    public Closure(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public Closure(Environment env, ClassEntity closure, Memory self, String scope, Memory[] uses) {
        super(closure);
        this.self = self;
        this.scope = scope;
        if (env != null && (this.scope == null || this.scope.isEmpty())) {
            this.scope = env.getLateStatic();
        }
        if (this.scope != null && this.scope.isEmpty()) {
            this.scope = null;
        }
        this.uses = uses;
    }

    @Reflection.Signature
    public abstract Memory __invoke(Environment var1, Memory ... var2) throws Throwable;

    public Memory[] getUses() {
        return this.uses == null ? new Memory[]{} : this.uses;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="prop"), @Reflection.Arg(value="value")})
    public Memory __set(Environment env, Memory ... args) {
        env.error(ErrorType.E_ERROR, "Closure object cannot have properties", new Object[0]);
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="prop")})
    public Memory __get(Environment env, Memory ... args) {
        return this.__set(env, args);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="prop")})
    public Memory __unset(Environment env, Memory ... args) {
        return this.__set(env, args);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="prop")})
    public Memory __isset(Environment env, Memory ... args) {
        return this.__set(env, args);
    }

    @Override
    public Memory getStatic(String name) {
        if (this.statics == null) {
            return null;
        }
        return this.statics.get(name);
    }

    public String getScope() {
        return this.scope;
    }

    public Memory getSelf() {
        return this.self;
    }

    public Memory getOrCreateStatic(String name, Memory initValue) {
        ReferenceMemory result;
        if (this.statics == null) {
            this.statics = new HashMap<String, ReferenceMemory>();
        }
        if ((result = this.statics.get(name)) == null) {
            result = new ReferenceMemory(initValue);
            this.statics.put(name, result);
        }
        return result;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="newThis"), @Reflection.Arg(value="parameters", type=HintType.VARARG, optional=@Reflection.Optional(value="null"))})
    public Memory call(Environment env, Memory ... args) throws Throwable {
        ParameterEntity.validateTypeHinting(env, 1, args, HintType.OBJECT, true);
        Closure newClosure = (Closure)this.clone();
        newClosure.self = args[0];
        newClosure.scope = newClosure.self.toValue(ObjectMemory.class).getReflection().getName();
        return ObjectInvokeHelper.invokeMethod(newClosure, newClosure.getReflection().methodMagicInvoke, env, env.trace(), Arrays.copyOfRange(args, 1, args.length));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="newThis"), @Reflection.Arg(value="newScope", optional=@Reflection.Optional(value="static"))})
    public Memory bindTo(Environment env, Memory ... args) throws CloneNotSupportedException {
        ParameterEntity.validateTypeHinting(env, 1, args, HintType.OBJECT, true);
        Closure newClosure = (Closure)this.clone();
        newClosure.self = args[0];
        newClosure.scope = args[1].toString();
        return new ObjectMemory(newClosure);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="closure", typeClass="Closure"), @Reflection.Arg(value="newThis"), @Reflection.Arg(value="newScope", optional=@Reflection.Optional(value="static"))})
    public static Memory bind(Environment env, Memory ... args) throws CloneNotSupportedException {
        ParameterEntity.validateTypeHinting(env, 2, args, HintType.OBJECT, true);
        Closure closure = args[0].toObject(Closure.class);
        Closure newClosure = (Closure)closure.clone();
        newClosure.self = args[0];
        newClosure.scope = args[1].toString();
        return new ObjectMemory(newClosure);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="callable", type=HintType.CALLABLE)})
    public static Memory fromCallable(Environment env, Memory ... args) {
        Invoker invoker = Invoker.create(env, args[0]);
        return ObjectMemory.valueOf(new ClosureInvoker(env, invoker));
    }

    @Reflection.Name(value="php\\lang\\ClosureInvoker")
    public static class ClosureInvoker
    extends Closure {
        private Invoker invoker;

        public ClosureInvoker(Environment env, ClassEntity clazz) {
            super(env, clazz);
        }

        public ClosureInvoker(Environment env, Invoker invoker) {
            super(env, env.fetchClass(ClosureInvoker.class), Memory.NULL, "", new Memory[0]);
            this.invoker = invoker;
        }

        @Reflection.Signature
        private void __construct() {
        }

        @Override
        @Reflection.Signature
        public Memory __invoke(Environment env, Memory ... args) throws Throwable {
            return this.invoker.forEnvironment(env).call(args);
        }

        @Override
        public Memory getOrCreateStatic(String name) {
            return Memory.NULL;
        }
    }
}

