/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.loader.dump;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.loader.dump.Dumper;
import php.runtime.loader.dump.io.DumpInputStream;
import php.runtime.loader.dump.io.DumpOutputStream;
import php.runtime.reflection.PropertyEntity;

public class PropertyDumper
extends Dumper<PropertyEntity> {
    public PropertyDumper(Context context, Environment env, boolean debugInformation) {
        super(context, env, debugInformation);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void save(PropertyEntity entity, OutputStream output) throws IOException {
        DumpOutputStream print = new DumpOutputStream(output);
        print.writeBoolean(entity.isStatic());
        print.writeEnum(entity.getModifier());
        print.writeName(entity.getName());
        print.writeTrace(this.debugInformation ? entity.getTrace() : null);
        print.writeBoolean(entity.isDefault());
        print.writeMemory(entity.getDefaultValue());
        print.writeRawData(null);
    }

    @Override
    public PropertyEntity load(InputStream input) throws IOException {
        PropertyEntity property = new PropertyEntity(this.context);
        DumpInputStream data = new DumpInputStream(input);
        property.setStatic(data.readBoolean());
        property.setModifier(data.readModifier());
        property.setName(data.readName());
        property.setTrace(data.readTrace(this.context));
        property.setDefault(data.readBoolean());
        property.setDefaultValue(data.readMemory());
        byte[] raw = data.readRawData();
        return property;
    }
}

