/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory;

import php.runtime.Memory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.FalseMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringMemory;

public class StringBuilderMemory
extends StringMemory {
    StringBuilder builder = null;
    StringMemory cache = null;

    public StringBuilderMemory() {
        super("");
    }

    public StringBuilderMemory(String value) {
        super(value);
    }

    public StringBuilderMemory(char ch) {
        super(ch);
    }

    @Override
    public Memory toImmutable() {
        if (this.cache != null) {
            return this.cache;
        }
        this.cache = new StringMemory(this.toString());
        return this.cache;
    }

    @Override
    public String toString() {
        if (this.builder != null) {
            this.value = this.builder.toString();
            this.builder = null;
        }
        return this.value;
    }

    @Override
    public Memory toNumeric() {
        return this.toImmutable().toNumeric();
    }

    private void resolveBuilder() {
        this.cache = null;
        if (this.builder == null) {
            this.builder = new StringBuilder(this.value);
            this.value = null;
        }
    }

    public void append(Memory memory) {
        this.resolveBuilder();
        switch (memory.type) {
            case BOOL: {
                if (memory instanceof FalseMemory) break;
                this.builder.append(memory.toString());
                break;
            }
            case NULL: {
                break;
            }
            case INT: {
                this.builder.append(((LongMemory)memory).value);
                break;
            }
            case DOUBLE: {
                this.builder.append(((DoubleMemory)memory).value);
                break;
            }
            case STRING: {
                this.builder.append(memory.toString());
                break;
            }
            case REFERENCE: {
                this.append(memory.toImmutable());
                break;
            }
            default: {
                this.builder.append(memory.toString());
            }
        }
    }

    public void append(String value) {
        if (value == null) {
            return;
        }
        this.resolveBuilder();
        this.builder.append(value);
    }

    public void append(char value) {
        this.append(StringMemory.valueOf(value));
    }

    public void append(long value) {
        this.resolveBuilder();
        this.builder.append(value);
    }

    public void append(double value) {
        this.resolveBuilder();
        this.builder.append(value);
    }

    public void append(boolean value) {
        if (value) {
            this.resolveBuilder();
            this.builder.append(StringBuilderMemory.boolToString(value));
        }
    }

    public int length() {
        if (this.builder == null) {
            return this.value.length();
        }
        return this.builder.length();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StringBuilderMemory that = (StringBuilderMemory)o;
        return this.builder != null ? this.builder.equals(that.builder) : that.builder == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.builder != null ? this.builder.hashCode() : 0);
        return result;
    }
}

