/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.helper;

import java.nio.CharBuffer;
import php.runtime.Memory;
import php.runtime.env.TraceInfo;
import php.runtime.memory.StringMemory;

public class CharArrayMemory
extends StringMemory {
    protected CharBuffer buffer;

    public CharArrayMemory(String value) {
        super("");
        this.buffer = CharBuffer.allocate(value.length());
        this.buffer.put(value);
    }

    public CharArrayMemory(char ch) {
        super("");
        this.buffer = CharBuffer.allocate(1);
        this.buffer.put(ch);
    }

    @Override
    public Memory toImmutable() {
        return new StringMemory(this.buffer.toString());
    }

    @Override
    public String toString() {
        return new String(this.buffer.array());
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, Memory index) {
        int _index = -1;
        switch (index.type) {
            case STRING: {
                Memory tmp = StringMemory.toLong(index.toString());
                if (tmp == null) break;
                _index = tmp.toInteger();
                break;
            }
            case REFERENCE: {
                return this.valueOfIndex(index.toValue());
            }
            default: {
                _index = index.toInteger();
            }
        }
        if (_index < this.buffer.length() && _index >= 0) {
            return CharArrayMemory.getChar(this.buffer.charAt(_index));
        }
        return CONST_EMPTY_STRING;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, long index) {
        int _index = (int)index;
        if (_index >= 0 && _index < this.buffer.length()) {
            return CharArrayMemory.getChar(this.buffer.charAt(_index));
        }
        return CONST_EMPTY_STRING;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, double index) {
        int _index = (int)index;
        if (_index >= 0 && _index < this.buffer.length()) {
            return CharArrayMemory.getChar(this.buffer.charAt(_index));
        }
        return CONST_EMPTY_STRING;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, boolean index) {
        int _index;
        int n = _index = index ? 1 : 0;
        if (_index >= 0 && _index < this.buffer.length()) {
            return CharArrayMemory.getChar(this.buffer.charAt(_index));
        }
        return CONST_EMPTY_STRING;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, String index) {
        int _index = -1;
        Memory tmp = StringMemory.toLong(index);
        if (tmp != null) {
            _index = tmp.toInteger();
        }
        if (_index >= 0 && _index < this.buffer.length()) {
            return CharArrayMemory.getChar(this.buffer.charAt(_index));
        }
        return CONST_EMPTY_STRING;
    }

    public int length() {
        return this.buffer.length();
    }

    public void put(int index, String s) {
        char ch;
        int len = s.length();
        int sLen = this.buffer.limit();
        if (index < 0) {
            return;
        }
        char c = ch = len == 0 ? (char)'\u0000' : s.charAt(0);
        if (index < sLen) {
            this.buffer.put(index, ch);
        } else {
            int cnt = index - sLen;
            CharBuffer tmp = CharBuffer.allocate(sLen + cnt + 1);
            tmp.put(this.buffer.array());
            this.buffer = tmp;
            for (int i = 0; i < cnt; ++i) {
                this.buffer.append('\u001a');
            }
            this.buffer.append(ch);
        }
    }

    public char get(int index) {
        return this.buffer.get(index);
    }
}

