/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer;

import java.util.Arrays;
import java.util.List;
import org.develnext.jphp.core.tokenizer.token.Token;
import php.runtime.env.Context;
import php.runtime.env.TraceInfo;

public class TokenMeta {
    protected String word;
    protected final int startPosition;
    protected int endPosition;
    protected final int startLine;
    protected int endLine;
    protected int startIndex = -1;
    protected int endIndex = -1;
    private static final TokenMeta empty = new TokenMeta("", 0, 0, 0, 0);

    public TokenMeta(String word, int startLine, int endLine, int startPosition, int endPosition) {
        this.startLine = startLine;
        this.endLine = endLine;
        this.word = word;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public static TokenMeta of(List<? extends Token> tokens) {
        int startPosition = 0;
        int startLine = 0;
        int endPosition = 0;
        int endLine = 0;
        int startIndex = -1;
        int endIndex = -1;
        StringBuilder builder = new StringBuilder();
        int i = 0;
        int size = tokens.size();
        for (Token token : tokens) {
            if (token == null) continue;
            if (i == 0) {
                startIndex = token.getMeta().startIndex;
                startPosition = token.getMeta().startPosition;
                startLine = token.getMeta().startLine;
            }
            builder.append(token.getMeta().word);
            if (i == size - 1) {
                endPosition = token.getMeta().endPosition;
                endLine = token.getMeta().endLine;
                endIndex = token.getMeta().endIndex;
            }
            ++i;
        }
        TokenMeta meta = new TokenMeta(builder.toString(), startLine, endLine, startPosition, endPosition);
        meta.setStartIndex(startIndex);
        meta.setEndIndex(endIndex);
        return meta;
    }

    public static TokenMeta of(Token ... tokens) {
        return TokenMeta.of(Arrays.asList(tokens));
    }

    public static TokenMeta of(String word, Token token) {
        TokenMeta tokenMeta = new TokenMeta(word, token.getMeta().startLine, token.getMeta().endLine, token.getMeta().startPosition, token.getMeta().endPosition);
        tokenMeta.setStartIndex(token.getMeta().getStartIndex());
        tokenMeta.setEndIndex(token.getMeta().getEndIndex());
        return tokenMeta;
    }

    public static TokenMeta of(String word) {
        return new TokenMeta(word, 0, 0, 0, 0);
    }

    public void setWord(String word) {
        this.word = word;
    }

    public String getWord() {
        return this.word;
    }

    public void setEndPosition(int endPosition) {
        this.endPosition = endPosition;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public TraceInfo toTraceInfo(Context context) {
        return new TraceInfo(context, this.startLine, this.endLine, this.startPosition, this.endPosition);
    }

    public static TokenMeta empty() {
        return empty;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }
}

