/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token.stmt;

import java.util.Arrays;
import java.util.List;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.StmtToken;

public class BodyStmtToken
extends StmtToken {
    private Boolean constantly;
    private boolean alternativeSyntax = false;
    private List<ExprStmtToken> instructions;

    public BodyStmtToken(TokenMeta meta) {
        super(meta, TokenType.T_J_CUSTOM);
    }

    public List<ExprStmtToken> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<ExprStmtToken> instructions) {
        this.instructions = instructions;
        this.constantly = null;
    }

    public static BodyStmtToken of(ExprStmtToken ... instructions) {
        BodyStmtToken body = new BodyStmtToken(TokenMeta.of(instructions));
        body.setInstructions(Arrays.asList(instructions));
        return body;
    }

    public static BodyStmtToken of(List<ExprStmtToken> instructions) {
        BodyStmtToken body = new BodyStmtToken(TokenMeta.of(instructions));
        body.setInstructions(instructions);
        return body;
    }

    public boolean isAlternativeSyntax() {
        return this.alternativeSyntax;
    }

    public void setAlternativeSyntax(boolean alternativeSyntax) {
        this.alternativeSyntax = alternativeSyntax;
    }

    public boolean isConstantly() {
        if (this.constantly != null) {
            return this.constantly;
        }
        for (ExprStmtToken e : this.instructions) {
            if (e.isConstantly()) continue;
            this.constantly = false;
            return this.constantly;
        }
        this.constantly = true;
        return this.constantly;
    }
}

