/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token.stmt;

import java.util.ArrayList;
import java.util.List;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.CommentToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.StmtToken;
import php.runtime.common.Modifier;

public class ConstStmtToken
extends StmtToken {
    private ClassStmtToken clazz;
    private NamespaceStmtToken namespace;
    private CommentToken docComment;
    protected Modifier modifier = Modifier.PUBLIC;
    public final List<Item> items = new ArrayList<Item>();

    public ConstStmtToken(TokenMeta meta) {
        super(meta, TokenType.T_CONST);
    }

    public ClassStmtToken getClazz() {
        return this.clazz;
    }

    public Item add(NameToken name, ExprStmtToken value) {
        Item el = new Item(name, value);
        this.items.add(el);
        return el;
    }

    public void setClazz(ClassStmtToken clazz) {
        this.clazz = clazz;
        this.namespace = null;
    }

    public NamespaceStmtToken getNamespace() {
        return this.namespace;
    }

    public void setNamespace(NamespaceStmtToken namespace) {
        if (this.clazz != null) {
            throw new IllegalArgumentException("Cannot set namespace for a class constant");
        }
        this.namespace = namespace;
    }

    public CommentToken getDocComment() {
        return this.docComment;
    }

    public void setDocComment(CommentToken docComment) {
        this.docComment = docComment;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public void setModifier(Modifier modifier) {
        this.modifier = modifier;
    }

    public class Item {
        public final NameToken name;
        public final ExprStmtToken value;

        public Item(NameToken name, ExprStmtToken value) {
            this.name = name;
            this.value = value;
        }

        public String getFulledName(char delimiter) {
            return ConstStmtToken.this.namespace == null || ConstStmtToken.this.namespace.getName() == null ? this.name.getName() : ConstStmtToken.this.namespace.getName().toName(delimiter) + delimiter + this.name.getName();
        }

        public String getFulledName() {
            return this.getFulledName('\\');
        }
    }
}

