/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.control.tabpane;

import java.util.function.Consumer;
import java.util.function.Function;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.DragEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import org.develnext.jphp.ext.javafx.support.control.markers.PositionMarker;
import org.develnext.jphp.ext.javafx.support.control.markers.TabOutlineMarker;
import org.develnext.jphp.ext.javafx.support.control.tabpane.DndTabPane;
import org.develnext.jphp.ext.javafx.support.control.tabpane.skin.DnDTabPaneSkin;

public final class DndTabPaneFactory {
    private static MarkerFeedback CURRENT_FEEDBACK;

    private DndTabPaneFactory() {
    }

    public static DndTabPane createDndTabPane(final Consumer<DragSetup> setup) {
        return new DndTabPane(){

            protected Skin<?> createDefaultSkin() {
                DnDTabPaneSkin skin = new DnDTabPaneSkin(this);
                setup.accept(skin);
                return skin;
            }
        };
    }

    public static Pane createDefaultDnDPane(final FeedbackType feedbackType, Consumer<TabPane> setup) {
        final StackPane pane = new StackPane();
        DndTabPane tabPane = new DndTabPane(){

            protected Skin<?> createDefaultSkin() {
                DnDTabPaneSkin skin = new DnDTabPaneSkin(this);
                DndTabPaneFactory.setup(feedbackType, (Pane)pane, skin);
                return skin;
            }
        };
        if (setup != null) {
            setup.accept(tabPane);
        }
        pane.getChildren().add((Object)tabPane);
        return pane;
    }

    public static boolean hasDnDContent(DragEvent e) {
        return e.getDragboard().hasContent(DnDTabPaneSkin.TAB_MOVE);
    }

    public static String getDnDContent(DragEvent e) {
        return (String)e.getDragboard().getContent(DnDTabPaneSkin.TAB_MOVE);
    }

    public static void setup(final FeedbackType type, final Pane layoutNode, DragSetup setup) {
        setup.setStartFunction(new Function<Tab, Boolean>(){

            @Override
            public Boolean apply(Tab t) {
                DndTabPane tabPane = (DndTabPane)t.getTabPane();
                return !t.isDisabled() && ((DndTabPane)t.getTabPane()).isDraggingEnabled() && tabPane.isDraggableTab(t);
            }
        });
        setup.setFeedbackConsumer(new Consumer<FeedbackData>(){

            @Override
            public void accept(FeedbackData d) {
                DndTabPane tabPane = (DndTabPane)d.draggedTab.getTabPane();
                if (!tabPane.isDraggableTab(d.draggedTab)) {
                    DndTabPaneFactory.cleanup();
                    return;
                }
                DndTabPaneFactory.handleFeedback(type, layoutNode, d);
            }
        });
        setup.setDropConsumer(new Consumer<DroppedData>(){

            @Override
            public void accept(DroppedData data) {
                DndTabPane tabPane = (DndTabPane)data.draggedTab.getTabPane();
                if (!tabPane.isDraggableTab(data.targetTab)) {
                    return;
                }
                DndTabPaneFactory.handleDropped(data);
            }
        });
        setup.setDragFinishedConsumer(new Consumer<Tab>(){

            @Override
            public void accept(Tab tab) {
                DndTabPaneFactory.handleFinished(tab);
            }
        });
    }

    private static void fireTabDraggedEvent(DndTabPane tabPane, Tab draggedTab, int fromIndex, int toIndex) {
        tabPane.fireTabDragged(draggedTab, fromIndex, toIndex);
    }

    private static void handleDropped(DroppedData data) {
        TabPane targetPane = data.targetTab.getTabPane();
        int oldIndex = data.draggedTab.getTabPane().getTabs().indexOf((Object)data.draggedTab);
        data.draggedTab.getTabPane().getTabs().remove((Object)data.draggedTab);
        int idx = targetPane.getTabs().indexOf((Object)data.targetTab);
        if (data.dropType == DropType.AFTER) {
            if (idx + 1 <= targetPane.getTabs().size()) {
                targetPane.getTabs().add(idx + 1, (Object)data.draggedTab);
            } else {
                targetPane.getTabs().add((Object)data.draggedTab);
            }
        } else {
            targetPane.getTabs().add(idx, (Object)data.draggedTab);
        }
        DndTabPaneFactory.fireTabDraggedEvent((DndTabPane)targetPane, data.draggedTab, oldIndex, targetPane.getTabs().indexOf((Object)data.draggedTab));
        data.draggedTab.getTabPane().getSelectionModel().select((Object)data.draggedTab);
    }

    private static void handleFeedback(FeedbackType type, Pane layoutNode, FeedbackData data) {
        if (data.dropType == DropType.NONE) {
            DndTabPaneFactory.cleanup();
            return;
        }
        MarkerFeedback f = CURRENT_FEEDBACK;
        if (f == null || !f.data.equals(data)) {
            DndTabPaneFactory.cleanup();
            CURRENT_FEEDBACK = type == FeedbackType.MARKER ? DndTabPaneFactory.handleMarker(layoutNode, data) : DndTabPaneFactory.handleOutline(layoutNode, data);
        }
    }

    private static void handleFinished(Tab tab) {
        DndTabPaneFactory.cleanup();
    }

    static void cleanup() {
        if (CURRENT_FEEDBACK != null) {
            CURRENT_FEEDBACK.hide();
            CURRENT_FEEDBACK = null;
        }
    }

    private static MarkerFeedback handleMarker(Pane layoutNode, FeedbackData data) {
        PositionMarker marker = null;
        for (Node n : layoutNode.getChildren()) {
            if (!(n instanceof PositionMarker)) continue;
            marker = (PositionMarker)n;
        }
        if (marker == null) {
            marker = new PositionMarker();
            marker.setManaged(false);
            layoutNode.getChildren().add((Object)marker);
        } else {
            marker.setVisible(true);
        }
        double w = marker.getBoundsInLocal().getWidth();
        double h = marker.getBoundsInLocal().getHeight();
        double ratio = data.bounds.getHeight() / h;
        marker.setScaleX(ratio += 0.1);
        marker.setScaleY(ratio);
        double wDiff = w / 2.0;
        double hDiff = (h - h * ratio) / 2.0;
        if (data.dropType == DropType.AFTER) {
            marker.relocate(data.bounds.getMinX() + data.bounds.getWidth() - wDiff, data.bounds.getMinY() - hDiff);
        } else {
            marker.relocate(data.bounds.getMinX() - wDiff, data.bounds.getMinY() - hDiff);
        }
        final PositionMarker fmarker = marker;
        return new MarkerFeedback(data){

            @Override
            public void hide() {
                fmarker.setVisible(false);
            }
        };
    }

    private static MarkerFeedback handleOutline(Pane layoutNode, FeedbackData data) {
        TabOutlineMarker marker = null;
        for (Node n : layoutNode.getChildren()) {
            if (!(n instanceof TabOutlineMarker)) continue;
            marker = (TabOutlineMarker)n;
        }
        if (marker == null) {
            marker = new TabOutlineMarker(layoutNode.getBoundsInLocal(), (Bounds)new BoundingBox(data.bounds.getMinX(), data.bounds.getMinY(), data.bounds.getWidth(), data.bounds.getHeight()), data.dropType == DropType.BEFORE);
            marker.setManaged(false);
            marker.setMouseTransparent(true);
            layoutNode.getChildren().add((Object)marker);
        } else {
            marker.updateBounds(layoutNode.getBoundsInLocal(), (Bounds)new BoundingBox(data.bounds.getMinX(), data.bounds.getMinY(), data.bounds.getWidth(), data.bounds.getHeight()), data.dropType == DropType.BEFORE);
            marker.setVisible(true);
        }
        final TabOutlineMarker fmarker = marker;
        return new MarkerFeedback(data){

            @Override
            public void hide() {
                fmarker.setVisible(false);
            }
        };
    }

    public static interface DragSetup {
        public void setStartFunction(Function<Tab, Boolean> var1);

        public void setDragFinishedConsumer(Consumer<Tab> var1);

        public void setFeedbackConsumer(Consumer<FeedbackData> var1);

        public void setDropConsumer(Consumer<DroppedData> var1);

        public void setClipboardDataFunction(Function<Tab, String> var1);
    }

    public static class DroppedData {
        public final Tab draggedTab;
        public final Tab targetTab;
        public final DropType dropType;

        public DroppedData(Tab draggedTab, Tab targetTab, DropType dropType) {
            this.draggedTab = draggedTab;
            this.targetTab = targetTab;
            this.dropType = dropType;
        }
    }

    public static class FeedbackData {
        public final Tab draggedTab;
        public final Tab targetTab;
        public final Bounds bounds;
        public final DropType dropType;

        public FeedbackData(Tab draggedTab, Tab targetTab, Bounds bounds, DropType dropType) {
            this.draggedTab = draggedTab;
            this.targetTab = targetTab;
            this.bounds = bounds;
            this.dropType = dropType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bounds == null ? 0 : this.bounds.hashCode());
            result = 31 * result + this.draggedTab.hashCode();
            result = 31 * result + this.dropType.hashCode();
            result = 31 * result + (this.targetTab == null ? 0 : this.targetTab.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FeedbackData other = (FeedbackData)obj;
            if (this.bounds == null ? other.bounds != null : !this.bounds.equals(other.bounds)) {
                return false;
            }
            if (!this.draggedTab.equals(other.draggedTab)) {
                return false;
            }
            if (this.dropType != other.dropType) {
                return false;
            }
            return !(this.targetTab == null ? other.targetTab != null : !this.targetTab.equals(other.targetTab));
        }
    }

    public static enum FeedbackType {
        MARKER,
        OUTLINE;

    }

    public static enum DropType {
        NONE,
        BEFORE,
        AFTER;

    }

    private static abstract class MarkerFeedback {
        public final FeedbackData data;

        public MarkerFeedback(FeedbackData data) {
            this.data = data;
        }

        public abstract void hide();
    }
}

