/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.env.message;

import php.runtime.common.Messages;
import php.runtime.env.CallStackItem;
import php.runtime.env.Environment;
import php.runtime.exceptions.support.ErrorType;

public abstract class SystemMessage {
    private final Messages.Item message;
    private final Object[] args;
    private final CallStackItem trace;

    public SystemMessage(CallStackItem trace, Messages.Item message, Object ... args) {
        this.message = message;
        this.args = args;
        this.trace = trace;
    }

    public SystemMessage(Environment environment, Messages.Item message, Object ... args) {
        this.message = message;
        this.args = args;
        this.trace = environment.peekCall(0);
    }

    public CallStackItem getTrace() {
        return this.trace;
    }

    public String getMessage() {
        return this.message.fetch(this.args);
    }

    public String getDebugMessage() {
        return this.getType().getTypeName() + ": " + this.getMessage() + " in '" + this.trace.trace.getFileName() + "' on line " + (this.trace.trace.getStartLine() + 1) + " at pos " + (this.trace.trace.getStartPosition() + 1);
    }

    public abstract ErrorType getType();
}

