/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import php.runtime.Memory;
import php.runtime.Startup;
import php.runtime.common.Callback;
import php.runtime.common.LangMode;
import php.runtime.env.CompileScope;
import php.runtime.env.ConcurrentEnvironment;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.env.handler.EntityFetchHandler;
import php.runtime.exceptions.CriticalException;
import php.runtime.ext.core.classes.WrapClassLoader;
import php.runtime.ext.support.Extension;
import php.runtime.launcher.LaunchException;
import php.runtime.loader.dump.ModuleDumper;
import php.runtime.loader.dump.StandaloneLibrary;
import php.runtime.loader.dump.StandaloneLibraryDumper;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.helper.ClosureEntity;
import php.runtime.reflection.helper.GeneratorEntity;
import php.runtime.reflection.support.ReflectionUtils;

public class StandaloneLoader {
    protected final CompileScope scope;
    protected final Environment env;
    private ClassLoader classLoader;
    protected final Properties config = new Properties();
    protected boolean isDebug;
    private StandaloneLibrary library;

    public StandaloneLoader() {
        this.scope = new CompileScope();
        this.env = new ConcurrentEnvironment(this.scope, (OutputStream)System.out);
        this.env.getDefaultBuffer().setImplicitFlush(true);
        this.scope.addClassEntityFetchHandler(new EntityFetchHandler(){

            @Override
            public void fetch(CompileScope scope, String originName, String name) {
                ModuleEntity module = StandaloneLoader.this.fetchClass(name);
                if (module != null) {
                    StandaloneLoader.this.loadModule(module);
                    scope.loadModule(module, false);
                    scope.registerModule(module);
                }
            }
        });
        this.scope.addFunctionEntityFetchHandler(new EntityFetchHandler(){

            @Override
            public void fetch(CompileScope scope, String originName, String name) {
                ModuleEntity module = StandaloneLoader.this.fetchFunction(name);
                if (module != null) {
                    StandaloneLoader.this.loadModule(module);
                    scope.loadModule(module, false);
                    scope.registerModule(module);
                }
            }
        });
        this.scope.addConstantEntityFetchHandler(new EntityFetchHandler(){

            @Override
            public void fetch(CompileScope scope, String originName, String name) {
                ModuleEntity module = StandaloneLoader.this.fetchConstant(name);
                if (module != null) {
                    StandaloneLoader.this.loadModule(module);
                    scope.loadModule(module, false);
                    scope.registerModule(module);
                }
            }
        });
    }

    public StandaloneLoader(ClassLoader classLoader) {
        this();
        this.setClassLoader(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.scope.setNativeClassLoader(classLoader);
    }

    public Memory getConfigValue(String key) {
        return this.getConfigValue(key, Memory.NULL);
    }

    public Memory getConfigValue(String key, Memory def) {
        String result = this.config.getProperty(key);
        if (result == null) {
            return def;
        }
        return new StringMemory(result);
    }

    public Memory getConfigValue(String key, String def) {
        return this.getConfigValue(key, new StringMemory(def));
    }

    public Collection<InputStream> getResources(String name) {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        try {
            Enumeration<URL> urls = this.classLoader.getResources(name);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                result.add(url.openStream());
            }
            return result;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public void loadExtensions() {
        if (this.classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        ServiceLoader<Extension> loader = ServiceLoader.load(Extension.class, this.classLoader);
        for (Extension extension : loader) {
            this.scope.registerExtension(extension);
        }
    }

    public void initExtensions() {
        this.scope.getClassLoader().onAddLibrary(new Callback<Void, URL>(){

            @Override
            public Void call(URL param) {
                StandaloneLoader.this.loadExtensions();
                return null;
            }
        });
    }

    public void loadLibrary() throws IOException {
        if (this.classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        this.loadLibraryDump(this.classLoader.getResourceAsStream("JPHP-INF/library.dump"));
    }

    public void readConfig() {
        InputStream resource = this.classLoader.getResourceAsStream("JPHP-INF/launcher.conf");
        if (resource != null) {
            try {
                this.config.load(resource);
                for (String name : this.config.stringPropertyNames()) {
                    this.scope.configuration.put(name, new StringMemory(this.config.getProperty(name)));
                }
                this.isDebug = Startup.isDebug();
                this.scope.setDebugMode(this.isDebug);
                this.scope.setLangMode(LangMode.valueOf(this.getConfigValue("env.langMode", LangMode.MODERN.name()).toString().toUpperCase()));
            }
            catch (IOException e) {
                throw new LaunchException(e.getMessage());
            }
        }
    }

    public void run() {
        this.readConfig();
        String classLoader = this.config.getProperty("env.classLoader", ReflectionUtils.getClassName(WrapClassLoader.WrapLauncherClassLoader.class));
        if (classLoader != null && !classLoader.isEmpty()) {
            ClassEntity classLoaderEntity = this.env.fetchClass(classLoader);
            if (classLoaderEntity == null) {
                throw new LaunchException("Class loader class is not found: " + classLoader);
            }
            try {
                WrapClassLoader loader = (WrapClassLoader)classLoaderEntity.newObject(this.env, TraceInfo.UNKNOWN, true, new Memory[0]);
                this.env.invokeMethod(loader, "register", Memory.TRUE);
            }
            catch (Throwable e) {
                throw new CriticalException(e);
            }
        }
        this.run("JPHP-INF/.bootstrap.php");
    }

    public void run(String bootstrapScriptName) {
        this.loadExtensions();
        try {
            this.loadLibrary();
            ModuleEntity bootstrap = this.fetchModule(bootstrapScriptName);
            if (bootstrap != null) {
                bootstrap.includeNoThrow(this.env);
            } else {
                System.out.println("(!) Cannot find bootstrap script.");
            }
        }
        catch (IOException e) {
            throw new CriticalException(e);
        }
    }

    protected ModuleEntity _fetch(String name, Map<String, StandaloneLibrary.Module> source) {
        StandaloneLibrary.Module module = source.get(name);
        if (module == null) {
            return null;
        }
        if (this.scope.findUserModule(module.getName()) != null) {
            return null;
        }
        InputStream input = this.classLoader.getResourceAsStream(module.getInternalName() + ".dump");
        if (input == null) {
            throw new CriticalException("Cannot find resource: " + module.getInternalName() + ".dump");
        }
        ModuleDumper moduleDumper = new ModuleDumper(new Context(new File(module.getInternalName())), this.env, true);
        try {
            return moduleDumper.load(input);
        }
        catch (IOException e) {
            throw new CriticalException(e);
        }
    }

    public ModuleEntity fetchModule(String name) {
        if (this.library == null) {
            throw new CriticalException("Standalone library is not loaded");
        }
        ModuleEntity entity = this._fetch(name, this.library.getModules());
        if (entity != null) {
            this.loadModule(entity);
            this.scope.loadModule(entity, false);
            this.scope.addUserModule(entity);
        }
        return entity;
    }

    public ModuleEntity fetchClass(String name) {
        if (this.library == null) {
            throw new CriticalException("Standalone library is not loaded");
        }
        return this._fetch(name.toLowerCase(), this.library.getClassModules());
    }

    public ModuleEntity fetchFunction(String name) {
        if (this.library == null) {
            throw new CriticalException("Standalone library is not loaded");
        }
        return this._fetch(name.toLowerCase(), this.library.getFunctionModules());
    }

    public ModuleEntity fetchConstant(String name) {
        if (this.library == null) {
            throw new CriticalException("Standalone library is not loaded");
        }
        return this._fetch(name, this.library.getConstantModules());
    }

    public CompileScope getScope() {
        return this.scope;
    }

    protected void loadLibraryDump(InputStream input) throws IOException {
        StandaloneLibraryDumper dumper = new StandaloneLibraryDumper();
        this.library = dumper.load(input);
    }

    protected void loadModule(ModuleEntity moduleEntity) {
        try {
            moduleEntity.setNativeClazz(this.classLoader.loadClass(moduleEntity.getInternalName()));
            for (FunctionEntity functionEntity : moduleEntity.getFunctions()) {
                functionEntity.setNativeClazz(this.classLoader.loadClass(functionEntity.getInternalName()));
            }
            for (ClassEntity classEntity : moduleEntity.getClasses()) {
                classEntity.setNativeClazz(this.classLoader.loadClass(classEntity.getCompiledInternalName()));
            }
            for (ClosureEntity closureEntity : moduleEntity.getClosures()) {
                closureEntity.setNativeClazz(this.classLoader.loadClass(closureEntity.getInternalName()));
            }
            for (GeneratorEntity generatorEntity : moduleEntity.getGenerators()) {
                generatorEntity.setNativeClazz(this.classLoader.loadClass(generatorEntity.getInternalName()));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Environment getScopeEnvironment() {
        return this.env;
    }
}

