/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.common.Messages;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.CriticalException;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.ext.support.Extension;
import php.runtime.invoke.InvokeHelper;
import php.runtime.lang.Closure;
import php.runtime.lang.IObject;
import php.runtime.memory.ObjectMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.ParameterEntity;
import php.runtime.reflection.helper.ClosureEntity;
import php.runtime.reflection.support.AbstractFunctionEntity;
import php.runtime.reflection.support.TypeChecker;

@Reflection.Signature
public class MethodEntity
extends AbstractFunctionEntity {
    protected ClassEntity clazz;
    protected ClassEntity trait;
    protected Extension extension;
    protected MethodEntity prototype;
    protected Method nativeMethod;
    protected boolean isAbstract;
    protected boolean isFinal;
    protected boolean isStatic;
    protected php.runtime.common.Modifier modifier;
    protected boolean dynamicSignature = false;
    protected String signature;
    protected Closure cachedClosure;
    protected boolean contextDepends = false;

    public MethodEntity(Context context) {
        super(context);
    }

    public MethodEntity(FunctionEntity entity) {
        super(entity.getContext());
        this.setParameters(entity.getParameters());
        this.setReturnReference(entity.isReturnReference());
        this.setDeprecated(entity.isDeprecated());
        this.setAbstract(false);
        this.setAbstractable(false);
        this.setModifier(php.runtime.common.Modifier.PUBLIC);
    }

    public MethodEntity(MethodEntity entity) {
        super(entity.getContext());
        this.setParameters(entity.parameters);
        this.setReturnReference(entity.isReturnReference());
        this.setDeprecated(entity.isDeprecated());
        this.setAbstract(false);
        this.setAbstractable(false);
        this.setModifier(php.runtime.common.Modifier.PUBLIC);
    }

    public MethodEntity(Extension extension, Method method) {
        this((Context)null);
        this.extension = extension;
        this.usesStackTrace = true;
        Reflection.Signature signature = method.getAnnotation(Reflection.Signature.class);
        if (signature == null) {
            signature = this.getClass().getAnnotation(Reflection.Signature.class);
        }
        while (signature == null) {
            try {
                Class<?> cls = method.getDeclaringClass().getSuperclass();
                if (cls == null) break;
                signature = cls.getMethod(method.getName(), method.getParameterTypes()).getAnnotation(Reflection.Signature.class);
            }
            catch (Exception e) {
                throw new CriticalException(e);
            }
        }
        if (signature == null) {
            throw new IllegalArgumentException("Method is not annotated with @Reflection.Signature");
        }
        Class<?>[] types = method.getParameterTypes();
        if (types.length != 2 || types[0] != Environment.class || types[1] != Memory[].class) {
            throw new IllegalArgumentException("Invalid method signature - " + method.toGenericString());
        }
        int modifiers = method.getModifiers();
        this.isFinal = method.isAnnotationPresent(Reflection.Final.class);
        this.isStatic = Modifier.isStatic(modifiers);
        this.isAbstract = Modifier.isAbstract(modifiers);
        this.modifier = php.runtime.common.Modifier.PUBLIC;
        if (Modifier.isProtected(modifiers)) {
            this.modifier = php.runtime.common.Modifier.PROTECTED;
        } else if (Modifier.isPrivate(modifiers)) {
            this.modifier = php.runtime.common.Modifier.PRIVATE;
        }
        this.nativeMethod = method;
    }

    public Closure getClosure(Environment env, final IObject object) {
        if (this.cachedClosure != null) {
            return this.cachedClosure;
        }
        final MethodEntity bind = this;
        final ClosureEntity closureEntity1 = new ClosureEntity(this.getContext());
        closureEntity1.setParent(env.scope.fetchUserClass(Closure.class));
        closureEntity1.parameters = this.parameters;
        closureEntity1.setReturnReference(this.isReturnReference());
        MethodEntity m = new MethodEntity(this);
        m.setClazz(closureEntity1);
        m.setName("__invoke");
        closureEntity1.addMethod(m, null);
        closureEntity1.doneDeclare();
        Closure tmp = new Closure(env, closureEntity1, new ObjectMemory(env.getLateObject()), this.clazz.getName(), new Memory[0]){

            @Override
            public Memory __invoke(Environment e, Memory ... args) {
                try {
                    if (object == null) {
                        return bind.invokeStatic(e, args);
                    }
                    return bind.invokeDynamic(object, e, MethodEntity.this.trace, args);
                }
                catch (RuntimeException e1) {
                    throw e1;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }

            @Override
            public Memory getOrCreateStatic(String name) {
                return Memory.NULL;
            }

            @Override
            public ClassEntity getReflection() {
                return closureEntity1;
            }
        };
        try {
            m.setNativeMethod(tmp.getClass().getDeclaredMethod("__invoke", Environment.class, Memory[].class));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.cachedClosure = tmp;
        return this.cachedClosure;
    }

    public boolean isDynamicSignature() {
        return this.dynamicSignature;
    }

    public void setDynamicSignature(boolean dynamicSignature) {
        this.dynamicSignature = dynamicSignature;
    }

    @Override
    public Extension getExtension() {
        return this.extension;
    }

    public Method getNativeMethod() {
        return this.nativeMethod;
    }

    public void setNativeMethod(Method nativeMethod) {
        this.nativeMethod = nativeMethod;
        if (nativeMethod != null) {
            nativeMethod.setAccessible(true);
        }
    }

    @Override
    public Memory getImmutableResultTyped(Environment env, TraceInfo trace) {
        Memory result = this.getImmutableResult();
        if (result != null && !this.resultTypeChecked && (result = InvokeHelper.checkReturnType(env, trace, result, this)) != null) {
            this.result = result;
            this.resultTypeChecked = true;
        }
        return result;
    }

    public Memory invokeDynamic(IObject _this, Environment env, TraceInfo trace, Memory ... arguments) throws Throwable {
        try {
            if (this.isAbstract) {
                env.error(ErrorType.E_ERROR, "Cannot call abstract method %s", this.getSignatureString(false));
                Memory memory = Memory.NULL;
                return memory;
            }
            if (_this == null && !this.isStatic && (_this = this.clazz.newMock(env)) == null) {
                env.error(ErrorType.E_ERROR, Messages.ERR_STATIC_METHOD_CALLED_DYNAMICALLY.fetch(this.getClazz().getName() + "::" + this.getName()), new Object[0]);
            }
            if (this.isEmpty) {
                Memory memory = Memory.UNDEFINED;
                return memory;
            }
            Memory result = (Memory)this.nativeMethod.invoke((Object)_this, env, arguments);
            Memory memory = InvokeHelper.checkReturnType(env, trace, result, this);
            return memory;
        }
        catch (InvocationTargetException e) {
            Memory memory = env.__throwException(e);
            return memory;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            this.unsetArguments(arguments);
        }
    }

    public Memory invokeStatic(Environment env, TraceInfo trace, Memory ... arguments) throws Throwable {
        return this.invokeDynamic(null, env, trace, arguments);
    }

    public final Memory invokeStatic(Environment environment, Memory ... arguments) throws Throwable {
        return this.invokeStatic(environment, TraceInfo.UNKNOWN, arguments);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public MethodEntity getPrototype() {
        return this.prototype;
    }

    public void setPrototype(MethodEntity prototype) {
        this.prototype = prototype;
        this.contextDepends = prototype != null && (prototype.contextDepends || prototype.isPrivate());
    }

    public ClassEntity getClazz() {
        return this.clazz;
    }

    public String getClazzName() {
        return this.clazz.getName();
    }

    public void setClazz(ClassEntity clazz) {
        this.clazz = clazz;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    public php.runtime.common.Modifier getModifier() {
        return this.modifier;
    }

    public boolean isContextDepends() {
        return this.contextDepends;
    }

    public boolean isPublic() {
        return this.modifier == php.runtime.common.Modifier.PUBLIC;
    }

    public boolean isProtected() {
        return this.modifier == php.runtime.common.Modifier.PROTECTED;
    }

    public boolean isPrivate() {
        return this.modifier == php.runtime.common.Modifier.PRIVATE;
    }

    public void setModifier(php.runtime.common.Modifier modifier) {
        this.modifier = modifier;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean aFinal) {
        this.isFinal = aFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean aStatic) {
        this.isStatic = aStatic;
    }

    @Override
    public boolean isNamespace() {
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodEntity)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodEntity that = (MethodEntity)o;
        return this.hashCode() == that.hashCode();
    }

    public static int hashCode(String classLowerName, String methodLowerName) {
        return classLowerName.hashCode() + methodLowerName.hashCode();
    }

    public String getSignatureString(boolean withArgs) {
        String ownerName = this.getClazz().getName();
        if (this.getTrait() != null) {
            ownerName = this.getTrait().getName();
        }
        StringBuilder sb = new StringBuilder(ownerName + "::" + this.getName() + "(");
        int i = 0;
        if (this.parameters != null && withArgs) {
            for (ParameterEntity param : this.parameters) {
                sb.append(param.getSignatureString());
                if (i != this.parameters.length - 1) {
                    sb.append(", ");
                }
                ++i;
            }
        }
        sb.append(")");
        TypeChecker returnTypeChecker = this.getReturnTypeChecker();
        if (returnTypeChecker != null) {
            sb.append(": ").append(returnTypeChecker.getSignature());
        }
        return sb.toString();
    }

    public String getSignature() {
        TypeChecker typeChecker;
        if (this.signature != null) {
            return this.signature;
        }
        StringBuilder sb = new StringBuilder();
        boolean i = false;
        if (this.parameters != null) {
            for (ParameterEntity param : this.parameters) {
                if (param.getDefaultValue() != null) continue;
                sb.append((Object)(param.getType() == null ? HintType.ANY : param.getType())).append("|").append(param.isReference ? "&" : "");
            }
        }
        if ((typeChecker = this.getReturnTypeChecker()) != null) {
            String signature = typeChecker.getSignature();
            sb.append(":");
            sb.append(signature);
        }
        this.signature = sb.toString();
        return this.signature;
    }

    public boolean equalsBySignature(MethodEntity method, boolean strong) {
        if (strong) {
            return this.getSignature().equals(method.getSignature());
        }
        int cnt1 = this.parameters != null ? this.parameters.length : 0;
        int cnt2 = method.parameters != null ? method.parameters.length : 0;
        return cnt1 == cnt2;
    }

    public boolean equalsBySignature(MethodEntity method) {
        return this.equalsBySignature(method, true);
    }

    public boolean equalsByHintTypingSignature(MethodEntity method) {
        if (this.parameters == null || method.parameters == null) {
            return true;
        }
        int i = 0;
        for (ParameterEntity param : this.parameters) {
            if (i >= method.parameters.length) break;
            ParameterEntity other = method.parameters[i];
            if (param.getTypeClass() != null ? other.getTypeClass() == null || !other.getTypeClassLower().equals(param.getTypeClassLower()) : param.getType() != HintType.ANY && other.getType() != param.getType()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isOwned(ClassEntity entity) {
        return this.clazz.getId() == entity.getId();
    }

    public int canAccess(Environment env) {
        return this.canAccess(env, null);
    }

    public int canAccess(Environment env, ClassEntity context) {
        switch (this.modifier) {
            case PUBLIC: {
                return 0;
            }
            case PRIVATE: {
                ClassEntity cl;
                ClassEntity classEntity = cl = context == null ? env.getLastClassOnStack() : context;
                if (cl == null) {
                    return 2;
                }
                if (cl.getId() == this.clazz.getId()) {
                    return 0;
                }
                MethodEntity tmp = this.prototype;
                while (tmp != null) {
                    if (cl.getId() == tmp.clazz.getId()) {
                        return 0;
                    }
                    tmp = tmp.prototype;
                }
                return 2;
            }
            case PROTECTED: {
                ClassEntity originClass = context == null ? env.getLateStaticClass() : context;
                ClassEntity clazz = originClass;
                if (clazz == null) {
                    return 1;
                }
                long id = this.clazz.getId();
                do {
                    if (clazz.getId() != id) continue;
                    return 0;
                } while ((clazz = clazz.parent) != null);
                if (this.clazz.isInstanceOf(originClass)) {
                    return 0;
                }
                return 1;
            }
        }
        return 2;
    }

    public ClassEntity getTrait() {
        return this.trait;
    }

    public void setTrait(ClassEntity trait) {
        this.trait = trait;
    }

    public int getRequiredParamCount() {
        int cnt = 0;
        if (this.parameters != null) {
            for (ParameterEntity e : this.parameters) {
                if (e.getDefaultValue() != null) break;
            }
        }
        return cnt;
    }

    public MethodEntity duplicateForInject() {
        MethodEntity methodEntity = new MethodEntity(this.context);
        methodEntity.setExtension(this.getExtension());
        methodEntity.setAbstract(this.isAbstract);
        methodEntity.setFinal(this.isFinal);
        methodEntity.setDynamicSignature(this.isDynamicSignature());
        methodEntity.setModifier(this.modifier);
        methodEntity.setName(this.name);
        methodEntity.setStatic(this.isStatic);
        methodEntity.setAbstractable(this.isAbstractable());
        methodEntity.setDocComment(this.getDocComment());
        methodEntity.setParameters(this.parameters);
        methodEntity.setReturnReference(this.isReturnReference());
        methodEntity.setEmpty(this.isEmpty);
        methodEntity.setImmutable(this.isImmutable);
        methodEntity.setResult(this.result);
        methodEntity.setUsesStackTrace(this.isUsesStackTrace());
        methodEntity.setDeprecated(this.isDeprecated());
        methodEntity.setInternalName(this.getInternalName());
        methodEntity.setReturnTypeNullable(this.isReturnTypeNullable());
        methodEntity.setReturnTypeChecker(this.getReturnTypeChecker());
        if (this.trace == null || this.trace == TraceInfo.UNKNOWN) {
            methodEntity.setTrace(this.getClazz().getTrace());
        } else {
            methodEntity.setTrace(this.trace);
        }
        return methodEntity;
    }
}

