/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.develnext.jphp.core.compiler.common.misc.StackItem;
import org.develnext.jphp.core.compiler.jvm.misc.JumpItem;
import org.develnext.jphp.core.compiler.jvm.misc.LocalVariable;
import org.develnext.jphp.core.compiler.jvm.node.MethodNodeImpl;
import org.develnext.jphp.core.compiler.jvm.statement.ClassStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.GeneratorStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.StmtCompiler;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ArgumentStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.BodyStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.MethodStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ReturnStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.TryStmtToken;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import php.runtime.Memory;
import php.runtime.common.Messages;
import php.runtime.env.Environment;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.helper.ClassConstantMemory;
import php.runtime.memory.helper.ConstantMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.DocumentComment;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ParameterEntity;
import php.runtime.reflection.helper.GeneratorEntity;
import php.runtime.reflection.support.TypeChecker;

public class MethodStmtCompiler
extends StmtCompiler<MethodEntity> {
    public final ClassStmtCompiler clazz;
    public MethodStmtToken statement;
    public final MethodNode node;
    protected int statementIndex = 0;
    private Stack<StackItem> stack = new Stack();
    private final List<JumpItem> jumpStack = new ArrayList<JumpItem>();
    final Stack<TryCatchItem> tryStack = new Stack();
    final List<BodyStmtToken> finallyBlocks = new ArrayList<BodyStmtToken>();
    private int stackLevel = 0;
    private int stackSize = 0;
    private int stackMaxSize = 0;
    private Map<String, LabelNode> gotoLabels;
    private Map<String, LocalVariable> localVariables;
    protected String realName;
    private boolean external = false;
    private long methodId;
    private LabelNode labelStart;
    private Map<Class<?>, AtomicInteger> statementIndexes = new HashMap();
    private Set<Integer> lineTickHandled = new HashSet<Integer>();
    private GeneratorEntity generatorEntity;

    public MethodStmtCompiler(ClassStmtCompiler clazz, MethodNode node) {
        super(clazz.getCompiler());
        this.clazz = clazz;
        this.statement = null;
        this.node = node;
        this.localVariables = new LinkedHashMap<String, LocalVariable>();
        this.entity = new MethodEntity(this.getCompiler().getContext());
        ((MethodEntity)this.entity).setClazz((ClassEntity)clazz.entity);
        ((MethodEntity)this.entity).setName(node.name);
        this.realName = ((MethodEntity)this.entity).getName();
        this.methodId = this.compiler.getScope().nextMethodIndex();
    }

    public MethodStmtCompiler(ClassStmtCompiler clazz, MethodStmtToken statement) {
        super(clazz.getCompiler());
        this.clazz = clazz;
        this.statement = statement;
        this.node = new MethodNodeImpl();
        this.localVariables = new LinkedHashMap<String, LocalVariable>();
        this.entity = new MethodEntity(this.getCompiler().getContext());
        ((MethodEntity)this.entity).setClazz((ClassEntity)clazz.entity);
        if (statement != null) {
            ((MethodEntity)this.entity).setName(statement.getName().getName());
        }
        this.realName = ((MethodEntity)this.entity).getName();
        this.methodId = this.compiler.getScope().nextMethodIndex();
    }

    public long getMethodId() {
        return this.methodId;
    }

    public long getClassId() {
        return ((ClassEntity)this.clazz.entity).getId();
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public GeneratorEntity getGeneratorEntity() {
        return this.generatorEntity;
    }

    public void setGeneratorEntity(GeneratorEntity generatorEntity) {
        this.generatorEntity = generatorEntity;
    }

    public Stack<TryCatchItem> getTryStack() {
        return this.tryStack;
    }

    public Map<String, LocalVariable> getLocalVariables() {
        return this.localVariables;
    }

    public boolean registerTickTrigger(int line) {
        return this.lineTickHandled.add(line);
    }

    public int nextStatementIndex(Class<?> clazz) {
        AtomicInteger atomic = this.statementIndexes.get(clazz);
        if (atomic == null) {
            atomic = new AtomicInteger();
            this.statementIndexes.put(clazz, atomic);
        }
        return atomic.getAndIncrement();
    }

    public int prevStatementIndex(Class<?> clazz) {
        AtomicInteger atomic = this.statementIndexes.get(clazz);
        if (atomic == null) {
            atomic = new AtomicInteger();
            this.statementIndexes.put(clazz, atomic);
        }
        return atomic.getAndDecrement();
    }

    public void pushJump(LabelNode breakLabel, LabelNode continueLabel, int stackSize) {
        this.jumpStack.add(new JumpItem(breakLabel, continueLabel, stackSize));
    }

    public void pushJump(LabelNode breakLabel, LabelNode continueLabel) {
        this.pushJump(breakLabel, continueLabel, 0);
    }

    public JumpItem getJump(int level) {
        if (this.jumpStack.size() - level < 0) {
            return null;
        }
        if (this.jumpStack.size() - level >= this.jumpStack.size()) {
            return null;
        }
        return this.jumpStack.get(this.jumpStack.size() - level);
    }

    public int getJumpStackSize(int level) {
        int size = 0;
        for (int i = this.jumpStack.size(); i >= 0 && this.jumpStack.size() - i < level; --i) {
            JumpItem item = this.getJump(i);
            size += item.stackSize;
        }
        return size;
    }

    public void popJump() {
        this.jumpStack.remove(this.jumpStack.size() - 1);
    }

    void push(StackItem item) {
        if (item.getLevel() == -1) {
            item.setLevel(this.stackLevel++);
        }
        this.stack.push(item);
        this.stackSize += item.size;
        if (this.stackMaxSize < this.stackSize) {
            this.stackMaxSize = this.stackSize;
        }
    }

    int getStackSize() {
        return this.stackSize;
    }

    int getStackCount() {
        return this.stack.size();
    }

    StackItem pop() {
        StackItem item = this.stack.pop();
        this.stackSize -= item.size;
        return item;
    }

    void popAll() {
        this.stackSize = 0;
        this.stack.clear();
    }

    StackItem peek() {
        return this.stack.peek();
    }

    public LabelNode getGotoLabel(String name) {
        return this.gotoLabels == null ? null : this.gotoLabels.get(name.toLowerCase());
    }

    public LabelNode getOrCreateGotoLabel(String name) {
        LabelNode label;
        name = name.toLowerCase();
        if (this.gotoLabels == null) {
            this.gotoLabels = new HashMap<String, LabelNode>();
        }
        if ((label = this.gotoLabels.get(name)) == null) {
            label = new LabelNode();
            this.gotoLabels.put(name, label);
        }
        return label;
    }

    public LocalVariable addLocalVariable(String variable, LabelNode label, Class clazz) {
        LocalVariable result = new LocalVariable(variable, this.localVariables.size(), label, clazz);
        this.localVariables.put(variable, result);
        return result;
    }

    public LocalVariable getOrAddLocalVariable(String variable, LabelNode label, Class clazz) {
        LocalVariable local = this.getLocalVariable(variable);
        if (local == null) {
            local = this.addLocalVariable(variable, label, clazz);
        } else if (local.getClazz() != clazz) {
            throw new RuntimeException("Invalid class for " + variable + " variable, " + local.getClazz() + " != " + clazz.getClass());
        }
        return local;
    }

    public LocalVariable addLocalVariable(String variable, LabelNode label) {
        return this.addLocalVariable(variable, label, Memory.class);
    }

    public LocalVariable getLocalVariable(String variable) {
        return this.localVariables.get(variable);
    }

    void writeHeader() {
        int access = 0;
        if (this.statement != null) {
            if (this.compiler.getScope().isDebugMode()) {
                this.statement.setDynamicLocal(true);
            }
            switch (this.statement.getModifier()) {
                case PRIVATE: {
                    access += 2;
                    break;
                }
                case PROTECTED: {
                    access += 4;
                    break;
                }
                case PUBLIC: {
                    ++access;
                }
            }
            if (this.statement.isStatic()) {
                access += 8;
            }
            if (this.statement.isFinal()) {
                access += 16;
            }
            this.node.access = access;
            this.node.name = this.clazz.isSystem() || this.entity == null ? this.statement.getName().getName() : ((MethodEntity)this.entity).getInternalName();
            this.node.desc = Type.getMethodDescriptor(Type.getType(Memory.class), Type.getType(Environment.class), Type.getType(Memory[].class));
            if (this.external) {
                this.node.desc = Type.getMethodDescriptor(Type.getType(Memory.class), Type.getType(Environment.class), Type.getType(Memory[].class), Type.getType(ArrayMemory.class));
            }
        }
        if (this.statement != null) {
            LabelNode label = this.labelStart = this.writeLabel(this.node, this.statement.getMeta().getStartLine());
            if (!this.statement.isStatic()) {
                this.addLocalVariable("~this", label, Object.class);
            }
            ExpressionStmtCompiler expressionCompiler = new ExpressionStmtCompiler(this, null);
            this.addLocalVariable("~env", label, Environment.class);
            LocalVariable args = this.addLocalVariable("~args", label, Memory[].class);
            if (this.statement.isDynamicLocal()) {
                if (this.external) {
                    this.addLocalVariable("~passedLocal", label, ArrayMemory.class);
                }
                LocalVariable local = this.addLocalVariable("~local", label, ArrayMemory.class);
                if (this.external) {
                    expressionCompiler.writeVarLoad("~passedLocal");
                    expressionCompiler.writeSysStaticCall(ArrayMemory.class, "valueOfRef", ArrayMemory.class, ArrayMemory.class);
                    expressionCompiler.setStackPeekAsImmutable();
                    expressionCompiler.writeVarStore(local, false, true);
                } else {
                    expressionCompiler.writePushConstNull();
                    expressionCompiler.writeSysStaticCall(ArrayMemory.class, "valueOfRef", ArrayMemory.class, ArrayMemory.class);
                    expressionCompiler.setStackPeekAsImmutable();
                    expressionCompiler.writeVarStore(local, false, true);
                }
            }
            if (this.statement.getUses() != null && !this.statement.getUses().isEmpty()) {
                int i = 0;
                expressionCompiler.writeVarLoad("~this");
                expressionCompiler.writeGetDynamic("uses", Memory[].class);
                for (ArgumentStmtToken argument : this.statement.getUses()) {
                    LocalVariable local;
                    if (this.statement.isDynamicLocal()) {
                        expressionCompiler.writeDefineVariable(argument.getName());
                        local = this.getLocalVariable(argument.getName().getName());
                    } else {
                        local = this.addLocalVariable(argument.getName().getName(), label, Memory.class);
                    }
                    if (argument.isReference()) {
                        local.setReference(true);
                        this.statement.variable(argument.getName()).setUnstable(true);
                    }
                    expressionCompiler.writePushDup();
                    expressionCompiler.writePushGetFromArray(i, Memory.class);
                    if (this.statement.isDynamicLocal()) {
                        expressionCompiler.writeVarAssign(local, argument.getName(), false, false);
                    } else {
                        expressionCompiler.writeVarStore(local, false, false);
                    }
                    local.pushLevel();
                    ++i;
                }
                expressionCompiler.writePopAll(1);
            }
            int i = 0;
            for (ArgumentStmtToken argument : this.statement.getArguments()) {
                if (argument.isReference()) {
                    this.statement.variable(argument.getName()).setReference(true).setUnstable(true);
                }
                LabelNode next = new LabelNode();
                expressionCompiler.writeDefineVariable(argument.getName());
                LocalVariable local = this.getLocalVariable(argument.getName().getName());
                if (local != null) {
                    expressionCompiler.writeVarLoad(args);
                    expressionCompiler.writePushGetFromArray(i, Memory.class);
                    expressionCompiler.writeVarAssign(local, argument.getName(), true, false);
                    this.node.instructions.add(new JumpInsnNode(199, next));
                    expressionCompiler.stackPop();
                    if (argument.getValue() == null) {
                        expressionCompiler.writePushNull();
                    } else {
                        expressionCompiler.writeExpression(argument.getValue(), true, false);
                    }
                    expressionCompiler.writeVarAssign(local, argument.getName(), false, false);
                    this.node.instructions.add(next);
                    local.pushLevel();
                }
                ++i;
            }
        } else {
            LabelNode labelNode = this.labelStart = this.writeLabel(this.node, this.clazz.statement.getMeta().getStartLine());
        }
    }

    void writeFooter() {
        LabelNode endL = new LabelNode();
        this.node.instructions.add(endL);
        for (LocalVariable variable : this.localVariables.values()) {
            String description = Type.getDescriptor(variable.getClazz() == null ? Object.class : variable.getClazz());
            if (variable.name.equals("~this")) {
                description = "L" + ((ClassEntity)this.clazz.entity).getCompiledInternalName() + ";";
            }
            this.node.localVariables.add(new LocalVariableNode(variable.name, description, null, variable.label == null ? this.labelStart : variable.label, variable.getEndLabel() == null ? endL : variable.getEndLabel(), variable.index));
        }
    }

    @Override
    public MethodEntity compile() {
        if (this.statement != null) {
            if (this.external) {
                this.statement.setDynamicLocal(true);
            }
            if (this.statement.getDocComment() != null) {
                ((MethodEntity)this.entity).setDocComment(new DocumentComment(this.statement.getDocComment().getComment()));
            }
            ((MethodEntity)this.entity).setAbstract(this.statement.isAbstract());
            ((MethodEntity)this.entity).setAbstractable(this.statement.getBody() == null);
            ((MethodEntity)this.entity).setFinal(this.statement.isFinal());
            ((MethodEntity)this.entity).setStatic(this.statement.isStatic());
            ((MethodEntity)this.entity).setModifier(this.statement.getModifier());
            ((MethodEntity)this.entity).setReturnReference(this.statement.isReturnReference());
            ((MethodEntity)this.entity).setTrace(this.statement.toTraceInfo(this.compiler.getContext()));
            ((MethodEntity)this.entity).setImmutable(this.statement.getArguments().isEmpty());
            ((MethodEntity)this.entity).setGeneratorEntity(this.generatorEntity);
            if (this.statement.getReturnHintTypeClass() != null) {
                ((MethodEntity)this.entity).setReturnTypeChecker(TypeChecker.of(this.statement.getReturnHintTypeClass().getName()));
            } else if (this.statement.getReturnHintType() != null) {
                ((MethodEntity)this.entity).setReturnTypeChecker(TypeChecker.of(this.statement.getReturnHintType()));
            }
            ((MethodEntity)this.entity).setReturnTypeNullable(this.statement.isReturnOptional());
            if (this.clazz.isSystem()) {
                ((MethodEntity)this.entity).setInternalName(((MethodEntity)this.entity).getName());
            } else {
                ((MethodEntity)this.entity).setInternalName(((MethodEntity)this.entity).getName() + "$" + ((ClassEntity)this.clazz.entity).nextMethodIndex());
            }
            ParameterEntity[] parameters = new ParameterEntity[this.statement.getArguments().size()];
            int i = 0;
            for (ArgumentStmtToken argument : this.statement.getArguments()) {
                parameters[i] = new ParameterEntity(this.compiler.getContext());
                ParameterEntity parameter = parameters[i];
                parameter.setReference(argument.isReference());
                parameter.setName(argument.getName().getName());
                parameter.setTrace(argument.toTraceInfo(this.compiler.getContext()));
                parameter.setNullable(argument.isOptional());
                parameter.setMutable(this.statement.isDynamicLocal() || this.statement.variable(argument.getName()).isMutable());
                parameter.setUsed(!this.statement.isUnusedVariable(argument.getName()));
                parameter.setVariadic(argument.isVariadic());
                parameter.setType(argument.getHintType());
                if (argument.getHintTypeClass() != null) {
                    parameter.setTypeClass(argument.getHintTypeClass().getName());
                }
                ExpressionStmtCompiler expressionStmtCompiler = new ExpressionStmtCompiler(this.compiler);
                ExprStmtToken value = argument.getValue();
                if (value != null) {
                    Memory defaultValue = expressionStmtCompiler.writeExpression(value, true, true, false);
                    if (value.isSingle()) {
                        StaticAccessExprToken access;
                        if (value.getSingle() instanceof NameToken) {
                            parameter.setDefaultValueConstName(((NameToken)value.getSingle()).getName());
                            if (defaultValue == null) {
                                defaultValue = new ConstantMemory(((NameToken)value.getSingle()).getName());
                                parameter.setMutable(true);
                            }
                        } else if (value.getSingle() instanceof StaticAccessExprToken && (access = (StaticAccessExprToken)value.getSingle()).getClazz() instanceof NameToken && access.getField() instanceof NameToken) {
                            if (defaultValue == null) {
                                defaultValue = new ClassConstantMemory(((NameToken)access.getClazz()).getName(), ((NameToken)access.getField()).getName());
                            }
                            parameter.setDefaultValueConstName(((NameToken)access.getClazz()).getName() + "::" + ((NameToken)access.getField()).getName());
                            parameter.setMutable(true);
                        }
                    }
                    if (defaultValue == null) {
                        this.compiler.getEnvironment().error(argument.toTraceInfo(this.compiler.getContext()), ErrorType.E_COMPILE_ERROR, Messages.ERR_EXPECTED_CONST_VALUE, "$" + argument.getName().getName());
                    }
                    parameter.setDefaultValue(defaultValue);
                }
                ++i;
            }
            ((MethodEntity)this.entity).setParameters(parameters);
        }
        if (this.statement != null && this.clazz.statement.isInterface()) {
            if (!this.statement.isInterfacable()) {
                this.compiler.getEnvironment().error(((MethodEntity)this.entity).getTrace(), Messages.ERR_INTERFACE_FUNCTION_CANNOT_CONTAIN_BODY.fetch(((MethodEntity)this.entity).getSignatureString(false)), new Object[0]);
            }
            if (this.statement.isAbstract() || this.statement.isFinal()) {
                this.compiler.getEnvironment().error(((MethodEntity)this.entity).getTrace(), Messages.ERR_ACCESS_TYPE_FOR_INTERFACE_METHOD.fetch(((MethodEntity)this.entity).getSignatureString(false)), new Object[0]);
            }
        } else {
            this.writeHeader();
            if (this.statement.isGenerator()) {
                ((MethodEntity)this.entity).setEmpty(false);
                ((MethodEntity)this.entity).setImmutable(false);
                ((MethodEntity)this.entity).setResult(null);
                GeneratorStmtCompiler generatorStmtCompiler = new GeneratorStmtCompiler(this.compiler, this.statement);
                ((MethodEntity)this.entity).setGeneratorEntity(generatorStmtCompiler.compile());
                ExpressionStmtCompiler expr = new ExpressionStmtCompiler(this, null);
                expr.makeUnknown(new TypeInsnNode(187, ((MethodEntity)this.entity).getGeneratorEntity().getInternalName()));
                expr.stackPush(Memory.Type.REFERENCE);
                expr.writePushDup();
                expr.writePushEnv();
                expr.writePushDup();
                expr.writePushConstString(this.compiler.getModule().getInternalName());
                expr.writePushConstInt((int)((MethodEntity)this.entity).getGeneratorEntity().getId());
                expr.writeSysDynamicCall(Environment.class, "__getGenerator", ClassEntity.class, String.class, Integer.TYPE);
                expr.writePushThis();
                expr.writeVarLoad("~args");
                expr.writeSysCall(((MethodEntity)this.entity).getGeneratorEntity().getInternalName(), 183, "<init>", Void.TYPE, Environment.class, ClassEntity.class, Memory.class, Memory[].class);
                expr.writeSysStaticCall(ObjectMemory.class, "valueOf", Memory.class, IObject.class);
                expr.makeUnknown(new InsnNode(176));
                expr.stackPop();
            } else {
                ExpressionStmtCompiler expr = new ExpressionStmtCompiler(this, null);
                ((MethodEntity)this.entity).setEmpty(true);
                if (((MethodEntity)this.entity).getResult() == null) {
                    ((MethodEntity)this.entity).setResult(Memory.UNDEFINED);
                }
                if (this.statement != null && this.statement.getBody() != null) {
                    expr.writeDefineVariables(this.statement.getLocal());
                    expr.write(this.statement.getBody());
                    if (!this.statement.getBody().getInstructions().isEmpty()) {
                        ((MethodEntity)this.entity).setEmpty(false);
                    }
                }
                if (this.generatorEntity != null) {
                    expr.writeVarLoad("~this");
                    expr.writePushConstBoolean(false);
                    expr.writeSysDynamicCall(null, "_setValid", Void.TYPE, Boolean.TYPE);
                }
                ReturnStmtToken token = new ReturnStmtToken(new TokenMeta("", 0, 0, 0, 0));
                token.setValue(null);
                token.setEmpty(true);
                expr.getCompiler(ReturnStmtToken.class).write(token);
            }
            this.writeFooter();
        }
        return (MethodEntity)this.entity;
    }

    public static class TryCatchItem {
        private final TryStmtToken token;
        private final LabelNode returnLabel;

        public TryCatchItem(TryStmtToken token, LabelNode returnLabel) {
            this.token = token;
            this.returnLabel = returnLabel;
        }

        public TryStmtToken getToken() {
            return this.token;
        }

        public LabelNode getReturnLabel() {
            return this.returnLabel;
        }
    }
}

