/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer;

import java.util.HashMap;
import java.util.Map;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.token.BreakToken;
import org.develnext.jphp.core.tokenizer.token.ColonToken;
import org.develnext.jphp.core.tokenizer.token.CommentToken;
import org.develnext.jphp.core.tokenizer.token.OpenEchoTagToken;
import org.develnext.jphp.core.tokenizer.token.OpenTagToken;
import org.develnext.jphp.core.tokenizer.token.SemicolonToken;
import org.develnext.jphp.core.tokenizer.token.StringStartDocToken;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.BackslashExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.BraceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.CommaToken;
import org.develnext.jphp.core.tokenizer.token.expr.DollarExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AmpersandRefToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AndExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArgumentUnpackExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignAndExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignConcatExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignDivExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignMinusExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignModExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignMulExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignOrExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignPlusExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignPowExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignShiftLeftExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignShiftRightExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.AssignXorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.BooleanAnd2ExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.BooleanAndExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.BooleanNotEqualExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.BooleanNotExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.BooleanOr2ExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.BooleanOrExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.BooleanXorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.CloneExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ConcatExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DecExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DivExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.EqualExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.GreaterExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.GreaterOrEqualExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.IdenticalExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.IncExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.InstanceofExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.KeyValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.MinusExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ModExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.MulExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.NotExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.NotIdenticalExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.OrExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.PlusExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.PowExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ShiftLeftExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ShiftRightExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.SilentToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.SmallerExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.SmallerOrEqualToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.SpaceshipExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ValueIfElseToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ValueNullCoalesceIfElseToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.XorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.BooleanExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.DieExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.DoubleExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.EmptyExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.FromExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.FulledNameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.IncludeExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.IncludeOnceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.IntegerExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.IssetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ListExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NewExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NullExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ParentExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.PrintNameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.RequireExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.RequireOnceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.SelfExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.UnsetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.YieldExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.ClassMacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.DirMacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.FileMacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.FunctionMacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.LineMacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.MethodMacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.NamespaceMacroToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.macro.TraitMacroToken;
import org.develnext.jphp.core.tokenizer.token.stmt.AbstractStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.AsStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.BreakStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.CaseStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.CatchStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ConstStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ContinueStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.DeclareStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.DefaultStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.DoStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EchoStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ElseIfStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ElseStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EnddeclareStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EndforStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EndforeachStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EndifStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EndswitchStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.EndwhileStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExtendsStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FinalStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FinallyStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ForStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ForeachStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.FunctionStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.GlobalStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.GotoStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.IfStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ImplementsStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.InsteadofStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.InterfaceStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceUseStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.PrivateStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ProtectedStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.PublicStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ReturnStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.SwitchStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ThrowStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.TraitStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.TryStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.VarStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.WhileStmtToken;
import php.runtime.common.GrammarUtils;

public class TokenFinder {
    private static final HashMap<String, Class<? extends Token>> patterns = new HashMap<String, Class<? extends Token>>(){
        {
            this.put("<?", OpenTagToken.class);
            this.put("<?php", OpenTagToken.class);
            this.put("?>", BreakToken.class);
            this.put("<?=", OpenEchoTagToken.class);
            this.put("/*", CommentToken.class);
            this.put("//", CommentToken.class);
            this.put("<<<", StringStartDocToken.class);
            this.put("+", PlusExprToken.class);
            this.put("-", MinusExprToken.class);
            this.put("*", MulExprToken.class);
            this.put("/", DivExprToken.class);
            this.put("%", ModExprToken.class);
            this.put("**", PowExprToken.class);
            this.put("=", AssignExprToken.class);
            this.put("\\", BackslashExprToken.class);
            this.put("==", EqualExprToken.class);
            this.put("!=", BooleanNotEqualExprToken.class);
            this.put("<>", BooleanNotEqualExprToken.class);
            this.put("===", IdenticalExprToken.class);
            this.put("!==", NotIdenticalExprToken.class);
            this.put(">", GreaterExprToken.class);
            this.put(">=", GreaterOrEqualExprToken.class);
            this.put("<", SmallerExprToken.class);
            this.put("<=", SmallerOrEqualToken.class);
            this.put("&&", BooleanAndExprToken.class);
            this.put("and", BooleanAnd2ExprToken.class);
            this.put("||", BooleanOrExprToken.class);
            this.put("or", BooleanOr2ExprToken.class);
            this.put("xor", BooleanXorExprToken.class);
            this.put("!", BooleanNotExprToken.class);
            this.put("?", ValueIfElseToken.class);
            this.put("??", ValueNullCoalesceIfElseToken.class);
            this.put("~", NotExprToken.class);
            this.put("^", XorExprToken.class);
            this.put("|", OrExprToken.class);
            this.put("&", AndExprToken.class);
            this.put(">>", ShiftRightExprToken.class);
            this.put("<<", ShiftLeftExprToken.class);
            this.put("@", SilentToken.class);
            this.put("->", DynamicAccessExprToken.class);
            this.put("::", StaticAccessExprToken.class);
            this.put("=>", KeyValueExprToken.class);
            this.put("+=", AssignPlusExprToken.class);
            this.put("-=", AssignMinusExprToken.class);
            this.put("*=", AssignMulExprToken.class);
            this.put("**=", AssignPowExprToken.class);
            this.put("/=", AssignDivExprToken.class);
            this.put("%=", AssignModExprToken.class);
            this.put(".=", AssignConcatExprToken.class);
            this.put("^=", AssignXorExprToken.class);
            this.put("&=", AssignAndExprToken.class);
            this.put("|=", AssignOrExprToken.class);
            this.put("++", IncExprToken.class);
            this.put("--", DecExprToken.class);
            this.put(">>=", AssignShiftRightExprToken.class);
            this.put("<<=", AssignShiftLeftExprToken.class);
            this.put("...", ArgumentUnpackExprToken.class);
            this.put("<=>", SpaceshipExprToken.class);
            this.put("new", NewExprToken.class);
            this.put("clone", CloneExprToken.class);
            this.put("instanceof", InstanceofExprToken.class);
            this.put("insteadof", InsteadofStmtToken.class);
            this.put(".", ConcatExprToken.class);
            this.put(":", ColonToken.class);
            this.put("true", BooleanExprToken.class);
            this.put("false", BooleanExprToken.class);
            this.put("null", NullExprToken.class);
            this.put(";", SemicolonToken.class);
            this.put("&", AmpersandRefToken.class);
            this.put(",", CommaToken.class);
            this.put("$", DollarExprToken.class);
            this.put("{", BraceExprToken.class);
            this.put("[", BraceExprToken.class);
            this.put("(", BraceExprToken.class);
            this.put("}", BraceExprToken.class);
            this.put("]", BraceExprToken.class);
            this.put(")", BraceExprToken.class);
            this.put("static", StaticExprToken.class);
            this.put("self", SelfExprToken.class);
            this.put("parent", ParentExprToken.class);
            this.put("as", AsStmtToken.class);
            this.put("if", IfStmtToken.class);
            this.put("else", ElseStmtToken.class);
            this.put("elseif", ElseIfStmtToken.class);
            this.put("while", WhileStmtToken.class);
            this.put("do", DoStmtToken.class);
            this.put("for", ForStmtToken.class);
            this.put("foreach", ForeachStmtToken.class);
            this.put("switch", SwitchStmtToken.class);
            this.put("case", CaseStmtToken.class);
            this.put("default", DefaultStmtToken.class);
            this.put("declare", DeclareStmtToken.class);
            this.put("return", ReturnStmtToken.class);
            this.put("endif", EndifStmtToken.class);
            this.put("endforeach", EndforeachStmtToken.class);
            this.put("endfor", EndforStmtToken.class);
            this.put("endwhile", EndwhileStmtToken.class);
            this.put("endswitch", EndswitchStmtToken.class);
            this.put("enddeclare", EnddeclareStmtToken.class);
            this.put("break", BreakStmtToken.class);
            this.put("continue", ContinueStmtToken.class);
            this.put("goto", GotoStmtToken.class);
            this.put("unset", UnsetExprToken.class);
            this.put("isset", IssetExprToken.class);
            this.put("empty", EmptyExprToken.class);
            this.put("die", DieExprToken.class);
            this.put("exit", DieExprToken.class);
            this.put("class", ClassStmtToken.class);
            this.put("interface", InterfaceStmtToken.class);
            this.put("trait", TraitStmtToken.class);
            this.put("function", FunctionStmtToken.class);
            this.put("const", ConstStmtToken.class);
            this.put("namespace", NamespaceStmtToken.class);
            this.put("use", NamespaceUseStmtToken.class);
            this.put("abstract", AbstractStmtToken.class);
            this.put("final", FinalStmtToken.class);
            this.put("private", PrivateStmtToken.class);
            this.put("protected", ProtectedStmtToken.class);
            this.put("public", PublicStmtToken.class);
            this.put("var", VarStmtToken.class);
            this.put("try", TryStmtToken.class);
            this.put("catch", CatchStmtToken.class);
            this.put("finally", FinallyStmtToken.class);
            this.put("throw", ThrowStmtToken.class);
            this.put("extends", ExtendsStmtToken.class);
            this.put("implements", ImplementsStmtToken.class);
            this.put("global", GlobalStmtToken.class);
            this.put("list", ListExprToken.class);
            this.put("__line__", LineMacroToken.class);
            this.put("__file__", FileMacroToken.class);
            this.put("__dir__", DirMacroToken.class);
            this.put("__function__", FunctionMacroToken.class);
            this.put("__class__", ClassMacroToken.class);
            this.put("__method__", MethodMacroToken.class);
            this.put("__trait__", TraitMacroToken.class);
            this.put("__namespace__", NamespaceMacroToken.class);
            this.put("include", IncludeExprToken.class);
            this.put("include_once", IncludeOnceExprToken.class);
            this.put("require", RequireExprToken.class);
            this.put("require_once", RequireOnceExprToken.class);
            this.put("echo", EchoStmtToken.class);
            this.put("print", PrintNameToken.class);
            this.put("yield", YieldExprToken.class);
            this.put("from", FromExprToken.class);
        }
    };
    public static final int MAX_FIND_CACHE_SIZE = 10000;
    private Map<String, Class<? extends Token>> findCache = new HashMap<String, Class<? extends Token>>();

    public Class<? extends Token> find(String word) {
        Class<? extends Token> token;
        if (this.findCache.size() > 10000) {
            this.findCache.clear();
        }
        if ((token = this.findCache.get(word)) != null) {
            return token;
        }
        token = patterns.get(word = word.toLowerCase());
        if (token != null) {
            this.findCache.put(word, token);
            return token;
        }
        int length = word.length();
        if (length == 0) {
            return null;
        }
        if (GrammarUtils.isVariable(word)) {
            this.findCache.put(word, VariableExprToken.class);
            return VariableExprToken.class;
        }
        if (GrammarUtils.isInteger(word) || GrammarUtils.isHexInteger(word) || GrammarUtils.isBinaryInteger(word)) {
            this.findCache.put(word, IntegerExprToken.class);
            return IntegerExprToken.class;
        }
        if (GrammarUtils.isSimpleFloat(word) || GrammarUtils.isExpFloat(word)) {
            this.findCache.put(word, DoubleExprToken.class);
            return DoubleExprToken.class;
        }
        boolean fulledName = false;
        for (int i = 0; i < length; ++i) {
            char ch = word.charAt(i);
            if (ch == '\\') {
                fulledName = true;
                continue;
            }
            if (GrammarUtils.isNameChar(ch)) continue;
            return null;
        }
        if (fulledName) {
            if (word.length() < 32) {
                this.findCache.put(word, FulledNameToken.class);
            }
            return FulledNameToken.class;
        }
        if (word.length() < 32) {
            this.findCache.put(word, NameToken.class);
        }
        return NameToken.class;
    }

    public Class<? extends Token> find(TokenMeta meta) {
        return this.find(meta.getWord());
    }
}

