/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.control;

import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class FlatButton
extends Button {
    private static final String DEFAULT_STYLE_CLASS = "x-flat-button";
    protected Color color;
    protected Color hoverColor;
    protected Color clickColor;
    protected double borderRadius = 0.0;
    private boolean _entered = false;
    private boolean _clicked = false;

    public FlatButton() {
        this(null, null);
    }

    public FlatButton(String text) {
        this(text, null);
    }

    public FlatButton(String text, Node graphic) {
        super(text, graphic);
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.setTextFill((Paint)Color.BLACK);
        this.setColor(null);
        this.setHoverColor(null);
        this.setClickColor(null);
        this.addEventFilter(MouseEvent.MOUSE_ENTERED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (FlatButton.this.hoverColor != null) {
                    FlatButton.this.setBackgroundColor(FlatButton.this.hoverColor);
                } else {
                    FlatButton.this.setBackgroundColor(FlatButton.this.color);
                }
                FlatButton.this._entered = true;
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_EXITED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FlatButton.this.setBackgroundColor(FlatButton.this.color);
                FlatButton.this._entered = false;
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FlatButton.this._clicked = true;
                if (FlatButton.this.clickColor != null) {
                    FlatButton.this.setBackgroundColor(FlatButton.this.clickColor);
                } else {
                    FlatButton.this.setBackgroundColor(FlatButton.this.hoverColor != null && FlatButton.this._entered ? FlatButton.this.hoverColor : FlatButton.this.color);
                }
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FlatButton.this._clicked = false;
                FlatButton.this.setBackgroundColor(FlatButton.this.hoverColor != null && FlatButton.this._entered ? FlatButton.this.hoverColor : FlatButton.this.color);
            }
        });
    }

    protected void setBackgroundColor(Color color) {
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, new CornerRadii(this.borderRadius), null)}));
    }

    protected Color getBackgroundColor() {
        Paint fill;
        Background background = this.getBackground();
        if (background != null && background.getFills().size() > 0 && (fill = ((BackgroundFill)background.getFills().get(0)).getFill()) instanceof Color) {
            return (Color)fill;
        }
        return null;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        if (!this._entered && !this._clicked) {
            this.setBackgroundColor(color);
        }
    }

    public Color getHoverColor() {
        return this.hoverColor;
    }

    public void setHoverColor(Color hoverColor) {
        this.hoverColor = hoverColor;
        if (this._entered && hoverColor != null) {
            this.setBackgroundColor(hoverColor);
        }
    }

    public Color getClickColor() {
        return this.clickColor;
    }

    public void setClickColor(Color clickColor) {
        this.clickColor = clickColor;
        if (this._clicked && clickColor != null) {
            this.setBackgroundColor(clickColor);
        }
    }

    public double getBorderRadius() {
        return this.borderRadius;
    }

    public void setBorderRadius(double borderRadius) {
        this.borderRadius = borderRadius;
        this.setBackgroundColor(this.getBackgroundColor());
    }
}

