/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.json.classes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.develnext.jphp.json.gson.MemoryDeserializer;
import org.develnext.jphp.json.gson.MemorySerializer;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.format.WrapProcessor;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.invoke.Invoker;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.CharMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.FalseMemory;
import php.runtime.memory.KeyValueMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.NullMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringBuilderMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.TrueMemory;
import php.runtime.memory.helper.ArrayValueMemory;
import php.runtime.memory.helper.BinaryCharArrayMemory;
import php.runtime.memory.helper.CharArrayMemory;
import php.runtime.memory.helper.ShortcutMemory;
import php.runtime.memory.helper.UndefinedMemory;
import php.runtime.memory.helper.VariadicMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\format\\JsonProcessor")
public class JsonProcessor
extends WrapProcessor {
    public static final int SERIALIZE_PRETTY_PRINT = 1;
    public static final int DESERIALIZE_AS_ARRAYS = 1024;
    public static final int DESERIALIZE_LENIENT = 2048;
    protected GsonBuilder builder;
    protected Gson gson;
    protected MemorySerializer memorySerializer;
    protected MemoryDeserializer memoryDeserializer;
    protected static final List<Class<? extends Memory>> memClasses = new ArrayList<Class<? extends Memory>>(){
        {
            this.add(Memory.class);
            this.add(NullMemory.class);
            this.add(UndefinedMemory.class);
            this.add(ReferenceMemory.class);
            this.add(TrueMemory.class);
            this.add(FalseMemory.class);
            this.add(LongMemory.class);
            this.add(DoubleMemory.class);
            this.add(ObjectMemory.class);
            this.add(ArrayMemory.class);
            this.add(BinaryMemory.class);
            this.add(CharMemory.class);
            this.add(KeyValueMemory.class);
            this.add(StringBuilderMemory.class);
            this.add(StringMemory.class);
            this.add(ArrayValueMemory.class);
            this.add(BinaryCharArrayMemory.class);
            this.add(CharArrayMemory.class);
            this.add(ShortcutMemory.class);
            this.add(VariadicMemory.class);
        }
    };

    public JsonProcessor(Environment env, GsonBuilder builder) {
        super(env);
        this.builder = builder;
        this.gson = builder.create();
    }

    public JsonProcessor(Environment env, ClassEntity clazz) {
        super(env, clazz);
        this.builder = new GsonBuilder();
        this.memorySerializer = new MemorySerializer();
        this.memorySerializer.setEnv(env);
        this.memoryDeserializer = new MemoryDeserializer();
        this.memoryDeserializer.setEnv(env);
        for (Class<? extends Memory> el : memClasses) {
            this.builder.registerTypeAdapter(el, this.memorySerializer);
        }
        this.builder.registerTypeAdapter((Type)((Object)Memory.class), this.memoryDeserializer);
        this.builder.disableHtmlEscaping();
        this.gson = this.builder.create();
    }

    @Reflection.Signature(value={@Reflection.Arg(value="flags", optional=@Reflection.Optional(value="0"))})
    public Memory __construct(Environment env, Memory ... args) {
        int flags = args[0].toInteger();
        if ((flags & 1) == 1) {
            this.builder.setPrettyPrinting();
        }
        if ((flags & 0x800) == 2048) {
            this.builder.setLenient();
        }
        if ((flags & 0x400) == 1024) {
            this.memoryDeserializer.setAssoc(true);
        }
        if (flags > 0) {
            this.gson = this.builder.create();
        }
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory parse(Environment env, Memory ... args) {
        Memory r;
        try {
            r = args[0].instanceOf(Stream.class) ? this.gson.fromJson((Reader)new InputStreamReader(Stream.getInputStream(env, args[0])), Memory.class) : this.gson.fromJson(args[0].toString(), Memory.class);
        }
        catch (JsonSyntaxException e) {
            env.exception(WrapProcessor.ProcessorException.class, e.getMessage(), new Object[0]);
            return Memory.NULL;
        }
        if (r == null) {
            return Memory.NULL;
        }
        return r;
    }

    @Override
    @Reflection.Signature
    public Memory format(Environment env, Memory ... args) {
        try {
            return StringMemory.valueOf(this.gson.toJson(args[0]));
        }
        catch (JsonIOException e) {
            env.exception(WrapProcessor.ProcessorException.class, e.getMessage(), new Object[0]);
            return Memory.NULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Reflection.Signature
    public Memory formatTo(Environment env, Memory ... args) {
        OutputStream outputStream = Stream.getOutputStream(env, args[1]);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            this.gson.toJson((Object)args[0], (Type)((Object)Memory.class), writer);
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new JsonIOException(e);
            }
        }
        catch (JsonIOException e) {
            env.exception(WrapProcessor.ProcessorException.class, e.getMessage(), new Object[0]);
            Memory memory = Memory.NULL;
            return memory;
        }
        finally {
            Stream.closeStream(env, outputStream);
        }
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="type"), @Reflection.Arg(value="callback", type=HintType.CALLABLE, optional=@Reflection.Optional(value="null"))})
    public Memory onSerialize(Environment env, Memory ... args) {
        Memory.Type type = Memory.Type.of(args[0].toString());
        if (type == null) {
            throw new IllegalArgumentException("Invalid type - " + args[0]);
        }
        MemorySerializer.Handler handler = null;
        if (!args[1].isNull()) {
            final Invoker invoker = Invoker.valueOf(env, env.trace(), args[1]);
            handler = new MemorySerializer.Handler(){

                @Override
                public Memory call(Environment env, Memory value) {
                    return invoker.callNoThrow(value);
                }
            };
        }
        this.memorySerializer.setTypeHandler(type, handler);
        return null;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="className"), @Reflection.Arg(value="callback", type=HintType.CALLABLE, optional=@Reflection.Optional(value="null"))})
    public Memory onClassSerialize(Environment env, Memory ... args) {
        ClassEntity entity = env.fetchClass(args[0].toString(), true);
        if (entity == null) {
            throw new IllegalArgumentException("Class not found - " + args[0]);
        }
        MemorySerializer.Handler handler = null;
        if (!args[1].isNull()) {
            final Invoker invoker = Invoker.valueOf(env, env.trace(), args[1]);
            handler = new MemorySerializer.Handler(){

                @Override
                public Memory call(Environment env, Memory value) {
                    return invoker.callNoThrow(value);
                }
            };
        }
        this.memorySerializer.setClassHandler(entity.getName(), handler);
        return Memory.NULL;
    }
}

