/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.env;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Package {
    private Set<String> classes = new HashSet<String>();
    private Set<String> functions = new HashSet<String>();
    private Set<String> constants = new HashSet<String>();

    public boolean addClass(String className) {
        return this.classes.add(className);
    }

    public boolean addFunction(String functionName) {
        return this.functions.add(functionName);
    }

    public boolean addConstant(String constantName) {
        return this.constants.add(constantName);
    }

    public Package duplicate() {
        Package aPackage = new Package();
        aPackage.classes = new HashSet<String>(this.classes);
        aPackage.functions = new HashSet<String>(this.functions);
        aPackage.constants = new HashSet<String>(this.constants);
        return aPackage;
    }

    public Collection<String> getClasses() {
        return this.classes;
    }

    public Collection<String> getFunctions() {
        return this.functions;
    }

    public Collection<String> getConstants() {
        return this.constants;
    }

    public boolean hasClass(String typeName) {
        return this.classes.contains(typeName);
    }

    public boolean hasFunction(String name) {
        return this.functions.contains(name);
    }

    public boolean hasConstant(String name) {
        return this.constants.contains(name);
    }
}

