/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.env;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import php.runtime.env.Environment;
import php.runtime.env.Package;
import php.runtime.env.PackageLoader;
import php.runtime.env.TraceInfo;

public class PackageManager {
    private final Map<String, Package> packages = new HashMap<String, Package>();
    private final Set<PackageLoader> loaders = new LinkedHashSet<PackageLoader>();
    private final Environment env;

    public PackageManager(Environment env) {
        this.env = env;
    }

    public void apply(PackageManager parent) {
        for (Map.Entry<String, Package> packageEntry : parent.packages.entrySet()) {
            this.packages.put(packageEntry.getKey(), packageEntry.getValue().duplicate());
        }
    }

    public Collection<String> names() {
        return this.packages.keySet();
    }

    public boolean has(String name) {
        return this.packages.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Package tryFind(String name, TraceInfo trace) {
        Package aPackage = this.packages.get(name);
        if (aPackage == null) {
            Set<PackageLoader> set = this.loaders;
            synchronized (set) {
                for (PackageLoader loader : this.loaders) {
                    Package newPackage = loader.load(name, trace);
                    if (newPackage == null) continue;
                    Map<String, Package> map = this.packages;
                    synchronized (map) {
                        this.packages.put(name, newPackage);
                        return newPackage;
                    }
                }
                return null;
            }
        }
        return aPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Package fetch(String name) {
        Package aPackage = this.packages.get(name);
        if (aPackage == null) {
            Map<String, Package> map = this.packages;
            synchronized (map) {
                aPackage = this.packages.get(name);
                if (aPackage != null) {
                    return aPackage;
                }
                aPackage = new Package();
                this.packages.put(name, aPackage);
            }
        }
        return aPackage;
    }

    public synchronized boolean registerLoader(PackageLoader loader) {
        return this.loaders.add(loader);
    }

    public synchronized boolean unregisterLoader(PackageLoader loader) {
        return this.loaders.remove(loader);
    }

    public synchronized void set(String name, Package aPackage) {
        this.packages.put(name, aPackage);
    }
}

