/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.reflection;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.core.reflection.ReflectionFunctionAbstract;
import php.runtime.ext.core.reflection.ReflectionParameter;
import php.runtime.invoke.InvokeHelper;
import php.runtime.invoke.ObjectInvokeHelper;
import php.runtime.lang.Closure;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.CompileFunctionEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.ParameterEntity;
import php.runtime.reflection.helper.ClosureEntity;
import php.runtime.reflection.support.AbstractFunctionEntity;

@Reflection.Name(value="ReflectionFunction")
@Reflection.Signature(value={@Reflection.Arg(value="name", type=HintType.STRING, readOnly=true)})
public class ReflectionFunction
extends ReflectionFunctionAbstract {
    public static final int IS_DEPRECATED = 262144;
    protected Closure closure;
    protected ClosureEntity closureEntity;
    protected FunctionEntity functionEntity;
    protected ArrayMemory cachedParameters;

    public ReflectionFunction(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public void setFunctionEntity(FunctionEntity functionEntity) {
        this.functionEntity = functionEntity;
        this.getProperties().put("name", new StringMemory(functionEntity.getName()));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name")})
    public Memory __construct(Environment env, Memory ... args) {
        Memory name = args[0].toValue();
        if (name.isClosure()) {
            this.closure = (Closure)name.toValue(ObjectMemory.class).value;
            this.closureEntity = (ClosureEntity)this.closure.getReflection();
        } else {
            this.functionEntity = env.fetchFunction(name.toString());
            if (this.functionEntity == null) {
                this.exception(env, "Function %s does not exist", name.toString());
            }
            this.setFunctionEntity(this.functionEntity);
        }
        return Memory.NULL;
    }

    @Override
    protected AbstractFunctionEntity getEntity() {
        return this.functionEntity;
    }

    @Override
    protected ClosureEntity getClosureEntity() {
        return this.closureEntity;
    }

    @Override
    protected IObject getInstance() {
        return this.closure;
    }

    @Override
    @Reflection.Signature
    public Memory getNumberOfParameters(Environment env, Memory ... args) {
        if (this.functionEntity instanceof CompileFunctionEntity) {
            return LongMemory.valueOf(((CompileFunctionEntity)this.functionEntity).getCompileFunction().getMaxArgs());
        }
        return super.getNumberOfParameters(env, args);
    }

    @Override
    @Reflection.Signature
    public Memory getNumberOfRequiredParameters(Environment env, Memory ... args) {
        if (this.functionEntity instanceof CompileFunctionEntity) {
            return LongMemory.valueOf(((CompileFunctionEntity)this.functionEntity).getCompileFunction().getMinArgs());
        }
        return super.getNumberOfRequiredParameters(env, args);
    }

    @Reflection.Signature
    public Memory isDisabled(Environment env, Memory ... args) {
        if (this.closure != null) {
            return Memory.FALSE;
        }
        return Memory.FALSE;
    }

    @Reflection.Signature
    public Memory getClosure(Environment env, Memory ... args) throws Throwable {
        if (this.closure != null) {
            return new ObjectMemory(this.closure);
        }
        return new ObjectMemory(this.functionEntity.getClosure(env));
    }

    @Reflection.Signature
    public Memory invoke(Environment env, Memory ... args) throws Throwable {
        if (this.closure != null) {
            return ObjectInvokeHelper.invokeMethod(this.closure, this.closureEntity.methodMagicInvoke, env, env.peekCall((int)0).trace, args, true);
        }
        return InvokeHelper.call(env, env.peekCall((int)0).trace, this.functionEntity, args);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="args", type=HintType.ARRAY)})
    public Memory invokeArgs(Environment env, Memory ... args) throws Throwable {
        ArrayMemory value = args[0].toValue(ArrayMemory.class);
        Memory[] passed = value.values();
        return this.invoke(env, passed);
    }

    @Override
    @Reflection.Signature
    public Memory getParameters(Environment env, Memory ... args) {
        if (this.cachedParameters != null) {
            return this.cachedParameters;
        }
        if (this.functionEntity instanceof CompileFunctionEntity) {
            this.exception(env, "Cannot get parameters for internal function %s()", this.functionEntity.getName());
        }
        ParameterEntity[] parameters = this.closureEntity == null ? this.functionEntity.getParameters() : this.closureEntity.parameters;
        ClassEntity entity = env.fetchClass("ReflectionParameter");
        ArrayMemory result = new ArrayMemory();
        int i = 0;
        for (ParameterEntity param : parameters) {
            ReflectionParameter e = new ReflectionParameter(env, entity);
            e.setEntity(param);
            e.setFunctionEntity(this.functionEntity);
            e.setPosition(i);
            ++i;
            result.add(new ObjectMemory(e));
        }
        this.cachedParameters = result;
        return this.cachedParameters;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="reflector", type=HintType.OBJECT), @Reflection.Arg(value="return", type=HintType.BOOLEAN, optional=@Reflection.Optional(value="", type=HintType.BOOLEAN))})
    public static Memory export(Environment env, Memory ... args) {
        ReflectionFunction e = new ReflectionFunction(env, env.fetchClass("ReflectionFunction"));
        if (args[1].toBoolean()) {
            return e.__toString(env, new Memory[0]);
        }
        env.echo(e.__toString(env, new Memory[0]));
        return Memory.NULL;
    }
}

