/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.invoke;

import php.runtime.Memory;
import php.runtime.common.Messages;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.invoke.InvokeHelper;
import php.runtime.invoke.Invoker;
import php.runtime.invoke.MagicStaticMethodInvoker;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ParameterEntity;

public class StaticMethodInvoker
extends Invoker {
    protected final MethodEntity method;
    protected final String calledClass;

    public StaticMethodInvoker(Environment env, TraceInfo trace, String calledClass, MethodEntity method) {
        super(env, trace);
        this.method = method;
        this.calledClass = calledClass;
    }

    @Override
    public ParameterEntity[] getParameters() {
        return this.method.getParameters();
    }

    @Override
    public void check(String name, TraceInfo trace) {
        if (!this.method.isStatic()) {
            this.env.warning(trace, name + "(): non-static method " + this.method.getSignatureString(false) + " should not be called statically", new Object[0]);
        }
    }

    @Override
    public String getName() {
        return this.calledClass + "::" + this.method.getName();
    }

    @Override
    public int getArgumentCount() {
        return this.method.getParameters() == null ? 0 : this.method.getParameters().length;
    }

    public MethodEntity getMethod() {
        return this.method;
    }

    public String getCalledClass() {
        return this.calledClass;
    }

    @Override
    public void pushCall(TraceInfo trace, Memory[] args) {
        this.env.pushCall(trace, null, args, this.method.getName(), this.method.getClazz().getName(), this.calledClass);
    }

    @Override
    protected Memory invoke(Memory ... args) throws Throwable {
        return InvokeHelper.callStatic(this.env, this.trace == null ? TraceInfo.UNKNOWN : this.trace, this.method, null, args, false);
    }

    @Override
    public int canAccess(Environment env) {
        return this.method.canAccess(env);
    }

    public static StaticMethodInvoker valueOf(Environment env, TraceInfo trace, String className, String methodName) {
        MethodEntity methodEntity;
        ClassEntity classEntity = env.fetchClass(className, true);
        if (classEntity == null) {
            classEntity = env.fetchMagicClass(className);
        }
        MethodEntity methodEntity2 = methodEntity = classEntity == null ? null : classEntity.findMethod(methodName.toLowerCase());
        if (methodEntity == null) {
            if (classEntity != null && classEntity.methodMagicCallStatic != null) {
                return new MagicStaticMethodInvoker(env, trace, className, classEntity.methodMagicCallStatic, methodName);
            }
            if (trace == null) {
                return null;
            }
            env.error(trace, Messages.ERR_CALL_TO_UNDEFINED_METHOD.fetch(className + "::" + methodName), new Object[0]);
            return null;
        }
        return new StaticMethodInvoker(env, trace, className, methodEntity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StaticMethodInvoker)) {
            return false;
        }
        StaticMethodInvoker that = (StaticMethodInvoker)o;
        return this.calledClass.equals(that.calledClass) && this.method.equals(that.method);
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = 31 * result + this.calledClass.hashCode();
        return result;
    }
}

