/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.loader.dump;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ConstantEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.ModuleEntity;

public class StandaloneLibrary {
    private String coreVersion;
    private String likePhpVersion;
    private Map<String, Module> modules = new LinkedHashMap<String, Module>();
    private Map<String, Module> classModules = new HashMap<String, Module>();
    private Map<String, Module> functionModules = new HashMap<String, Module>();
    private Map<String, Module> constantModules = new HashMap<String, Module>();

    public Map<String, Module> getModules() {
        return this.modules;
    }

    public Map<String, Module> getClassModules() {
        return this.classModules;
    }

    public Map<String, Module> getFunctionModules() {
        return this.functionModules;
    }

    public Map<String, Module> getConstantModules() {
        return this.constantModules;
    }

    public void addModule(Module module) {
        this.modules.put(module.getName(), module);
        for (String name : module.getClasses()) {
            this.classModules.put(name.toLowerCase(), module);
        }
        for (String name : module.getFunctions()) {
            this.functionModules.put(name.toLowerCase(), module);
        }
        for (String name : module.getConstants()) {
            this.constantModules.put(name, module);
        }
    }

    public String getCoreVersion() {
        return this.coreVersion;
    }

    public void setCoreVersion(String coreVersion) {
        this.coreVersion = coreVersion;
    }

    public String getLikePhpVersion() {
        return this.likePhpVersion;
    }

    public void setLikePhpVersion(String likePhpVersion) {
        this.likePhpVersion = likePhpVersion;
    }

    public static class Module {
        private final String name;
        private final String internalName;
        private final Set<String> classes;
        private final Set<String> functions;
        private final Set<String> constants;

        public Module(ModuleEntity entity) {
            this.name = entity.getName();
            this.internalName = entity.getInternalName();
            this.classes = new LinkedHashSet<String>();
            for (ClassEntity classEntity : entity.getClasses()) {
                this.classes.add(classEntity.getName());
            }
            this.functions = new LinkedHashSet<String>();
            for (FunctionEntity funcEntity : entity.getFunctions()) {
                this.functions.add(funcEntity.getName());
            }
            this.constants = new LinkedHashSet<String>();
            for (ConstantEntity constEntity : entity.getConstants()) {
                this.constants.add(constEntity.getName());
            }
        }

        public Module(String name, String internalName, Set<String> classes, Set<String> functions, Set<String> constants) {
            this.name = name;
            this.internalName = internalName;
            this.classes = classes;
            this.functions = functions;
            this.constants = constants;
        }

        public String getName() {
            return this.name;
        }

        public String getInternalName() {
            return this.internalName;
        }

        public Set<String> getClasses() {
            return this.classes;
        }

        public Set<String> getFunctions() {
            return this.functions;
        }

        public Set<String> getConstants() {
            return this.constants;
        }
    }
}

