/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.loader.dump.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import php.runtime.Memory;
import php.runtime.common.HintType;
import php.runtime.common.LangMode;
import php.runtime.common.Modifier;
import php.runtime.env.Context;
import php.runtime.env.TraceInfo;
import php.runtime.loader.dump.io.DumpException;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.helper.ClassConstantMemory;
import php.runtime.memory.helper.ConstantMemory;
import php.runtime.reflection.ClassEntity;

public class DumpInputStream
extends DataInputStream {
    public DumpInputStream(InputStream in) {
        super(in);
    }

    public String readName(int max) throws IOException {
        int nameLength = this.readInt();
        if (nameLength == -1) {
            return null;
        }
        if (nameLength == 0) {
            return "";
        }
        if (nameLength > max || nameLength < 1) {
            throw new DumpException("Invalid name size, max " + max);
        }
        return this.readUTF();
    }

    public String readName() throws IOException {
        return this.readName(2048);
    }

    public TraceInfo readTrace(Context context) throws IOException {
        boolean exits = this.readBoolean();
        if (exits) {
            int line = this.readInt();
            int position = this.readInt();
            String file = this.readUTF();
            return new TraceInfo(file, line, position);
        }
        return new TraceInfo(context);
    }

    public Modifier readModifier() throws IOException {
        int tmp = this.readInt();
        if (tmp == -1) {
            return null;
        }
        if (tmp >= 0 && tmp < Modifier.values().length) {
            return Modifier.values()[tmp];
        }
        throw new DumpException("Invalid ~Modifier value");
    }

    public HintType readHintType() throws IOException {
        int tmp = this.readInt();
        if (tmp == -1) {
            return null;
        }
        if (tmp >= 0 && tmp < HintType.values().length) {
            return HintType.values()[tmp];
        }
        throw new DumpException("Invalid ~HintType value");
    }

    public ClassEntity.Type readClassType() throws IOException {
        int tmp = this.readInt();
        if (tmp == -1) {
            return null;
        }
        if (tmp >= 0 && tmp < ClassEntity.Type.values().length) {
            return ClassEntity.Type.values()[tmp];
        }
        throw new DumpException("Invalid ~ClassEntity.Type value");
    }

    public LangMode readLangMode() throws IOException {
        int tmp = this.readInt();
        if (tmp == -1) {
            return null;
        }
        if (tmp >= 0 && tmp < LangMode.values().length) {
            return LangMode.values()[tmp];
        }
        throw new DumpException("Invalid ~LangMode value");
    }

    public Memory readMemory() throws IOException {
        int tmp = this.readInt();
        if (tmp == -1) {
            return null;
        }
        if (tmp == -2) {
            return new ConstantMemory(this.readUTF());
        }
        if (tmp == -3) {
            return new ClassConstantMemory(this.readUTF(), this.readUTF());
        }
        if (tmp >= 0 && tmp < Memory.Type.values().length) {
            Memory.Type type = Memory.Type.values()[tmp];
            switch (type) {
                case BOOL: {
                    return this.readBoolean() ? Memory.TRUE : Memory.FALSE;
                }
                case INT: {
                    return LongMemory.valueOf(this.readLong());
                }
                case DOUBLE: {
                    return DoubleMemory.valueOf(this.readDouble());
                }
                case NULL: {
                    return Memory.NULL;
                }
                case STRING: {
                    return StringMemory.valueOf(this.readUTF());
                }
                case ARRAY: {
                    ArrayMemory array = new ArrayMemory();
                    int size = this.readInt();
                    if (size < 0 || size > Short.MAX_VALUE) {
                        throw new DumpException("Invalid array memory size");
                    }
                    for (int i = 0; i < size; ++i) {
                        Memory key = this.readMemory();
                        Memory value = this.readMemory();
                        array.refOfIndex(key).assign(value);
                    }
                    return array;
                }
            }
            throw new DumpException("Cannot read " + type.toString() + " memory");
        }
        throw new DumpException("Invalid ~Memory.Type value");
    }

    public byte[] readRawData(int max) throws IOException {
        int length = this.readInt();
        if (length == 0) {
            return new byte[0];
        }
        if (length < 0) {
            throw new DumpException("Invalid raw-data size");
        }
        if (length > max) {
            throw new DumpException("Invalid raw-data size, max " + max + " bytes");
        }
        byte[] raw = new byte[length];
        this.readFully(raw);
        return raw;
    }

    public byte[] readRawData() throws IOException {
        return this.readRawData(204800);
    }
}

