/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.helper;

import php.runtime.Memory;
import php.runtime.env.TraceInfo;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.helper.CharArrayMemory;

public class BinaryCharArrayMemory
extends CharArrayMemory {
    protected static final Memory CONST_EMPTY_STRING = new BinaryMemory(new byte[0]);

    public BinaryCharArrayMemory(String value) {
        super(value);
        this.buffer.position(0);
    }

    public BinaryCharArrayMemory(char ch) {
        super(ch);
        this.buffer.position(0);
    }

    @Override
    public Memory toImmutable() {
        return new BinaryMemory(this.buffer.toString());
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, long index) {
        int _index = (int)index;
        if (_index >= 0 && _index < this.buffer.length()) {
            return new BinaryMemory(this.buffer.charAt(_index));
        }
        return CONST_EMPTY_STRING;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, double index) {
        int _index = (int)index;
        if (_index >= 0 && _index < this.buffer.length()) {
            return new BinaryMemory(this.buffer.charAt(_index));
        }
        return CONST_EMPTY_STRING;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, boolean index) {
        int _index;
        int n = _index = index ? 1 : 0;
        if (_index >= 0 && _index < this.buffer.length()) {
            return new BinaryMemory(this.buffer.charAt(_index));
        }
        return CONST_EMPTY_STRING;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, String index) {
        int _index = -1;
        Memory tmp = StringMemory.toLong(index);
        if (tmp != null) {
            _index = tmp.toInteger();
        }
        if (_index >= 0 && _index < this.buffer.length()) {
            return new BinaryMemory(this.buffer.charAt(_index));
        }
        return CONST_EMPTY_STRING;
    }

    @Override
    public char toChar() {
        return this.toImmutable().toChar();
    }
}

