/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.output;

import java.io.Writer;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.common.Modifier;
import php.runtime.common.StringUtils;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.lang.Closure;
import php.runtime.lang.ForeachIterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.output.Printer;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.PropertyEntity;

public class PrintR
extends Printer {
    protected int PRINT_INDENT = 4;

    public PrintR(Environment env, Writer writer) {
        super(env, writer);
    }

    @Override
    protected void printNull() {
    }

    @Override
    protected void printFalse() {
    }

    @Override
    protected void printTrue() {
        this.printer.write("1");
    }

    @Override
    protected void printLong(LongMemory value) {
        this.printer.write(value.toString());
    }

    @Override
    protected void printDouble(DoubleMemory value) {
        this.printer.write(value.toString());
    }

    @Override
    protected void printString(StringMemory value) {
        this.printer.write(value.toString());
    }

    protected void writeArrayHeader() {
        this.printer.write("Array\n");
    }

    protected void writeClose() {
        this.printer.write(")\n");
    }

    protected void writeSeparator(boolean isLast) {
        this.printer.write(10);
    }

    protected void writeOpen() {
        this.printer.write("(\n");
    }

    @Override
    protected void printArray(ArrayMemory value, int level, Set<Integer> used) {
        this.writeArrayHeader();
        if (used.contains(value.getPointer())) {
            this.printer.write(" *RECURSION*");
        } else {
            this.printer.write(StringUtils.repeat(' ', level * this.PRINT_INDENT));
            this.writeOpen();
            ++level;
            used.add(value.getPointer());
            ForeachIterator iterator = value.foreachIterator(false, false);
            int i = 0;
            int size = value.size();
            while (iterator.next()) {
                Memory el = iterator.getValue();
                if (el == Memory.UNDEFINED) continue;
                this.printer.write(StringUtils.repeat(' ', level * this.PRINT_INDENT));
                Memory key = iterator.getMemoryKey();
                this.printer.write(91);
                this.printer.write(key.toString());
                this.printer.write("] => ");
                this.print(el, level + 1, used);
                this.writeSeparator(i == size - 1);
                ++i;
            }
            this.printer.write(StringUtils.repeat(' ', --level * this.PRINT_INDENT));
            this.writeClose();
            used.remove(value.getPointer());
        }
    }

    protected void writeObjectHeader(String name) {
        this.printer.write(name);
        this.printer.write(" Object\n");
    }

    @Override
    protected void printClosure(Closure closure, int level, Set<Integer> used) {
        ClassEntity classEntity = closure.getReflection();
        this.writeObjectHeader(Closure.class.getSimpleName());
        if (used.contains(closure.getPointer())) {
            this.printer.write(" *RECURSION*");
        } else {
            this.printer.write(StringUtils.repeat(' ', level));
            this.writeOpen();
            level += this.PRINT_INDENT;
            used.add(closure.getPointer());
            this.printer.write(StringUtils.repeat(' ', level -= this.PRINT_INDENT));
            this.writeClose();
            used.remove(closure.getPointer());
        }
    }

    @Override
    protected void printObject(ObjectMemory value, int level, Set<Integer> used) {
        ClassEntity classEntity = value.getReflection();
        this.writeObjectHeader(classEntity.getName());
        if (used.contains(value.getPointer())) {
            this.printer.write(" *RECURSION*");
        } else {
            ArrayMemory props;
            this.printer.write(StringUtils.repeat(' ', level * this.PRINT_INDENT));
            this.writeOpen();
            ++level;
            used.add(value.getPointer());
            if (this.env != null && classEntity.methodMagicDebugInfo != null) {
                try {
                    Memory tmp = this.env.invokeMethod(value.value, classEntity.methodMagicDebugInfo.getName(), new Memory[0]);
                    if (tmp.isArray()) {
                        props = tmp.toValue(ArrayMemory.class);
                    }
                    props = new ArrayMemory();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            } else {
                props = value.getProperties();
            }
            if (classEntity.methodMagicDebugInfo != null) {
                for (PropertyEntity entity : classEntity.getProperties()) {
                    if (entity.getGetter() == null || entity.isHiddenInDebugInfo()) continue;
                    this.printer.write(StringUtils.repeat(' ', level * this.PRINT_INDENT));
                    this.printer.write("[");
                    this.printer.write(entity.getName());
                    this.printer.write(":getter] => ");
                    try {
                        this.print(entity.getValue(this.env, TraceInfo.UNKNOWN, value.value));
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                    this.writeSeparator(false);
                }
            }
            if (props != null) {
                ForeachIterator iterator = props.foreachIterator(false, false);
                int i = 0;
                int size = classEntity.properties.size();
                while (iterator.next()) {
                    this.printer.write(StringUtils.repeat(' ', level * this.PRINT_INDENT));
                    Object key = iterator.getKey();
                    this.printer.write(91);
                    String realKey = key.toString();
                    Modifier modifier = Modifier.PUBLIC;
                    String className = "";
                    int pos = realKey.lastIndexOf("\u0000");
                    if (pos > -1) {
                        if (realKey.startsWith("\u0000*\u0000")) {
                            modifier = Modifier.PROTECTED;
                        } else {
                            modifier = Modifier.PRIVATE;
                            className = realKey.substring(1, pos);
                        }
                        realKey = realKey.substring(pos + 1);
                    }
                    this.printer.write(realKey);
                    switch (modifier) {
                        case PRIVATE: {
                            this.printer.write(":" + className + ":private");
                            break;
                        }
                        case PROTECTED: {
                            this.printer.write(":protected");
                        }
                    }
                    this.printer.write("] => ");
                    this.print(iterator.getValue(), level + 1, used);
                    this.writeSeparator(i == size - 1);
                    ++i;
                }
            }
            this.printer.write(StringUtils.repeat(' ', --level * this.PRINT_INDENT));
            this.writeClose();
            used.remove(value.getPointer());
        }
    }
}

