/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import php.runtime.Memory;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.invoke.InvokeHelper;
import php.runtime.lang.Closure;
import php.runtime.memory.ObjectMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.helper.ClosureEntity;
import php.runtime.reflection.support.AbstractFunctionEntity;

public class FunctionEntity
extends AbstractFunctionEntity {
    protected boolean isInternal = false;
    protected ModuleEntity module;
    private Class<?> nativeClazz;
    private Method nativeMethod;
    private boolean isStatic = false;
    private Closure cachedClosure;

    public FunctionEntity(Context context) {
        super(context);
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean aStatic) {
        this.isStatic = aStatic;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public Class<?> getNativeClazz() {
        return this.nativeClazz;
    }

    public void setNativeClazz(Class<?> nativeClazz) {
        this.nativeClazz = nativeClazz;
    }

    public Method getNativeMethod() {
        return this.nativeMethod;
    }

    public void setNativeMethod(Method nativeMethod) {
        this.nativeMethod = nativeMethod;
        nativeMethod.setAccessible(true);
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    public ModuleEntity getModule() {
        return this.module;
    }

    public void setModule(ModuleEntity module) {
        this.module = module;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Memory invoke(Environment env, TraceInfo trace, Memory[] arguments) throws Throwable {
        try {
            Memory memory = InvokeHelper.checkReturnType(env, trace, (Memory)this.nativeMethod.invoke(null, env, arguments), this);
            return memory;
        }
        catch (InvocationTargetException e) {
            Memory memory = env.__throwException(e);
            return memory;
        }
        finally {
            this.unsetArguments(arguments);
        }
    }

    @Override
    public Memory getImmutableResultTyped(Environment env, TraceInfo trace) {
        Memory result = this.getImmutableResult();
        if (result != null && !this.resultTypeChecked && (result = InvokeHelper.checkReturnType(env, trace, result, this)) != null) {
            this.result = result;
            this.resultTypeChecked = true;
        }
        return result;
    }

    @Override
    public Closure getClosure(Environment env) {
        if (this.cachedClosure != null) {
            return this.cachedClosure;
        }
        final FunctionEntity bind = this;
        final ClosureEntity closureEntity1 = new ClosureEntity(this.getContext());
        closureEntity1.setParent(env.scope.fetchUserClass(Closure.class));
        closureEntity1.parameters = this.parameters;
        closureEntity1.setReturnReference(this.isReturnReference());
        MethodEntity m = new MethodEntity(this);
        m.setClazz(closureEntity1);
        m.setName("__invoke");
        closureEntity1.addMethod(m, null);
        closureEntity1.doneDeclare();
        Closure tmp = new Closure(env, closureEntity1, new ObjectMemory(env.getLateObject()), null, new Memory[0]){

            @Override
            public Memory __invoke(Environment e, Memory ... args) {
                try {
                    return bind.invoke(e, e.peekCall((int)0).trace, args);
                }
                catch (RuntimeException e1) {
                    throw e1;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }

            @Override
            public Memory getOrCreateStatic(String name) {
                return Memory.NULL;
            }

            @Override
            public ClassEntity getReflection() {
                return closureEntity1;
            }
        };
        try {
            m.setNativeMethod(tmp.getClass().getDeclaredMethod("__invoke", Environment.class, Memory[].class));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        this.cachedClosure = tmp;
        return this.cachedClosure;
    }
}

