/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection.support;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import php.runtime.common.Function;
import php.runtime.common.StringUtils;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;

public abstract class Entity {
    private Map<String, Object> additionalData = new HashMap<String, Object>();
    protected Context context;
    protected TraceInfo trace = TraceInfo.UNKNOWN;
    protected String name;
    protected String lowerName;
    protected String shortName;
    protected String namespaceName;
    protected String internalName;
    protected byte[] data;
    protected boolean useJavaLikeNames = false;

    public Entity(Context context) {
        this.context = context;
    }

    public boolean isUseJavaLikeNames() {
        return this.useJavaLikeNames;
    }

    public boolean isLoaded() {
        return this.data != null;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public TraceInfo getTrace() {
        return this.trace;
    }

    public void setTrace(TraceInfo trace) {
        this.trace = trace;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    public String getLowerName() {
        return this.lowerName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public void setName(String name) {
        this.name = name;
        if (name != null) {
            this.lowerName = name.toLowerCase();
            Object[] tmp = StringUtils.split(name, '\\');
            this.shortName = tmp.length == 0 ? name : tmp[tmp.length - 1];
            if (tmp.length > 1) {
                this.namespaceName = StringUtils.join(tmp, '\\', 0, tmp.length - 1);
            }
        } else {
            this.lowerName = null;
            this.shortName = null;
            this.namespaceName = null;
        }
    }

    public boolean isNamespace() {
        return this.namespaceName != null && !this.namespaceName.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity entity = (Entity)o;
        return this.hashCode() == entity.hashCode() && this.lowerName.equals(entity.lowerName);
    }

    public int hashCode() {
        return this.lowerName.hashCode();
    }

    public int getPointer() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAdditionalData(String name, Class<T> clazz, Function<T> initialValue) {
        Object r = this.additionalData.get(name);
        if (r != null) {
            return (T)r;
        }
        Entity entity = this;
        synchronized (entity) {
            r = this.additionalData.get(name);
            if (r != null) {
                return (T)r;
            }
            r = initialValue.call();
            this.additionalData.put(name, r);
        }
        return (T)r;
    }

    protected static Throwable getCause(InvocationTargetException e) {
        while (e.getTargetException() instanceof InvocationTargetException) {
            e = (InvocationTargetException)e.getTargetException();
        }
        return e.getCause();
    }

    public void register(Environment environment) {
    }
}

