/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.common.util;

import org.develnext.jphp.core.compiler.common.misc.StackItem;
import org.develnext.jphp.core.tokenizer.token.expr.OperatorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.KeyValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.MinusExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.MulExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.PlusExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.BooleanExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.CallExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.DoubleExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.IntegerExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NullExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StringExprToken;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringMemory;

public final class CompilerUtils {
    private CompilerUtils() {
    }

    protected static Memory toCallMemory(CallExprToken call, Memory ... arguments) {
        return null;
    }

    public static Memory toMemory(ValueExprToken value, Memory ... arguments) {
        if (value instanceof IntegerExprToken) {
            return LongMemory.valueOf(((IntegerExprToken)value).getValue());
        }
        if (value instanceof DoubleExprToken) {
            return DoubleMemory.valueOf(((DoubleExprToken)value).getValue());
        }
        if (value instanceof StringExprToken && !((StringExprToken)value).isBinary()) {
            return StringMemory.valueOf(((StringExprToken)value).getValue());
        }
        if (value instanceof BooleanExprToken) {
            return ((BooleanExprToken)value).getValue() ? Memory.TRUE : Memory.FALSE;
        }
        if (value instanceof NullExprToken) {
            return Memory.NULL;
        }
        if (value instanceof CallExprToken) {
            return CompilerUtils.toCallMemory((CallExprToken)value, arguments);
        }
        return null;
    }

    public static Memory calcUnary(Environment env, TraceInfo trace, Memory o1, OperatorExprToken operator) {
        if (operator.isBinary()) {
            throw new IllegalArgumentException("Operator is not unary");
        }
        return operator.calc(env, trace, o1, null);
    }

    public static Memory calcBinary(Environment env, TraceInfo trace, Memory o1, Memory o2, OperatorExprToken operator, boolean right) {
        if (!operator.isBinary()) {
            throw new IllegalArgumentException("Operator is not binary");
        }
        if (right) {
            Memory o = o1;
            o1 = o2;
            o2 = o;
        }
        return operator.calc(env, trace, o1, o2);
    }

    public static int getOperatorOpcode(OperatorExprToken operator, StackItem.Type type) {
        if (operator instanceof PlusExprToken) {
            switch (type) {
                case DOUBLE: {
                    return 99;
                }
                case FLOAT: {
                    return 98;
                }
                case LONG: {
                    return 97;
                }
                case BYTE: 
                case SHORT: 
                case INT: {
                    return 96;
                }
            }
        }
        if (operator instanceof MinusExprToken) {
            switch (type) {
                case DOUBLE: {
                    return 103;
                }
                case FLOAT: {
                    return 102;
                }
                case LONG: {
                    return 101;
                }
                case BYTE: 
                case SHORT: 
                case INT: {
                    return 100;
                }
            }
        }
        if (operator instanceof MulExprToken) {
            switch (type) {
                case DOUBLE: {
                    return 107;
                }
                case FLOAT: {
                    return 106;
                }
                case LONG: {
                    return 105;
                }
                case BYTE: 
                case SHORT: 
                case INT: {
                    return 104;
                }
            }
        }
        throw new IllegalArgumentException("Unknown operator " + operator.getWord() + " for type " + type.name());
    }

    public static boolean isOperatorAlwaysReturn(OperatorExprToken operator) {
        return operator instanceof KeyValueExprToken;
    }
}

