/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr.value;

import java.util.List;
import org.develnext.jphp.core.compiler.common.misc.StackItem;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseExprCompiler;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StringBuilderExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import php.runtime.Memory;
import php.runtime.memory.BinaryMemory;

public class StringBuilderValueCompiler
extends BaseExprCompiler<StringBuilderExprToken> {
    public StringBuilderValueCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    public void writeBuilder(List<Token> tokens) {
        this.writeBuilder(tokens, false);
    }

    public void writeBuilder(List<Token> tokens, boolean binary) {
        this.expr.writePushNewObject(StringBuilder.class);
        for (Token el : tokens) {
            if (el instanceof ValueExprToken) {
                this.expr.writePush((ValueExprToken)el, true, false);
            } else if (el instanceof ExprStmtToken) {
                this.expr.writeExpression((ExprStmtToken)el, true, false, true);
            } else {
                this.expr.unexpectedToken(el);
            }
            StackItem.Type peek = this.expr.stackPeek().type;
            if (!peek.isConstant()) {
                this.expr.writeSysDynamicCall(StringBuilder.class, "append", StringBuilder.class, Object.class);
                continue;
            }
            this.expr.writeSysDynamicCall(StringBuilder.class, "append", StringBuilder.class, peek.toClass());
        }
        this.expr.writeSysDynamicCall(StringBuilder.class, "toString", String.class, new Class[0]);
        if (binary) {
            this.expr.writeSysStaticCall(BinaryMemory.class, "valueOf", Memory.class, String.class);
        }
    }

    @Override
    public void write(StringBuilderExprToken value, boolean returnValue) {
        this.writeBuilder(value.getExpression(), value.isBinary());
    }
}

