/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr.value;

import org.develnext.jphp.core.compiler.jvm.misc.LocalVariable;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseExprCompiler;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.GetVarExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.UnsetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.reflection.MethodEntity;

public class UnsetCompiler
extends BaseExprCompiler<UnsetExprToken> {
    public UnsetCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    @Override
    public void write(UnsetExprToken token, boolean returnValue) {
        ((MethodEntity)this.method.getEntity()).setImmutable(false);
        for (ExprStmtToken param : token.getParameters()) {
            if (param.isSingle() && param.getSingle() instanceof VariableExprToken) {
                VariableExprToken variable = (VariableExprToken)param.getSingle();
                this.expr.checkAssignableVar(variable);
                LocalVariable local = this.method.getLocalVariable(variable.getName());
                this.expr.writeVarLoad(local);
                this.expr.writePushEnv();
                this.expr.writeSysDynamicCall(Memory.class, "manualUnset", Void.TYPE, Environment.class);
                if (!local.isReference()) {
                    this.expr.writePushNull();
                    this.expr.writeVarAssign(local, null, false, false);
                }
                local.setValue(null);
                continue;
            }
            if (param.isSingle() && param.getSingle() instanceof GetVarExprToken) {
                this.expr.writeValue((ValueExprToken)param.getSingle(), true);
                this.expr.writePushEnv();
                this.expr.writeSysDynamicCall(Memory.class, "manualUnset", Void.TYPE, Environment.class);
                continue;
            }
            this.expr.writeExpression(param, false, false, true);
        }
        if (returnValue) {
            this.expr.writePushNull();
        }
    }
}

