/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.opcode;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.develnext.jphp.core.opcode.OpcodePrinter;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.helper.ClosureEntity;
import php.runtime.reflection.helper.GeneratorEntity;

public class ModuleOpcodePrinter {
    private final ModuleEntity module;

    public ModuleOpcodePrinter(ModuleEntity module) {
        this.module = module;
    }

    public ModuleEntity getModule() {
        return this.module;
    }

    public void toOutput(Writer writer, int flags) {
        try {
            OpcodePrinter opcodePrinter = new OpcodePrinter(this.module);
            writer.write("#### Module class: " + this.module.getContext().getModuleName() + "\n");
            opcodePrinter.toWriter(writer, flags);
            writer.write("#### /Module class \n\n\n");
            for (ClosureEntity closure : this.module.getClosures()) {
                opcodePrinter = new OpcodePrinter(closure);
                writer.write("#### Closure: " + closure.getInternalName() + "\n");
                opcodePrinter.toWriter(writer);
                writer.write("#### /Closure \n\n\n");
            }
            for (GeneratorEntity generator : this.module.getGenerators()) {
                opcodePrinter = new OpcodePrinter(generator);
                writer.write("#### Generator: " + generator.getInternalName() + "\n");
                opcodePrinter.toWriter(writer);
                writer.write("#### /Generator \n\n\n");
            }
            for (ClassEntity clazz : this.module.getClasses()) {
                if (!clazz.isClass() && !clazz.isTrait()) continue;
                opcodePrinter = new OpcodePrinter(clazz);
                writer.write("#### " + (clazz.isTrait() ? "Trait" : "Class") + ": " + clazz.getName() + "\n");
                opcodePrinter.toWriter(writer);
                writer.write("#### /" + (clazz.isTrait() ? "Trait" : "Class") + " \n\n\n");
            }
            for (FunctionEntity function : this.module.getFunctions()) {
                opcodePrinter = new OpcodePrinter(function);
                writer.write("#### Function: " + function.getName() + "\n");
                opcodePrinter.toWriter(writer);
                writer.write("#### /Function \n\n\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void toOutput(Writer writer) {
        this.toOutput(writer, 2);
    }

    public String toString(int flags) {
        StringWriter stringWriter = new StringWriter();
        this.toOutput(stringWriter, flags);
        return stringWriter.toString();
    }

    public String toString() {
        return this.toString(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFile(File file, int flags) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            this.toOutput(writer, flags);
        }
    }

    public void toFile(File file) throws IOException {
        this.toFile(file, 2);
    }
}

