/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token.expr;

import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.expr.ExprToken;

public class BraceExprToken
extends ExprToken {
    protected Kind kind;
    protected boolean closed;

    public BraceExprToken(TokenMeta meta) {
        super(meta, TokenType.T_J_BRACE);
        switch (meta.getWord().charAt(0)) {
            case '{': {
                this.kind = Kind.BLOCK;
                break;
            }
            case '[': {
                this.kind = Kind.ARRAY;
                break;
            }
            case '(': {
                this.kind = Kind.SIMPLE;
                break;
            }
            case '}': {
                this.kind = Kind.BLOCK;
                this.closed = true;
                break;
            }
            case ']': {
                this.kind = Kind.ARRAY;
                this.closed = true;
                break;
            }
            case ')': {
                this.kind = Kind.SIMPLE;
                this.closed = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid " + meta.getWord() + " word for BraceExprToken");
            }
        }
    }

    public Kind getKind() {
        return this.kind;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isOpened() {
        return !this.closed;
    }

    public boolean isClosed(Kind kind) {
        return this.isClosed() && this.kind == kind;
    }

    public boolean isOpened(Kind kind) {
        return this.isOpened() && this.kind == kind;
    }

    public boolean isBlockOpened() {
        return this.kind == Kind.BLOCK && this.isOpened();
    }

    public boolean isBlockClosed() {
        return this.kind == Kind.BLOCK && this.isClosed();
    }

    public boolean isArrayOpened() {
        return this.kind == Kind.ARRAY && this.isOpened();
    }

    public boolean isArrayClosed() {
        return this.kind == Kind.ARRAY && this.isClosed();
    }

    public boolean isArray() {
        return this.kind == Kind.ARRAY;
    }

    public boolean isBlock() {
        return this.kind == Kind.BLOCK;
    }

    public boolean isSimpleOpened() {
        return this.kind == Kind.SIMPLE && this.isOpened();
    }

    public boolean isSimpleClosed() {
        return this.kind == Kind.SIMPLE && this.isClosed();
    }

    public boolean isSimple() {
        return this.kind == Kind.SIMPLE;
    }

    @Override
    public int getPriority() {
        if (this.closed) {
            return 1001;
        }
        return 1000;
    }

    public static enum Kind {
        SIMPLE,
        ARRAY,
        BLOCK,
        ANY;


        public static String toOpen(Kind kind) {
            switch (kind) {
                case ARRAY: {
                    return "[";
                }
                case BLOCK: {
                    return "{";
                }
                case SIMPLE: {
                    return "(";
                }
            }
            return null;
        }

        public static String toClose(Kind kind) {
            switch (kind) {
                case ARRAY: {
                    return "]";
                }
                case BLOCK: {
                    return "}";
                }
                case SIMPLE: {
                    return ")";
                }
            }
            return null;
        }
    }
}

