/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token.stmt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.CommentToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ClassVarStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ConstStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExtendsStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ImplementsStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.MethodStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.StmtToken;
import php.runtime.common.Modifier;
import php.runtime.reflection.ClassEntity;

public class ClassStmtToken
extends StmtToken {
    private Modifier modifier;
    private boolean isFinal;
    private boolean isAbstract;
    private NamespaceStmtToken namespace;
    private NameToken name;
    private CommentToken docComment;
    private ExtendsStmtToken extend;
    private ImplementsStmtToken implement;
    private MethodStmtToken constructor;
    private List<ConstStmtToken> constants;
    private List<ClassVarStmtToken> properties;
    private List<MethodStmtToken> methods;
    private List<NameToken> uses;
    private Map<String, List<Alias>> aliases;
    private Map<String, Replacement> replacements;
    private ClassEntity.Type classType = ClassEntity.Type.CLASS;

    protected ClassStmtToken(TokenMeta meta, TokenType type) {
        super(meta, type);
        this.properties = new ArrayList<ClassVarStmtToken>();
        this.constants = new ArrayList<ConstStmtToken>();
        this.methods = new ArrayList<MethodStmtToken>();
        this.uses = new ArrayList<NameToken>();
    }

    public ClassStmtToken(TokenMeta meta) {
        this(meta, TokenType.T_CLASS);
    }

    public boolean isInterface() {
        return this.classType == ClassEntity.Type.INTERFACE;
    }

    public void setInterface(boolean anInterface) {
        this.classType = anInterface ? ClassEntity.Type.INTERFACE : this.classType;
    }

    public boolean isTrait() {
        return this.classType == ClassEntity.Type.TRAIT;
    }

    public ClassEntity.Type getClassType() {
        return this.classType;
    }

    public void setClassType(ClassEntity.Type classType) {
        this.classType = classType;
    }

    public NameToken getName() {
        return this.name;
    }

    public void setName(NameToken name) {
        this.name = name;
    }

    public ExtendsStmtToken getExtend() {
        return this.extend;
    }

    public void setExtend(ExtendsStmtToken extend) {
        this.extend = extend;
    }

    public ImplementsStmtToken getImplement() {
        return this.implement;
    }

    public void setImplement(ImplementsStmtToken implement) {
        this.implement = implement;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean aFinal) {
        this.isFinal = aFinal;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    public MethodStmtToken getConstructor() {
        return this.constructor;
    }

    public void setConstructor(MethodStmtToken constructor) {
        this.constructor = constructor;
    }

    public List<ConstStmtToken> getConstants() {
        return this.constants;
    }

    public void setConstants(List<ConstStmtToken> constants) {
        this.constants = constants;
    }

    public List<ClassVarStmtToken> getProperties() {
        return this.properties;
    }

    public void setProperties(List<ClassVarStmtToken> properties) {
        this.properties = properties;
    }

    public List<MethodStmtToken> getMethods() {
        return this.methods;
    }

    public void setMethods(List<MethodStmtToken> methods) {
        this.methods = methods;
    }

    public NamespaceStmtToken getNamespace() {
        return this.namespace;
    }

    public void setNamespace(NamespaceStmtToken namespace) {
        this.namespace = namespace;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public void setModifier(Modifier modifier) {
        this.modifier = modifier;
    }

    public String getFulledName(char delimiter) {
        return this.namespace == null || this.namespace.getName() == null ? this.name.getName() : this.namespace.getName().toName(delimiter) + delimiter + this.name.getName();
    }

    public String getFulledName() {
        return this.getFulledName('\\');
    }

    public List<NameToken> getUses() {
        return this.uses;
    }

    public void setUses(List<NameToken> uses) {
        this.uses = uses;
    }

    public void addAlias(String className, String methodName, Modifier modifier, String name) {
        List<Alias> l;
        if (this.aliases == null) {
            this.aliases = new LinkedHashMap<String, List<Alias>>();
        }
        if ((l = this.aliases.get(methodName)) == null) {
            l = new ArrayList<Alias>();
            this.aliases.put(methodName.toLowerCase(), l);
        }
        l.add(new Alias(className, modifier, name));
    }

    public List<Alias> findAliases(String methodName) {
        return this.aliases == null ? null : this.aliases.get(methodName.toLowerCase());
    }

    public Map<String, List<Alias>> getAliases() {
        return this.aliases;
    }

    public Map<String, Replacement> getReplacements() {
        return this.replacements;
    }

    public boolean addReplacement(String className, String methodName, Set<String> classes) {
        Replacement replacement;
        if (classes == null || classes.isEmpty()) {
            throw new IllegalArgumentException("classes must not be null or empty");
        }
        if (this.replacements == null) {
            this.replacements = new LinkedHashMap<String, Replacement>();
        }
        if ((replacement = this.replacements.get(methodName.toLowerCase())) == null) {
            replacement = new Replacement(className, classes);
            this.replacements.put(methodName.toLowerCase(), replacement);
            return true;
        }
        for (String e : classes) {
            if (!replacement.hasTrait(e)) continue;
            return false;
        }
        replacement.addTraits(classes);
        return true;
    }

    public Replacement findReplacement(String methodName) {
        return this.replacements == null ? null : this.replacements.get(methodName.toLowerCase());
    }

    public CommentToken getDocComment() {
        return this.docComment;
    }

    public void setDocComment(CommentToken docComment) {
        this.docComment = docComment;
    }

    public static class Alias {
        protected final String trait;
        protected final Modifier modifier;
        protected final String name;

        public Alias(String trait, Modifier modifier, String name) {
            this.trait = trait;
            this.modifier = modifier;
            this.name = name;
        }

        public Modifier getModifier() {
            return this.modifier;
        }

        public String getName() {
            return this.name;
        }

        public String getTrait() {
            return this.trait;
        }
    }

    public static class Replacement {
        private final String origin;
        private final Set<String> traitsLower;
        private final Set<String> traits;

        public Replacement(String origin, Set<String> traits) {
            this.origin = origin;
            this.traits = traits;
            this.traitsLower = new HashSet<String>();
            for (String e : traits) {
                this.traitsLower.add(e.toLowerCase());
            }
        }

        public boolean hasTrait(String name) {
            return this.traitsLower.contains(name.toLowerCase());
        }

        public String getOrigin() {
            return this.origin;
        }

        public Set<String> getTraits() {
            return this.traits;
        }

        public void addTraits(Collection<String> list) {
            this.traits.addAll(list);
            for (String e : list) {
                this.traitsLower.add(e.toLowerCase());
            }
        }
    }

    protected static class MethodName {
        protected final String className;
        protected final String name;

        public MethodName(String className, String name) {
            this.className = className;
            this.name = name;
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodName)) {
                return false;
            }
            MethodName that = (MethodName)o;
            return this.className.equalsIgnoreCase(that.className) && this.name.equalsIgnoreCase(that.name);
        }

        public int hashCode() {
            int result = this.className.toLowerCase().hashCode();
            result = 31 * result + this.name.toLowerCase().hashCode();
            return result;
        }
    }
}

