/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ExceptionDialog
extends JDialog {
    private int dialogWidth = 600;
    private int dialogHeight = 240;
    private JLabel iconLabel = new JLabel();
    private boolean open = false;
    private JLabel errorLabel = new JLabel();
    private JTextArea errorTextArea = new JTextArea("");
    private JTextArea exceptionTextArea = new JTextArea("");
    private JScrollPane exceptionTextAreaSP = new JScrollPane();
    private JButton okButton = new JButton("OK");
    private JButton viewButton = new JButton("View Error");
    private JPanel topPanel = new JPanel(new BorderLayout());

    public ExceptionDialog(String errorLabelText, String errorDescription, Throwable e) {
        StringWriter errors = new StringWriter();
        e.printStackTrace(new PrintWriter(errors));
        this.setSize(this.dialogWidth, this.dialogHeight);
        this.setResizable(false);
        this.errorTextArea.setText(errorDescription);
        this.errorLabel.setText(errorLabelText);
        this.exceptionTextArea.setText(errors.toString());
        this.exceptionTextAreaSP = new JScrollPane(this.exceptionTextArea);
        this.exceptionTextAreaSP.setHorizontalScrollBarPolicy(30);
        this.exceptionTextAreaSP.setVerticalScrollBarPolicy(20);
        this.iconLabel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.iconLabel.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
        this.setupUI();
        this.setUpListeners();
    }

    public ExceptionDialog(String errorLabelText, Throwable e) {
        this(errorLabelText, null, e);
    }

    public void setupUI() {
        this.setTitle("Error");
        this.errorTextArea.setLineWrap(true);
        this.errorTextArea.setWrapStyleWord(true);
        this.errorTextArea.setEditable(false);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.okButton);
        this.errorTextArea.setBackground(this.iconLabel.getBackground());
        JScrollPane textAreaSP = new JScrollPane(this.errorTextArea);
        textAreaSP.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.errorLabel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.exceptionTextArea.setPreferredSize(new Dimension(100, 200));
        this.exceptionTextAreaSP.setBorder(new EmptyBorder(new Insets(0, 10, 0, 10)));
        this.topPanel.add((Component)this.iconLabel, "West");
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)this.errorLabel, "North");
        p.add(textAreaSP);
        this.topPanel.add(p);
        this.add(this.topPanel);
        this.add((Component)buttonPanel, "South");
    }

    public void collapse() {
        this.viewButton.setText("View Error");
        this.topPanel.remove(this.exceptionTextAreaSP);
        this.setSize(this.dialogWidth, this.dialogHeight);
        this.topPanel.revalidate();
        this.open = false;
    }

    public void expand() {
        this.viewButton.setText("Hide Error");
        this.topPanel.add((Component)this.exceptionTextAreaSP, "South");
        this.setSize(this.dialogWidth, this.dialogHeight + 100);
        this.topPanel.revalidate();
        this.open = true;
    }

    private void setUpListeners() {
        this.okButton.addActionListener(e -> {
            this.dispose();
            System.exit(1);
        });
        this.viewButton.addActionListener(e -> {
            if (this.open) {
                this.collapse();
            } else {
                this.expand();
            }
        });
    }
}

