/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.control;

import java.util.Scanner;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Border;
import org.develnext.jphp.ext.javafx.classes.text.UXFont;

public class LabelEx
extends Label {
    protected BooleanProperty autoSize;
    protected ObjectProperty<AutoSizeType> autoSizeType = new SimpleObjectProperty((Object)this, "autoSizeType", (Object)AutoSizeType.ALL);

    public LabelEx() {
        this("");
    }

    public LabelEx(String text) {
        this(text, null);
    }

    public LabelEx(String text, Node graphic) {
        super(text, graphic);
        this.setMnemonicParsing(false);
        this.textProperty().addListener((observable, oldValue, newValue) -> this.updateAutoSize());
        this.fontProperty().addListener((observable, oldValue, newValue) -> this.updateAutoSize());
        this.prefWidthProperty().addListener((observable, oldValue, newValue) -> this.updateAutoSize());
        this.prefHeightProperty().addListener((observable, oldValue, newValue) -> this.updateAutoSize());
        this.graphicProperty().addListener((observable, oldValue, newValue) -> this.updateAutoSize());
        this.autoSizeTypeProperty().addListener((observable, oldValue, newValue) -> this.updateAutoSize());
        this.styleProperty().addListener((observable, oldValue, newValue) -> this.updateAutoSize());
        this.borderProperty().addListener((observable, oldValue, newValue) -> this.updateAutoSize());
        this.paddingProperty().addListener((observable, oldValue, newValue) -> this.updateAutoSize());
    }

    public AutoSizeType getAutoSizeType() {
        return (AutoSizeType)((Object)this.autoSizeType.get());
    }

    public ObjectProperty<AutoSizeType> autoSizeTypeProperty() {
        return this.autoSizeType;
    }

    public void setAutoSizeType(AutoSizeType autoSizeType) {
        this.autoSizeType.set((Object)autoSizeType);
    }

    void updateAutoSize() {
        if (this.isAutoSize()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Node graphic = LabelEx.this.getGraphic();
                    if (LabelEx.this.getAutoSizeType() == AutoSizeType.ALL || LabelEx.this.getAutoSizeType() == AutoSizeType.HORIZONTAL) {
                        double width = LabelEx.this.getTextAutoWidth();
                        if (graphic != null) {
                            width += graphic.getLayoutBounds().getWidth() + LabelEx.this.getGraphicTextGap();
                        }
                        LabelEx.this.setPrefWidth(width);
                    }
                    if (LabelEx.this.getAutoSizeType() == AutoSizeType.ALL || LabelEx.this.getAutoSizeType() == AutoSizeType.VERTICAL) {
                        LabelEx.this.setPrefHeight(Math.max(LabelEx.this.getTextAutoHeight(), graphic == null ? 0.0 : graphic.getLayoutBounds().getHeight()));
                    }
                }
            });
        }
    }

    public final BooleanProperty autoSizeProperty() {
        if (this.autoSize == null) {
            this.autoSize = new SimpleBooleanProperty((Object)this, "autoSize", false);
        }
        return this.autoSize;
    }

    protected double getTextAutoWidth() {
        Border border;
        double width = UXFont.calculateTextWidth(this.getText(), this.getFont());
        Insets padding = this.getPadding();
        if (padding != null) {
            width += padding.getLeft() + padding.getRight();
        }
        if ((border = this.getBorder()) != null) {
            width += border.getInsets().getLeft() + border.getInsets().getRight();
        }
        return width;
    }

    protected double getTextAutoHeight() {
        Border border;
        Insets padding;
        double height = UXFont.getLineHeight(this.getFont());
        int count = 0;
        Scanner scanner = new Scanner(this.getText());
        while (scanner.hasNextLine()) {
            ++count;
            scanner.nextLine();
        }
        if (count > 1) {
            height *= (double)count;
        }
        if ((padding = this.getPadding()) != null) {
            height += padding.getTop() + padding.getBottom();
        }
        if ((border = this.getBorder()) != null) {
            height += border.getInsets().getTop() + border.getInsets().getBottom();
        }
        return height;
    }

    public final void setAutoSize(boolean value) {
        this.autoSizeProperty().setValue(Boolean.valueOf(value));
        this.updateAutoSize();
    }

    public final boolean isAutoSize() {
        return this.autoSize == null ? false : this.autoSize.getValue();
    }

    public static enum AutoSizeType {
        ALL,
        HORIZONTAL,
        VERTICAL;

    }
}

