/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.env;

import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import php.runtime.Memory;
import php.runtime.env.CallStack;
import php.runtime.env.CompileScope;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.SplClassLoader;
import php.runtime.env.TraceInfo;
import php.runtime.memory.ArrayMemory;
import php.runtime.output.OutputBuffer;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ModuleEntity;

public class ConcurrentEnvironment
extends Environment {
    private ThreadLocal<Stack<OutputBuffer>> outputBuffers;
    private ThreadLocal<Stack<Integer>> silentFlags = new ThreadLocal<Stack<Integer>>(){

        @Override
        protected Stack<Integer> initialValue() {
            return new Stack<Integer>();
        }
    };
    private ThreadLocal<CallStack> callStack = new ThreadLocal<CallStack>(){

        @Override
        protected CallStack initialValue() {
            return new CallStack(ConcurrentEnvironment.this);
        }
    };

    public ConcurrentEnvironment(Environment parent) {
        super(parent);
    }

    public ConcurrentEnvironment(CompileScope scope, OutputStream output) {
        super(scope, output);
    }

    public ConcurrentEnvironment(OutputStream output) {
        super(output);
    }

    public ConcurrentEnvironment(CompileScope scope) {
        super(scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stack<OutputBuffer> getOutputBuffers() {
        if (this.outputBuffers == null) {
            ConcurrentEnvironment concurrentEnvironment = this;
            synchronized (concurrentEnvironment) {
                this.outputBuffers = new ThreadLocal<Stack<OutputBuffer>>(){

                    @Override
                    protected Stack<OutputBuffer> initialValue() {
                        Stack<OutputBuffer> stack = new Stack<OutputBuffer>();
                        stack.push(ConcurrentEnvironment.this.getDefaultBuffer());
                        return stack;
                    }
                };
            }
        }
        return this.outputBuffers.get();
    }

    @Override
    public void __replaceCallStack(CallStack stack) {
        this.callStack.set(stack);
    }

    @Override
    public CallStack getCallStack() {
        return this.callStack.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIncludePath(String value) {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            super.addIncludePath(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassEntity autoloadCall(String name, String lowerName) {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            return super.autoloadCall(name, lowerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIncludePaths(Set<String> includePaths) {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            super.setIncludePaths(includePaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean defineConstant(String name, Memory value, boolean caseSensitise) {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            return super.defineConstant(name, value, caseSensitise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Memory setConfigValue(String name, Memory value) {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            return super.setConfigValue(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocale(Locale locale) {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            super.setLocale(locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserValue(String name, Object value) {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            super.setUserValue(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setErrorFlags(int errorFlags) {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            super.setErrorFlags(errorFlags);
        }
    }

    @Override
    public void __pushSilent() {
        this.silentFlags.get().push(this.getErrorFlags());
        this.setErrorFlags(0);
    }

    @Override
    public void __popSilent() {
        Integer flags = this.silentFlags.get().pop();
        this.setErrorFlags(flags);
    }

    @Override
    public void __clearSilent() {
        Stack<Integer> silents = this.silentFlags.get();
        Integer flags = null;
        while (!silents.empty()) {
            flags = silents.pop();
        }
        if (flags != null) {
            this.setErrorFlags(flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void __defineFunction(TraceInfo trace, String moduleIndex, int index) {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            super.__defineFunction(trace, moduleIndex, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerModule(ModuleEntity module) {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            super.registerModule(module, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleEntity importCompiledModule(Context context, boolean debugInformation) throws Throwable {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            return super.importCompiledModule(context, debugInformation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleEntity importModule(Context context) throws Throwable {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            return super.importModule(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAutoloader(SplClassLoader classLoader, boolean prepend) {
        List list = this.classLoaders;
        synchronized (list) {
            super.registerAutoloader(classLoader, prepend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unRegisterAutoloader(SplClassLoader classLoader) {
        List list = this.classLoaders;
        synchronized (list) {
            return super.unRegisterAutoloader(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Memory getOrCreateGlobal(String name) {
        ArrayMemory arrayMemory = this.globals;
        synchronized (arrayMemory) {
            return super.getOrCreateGlobal(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Memory getOrCreateStatic(String name, Memory initValue) {
        Map map = this.statics;
        synchronized (map) {
            return super.getOrCreateStatic(name, initValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void echo(byte[] bytes, int length) {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            super.echo(bytes, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void echo(Memory value) {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            super.echo(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void echo(String value) {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            super.echo(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushAll() throws Throwable {
        ConcurrentEnvironment concurrentEnvironment = this;
        synchronized (concurrentEnvironment) {
            super.flushAll();
        }
    }
}

