/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.env;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import php.runtime.common.Constants;

public class Context {
    protected final Charset charset;
    protected final File file;
    protected String content;
    private String moduleName;
    private InputStream inputStream;
    private long lastModified = 0L;

    public Context(InputStream input, String fileName, Charset character) {
        this.file = null;
        this.charset = character;
        this.moduleName = fileName;
        this.inputStream = input;
        if (fileName != null) {
            this.lastModified = new File(fileName).lastModified();
        }
    }

    public Context(InputStream input, Charset charset) {
        this(input, null, charset);
    }

    public Context(InputStream input) {
        this(input, null, Charset.defaultCharset());
    }

    public Context(File file, Charset charset) {
        this.file = file;
        this.moduleName = file.getPath();
        this.charset = charset;
    }

    public Context(File file) {
        this(file, Charset.defaultCharset());
    }

    public Context(String content) {
        this(content, null);
    }

    public Context(String content, File file) {
        this.file = file;
        this.content = content;
        this.charset = Charset.defaultCharset();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    protected void readContent(Reader reader) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder result = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            result.append(line);
            result.append("\n");
        }
        this.content = result.toString();
    }

    public boolean isLikeFile() {
        return this.file != null || this.inputStream != null;
    }

    public String getFileName() {
        return this.file != null ? this.file.getPath() : this.moduleName;
    }

    public String getModuleName() throws IOException {
        if (this.moduleName != null && this.file == null) {
            return this.moduleName;
        }
        if (this.file == null) {
            if (this.content == null) {
                return null;
            }
            return String.valueOf(this.content.hashCode()) + "~" + this.content.length();
        }
        String name = this.file.getCanonicalPath();
        if (Constants.PATH_NAME_CASE_INSENSITIVE) {
            name = name.toLowerCase();
        }
        return name;
    }

    public String getModuleNameNoThrow() {
        try {
            return this.getModuleName();
        }
        catch (IOException e) {
            return this.file.getAbsolutePath();
        }
    }

    public String getContent() throws IOException {
        if (this.inputStream != null) {
            this.readContent(new InputStreamReader(this.inputStream, this.charset));
        } else if (this.content == null && this.file != null) {
            this.readContent(new InputStreamReader((InputStream)new FileInputStream(this.file), this.charset));
        }
        return this.content;
    }

    public InputStream getInputStream(Charset charset) throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        return new ByteArrayInputStream(this.content.getBytes(charset));
    }
}

