/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.env;

import java.io.BufferedInputStream;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import php.runtime.Memory;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.ext.core.classes.stream.FileStream;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.ext.core.classes.stream.WrapIOException;
import php.runtime.reflection.ModuleEntity;

public class ModuleManager {
    protected final Environment env;
    protected final Map<String, ModuleEntity> modules = new LinkedHashMap<String, ModuleEntity>();

    public ModuleManager(Environment env) {
        this.env = env;
    }

    public void apply(ModuleManager parent) {
        this.modules.putAll(parent.modules);
    }

    public ModuleEntity fetchModule(String path) throws Throwable {
        return this.fetchModule(path, path.endsWith(".phb"));
    }

    public ModuleEntity fetchModule(String path, boolean compiled) throws Throwable {
        ModuleEntity moduleEntity = this.modules.get(path);
        if (moduleEntity != null && (moduleEntity.getContext().getLastModified() == 0L || moduleEntity.getContext().getLastModified() == new File(path).lastModified())) {
            return moduleEntity;
        }
        this.env.scope.removeUserModule(path);
        moduleEntity = this.fetchTemporaryModule(path, compiled);
        if (moduleEntity == null) {
            return null;
        }
        this.modules.put(path, moduleEntity);
        return moduleEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleEntity fetchTemporaryModule(String path, boolean compiled) throws Throwable {
        Stream stream = this.fetchStream(path);
        if (stream == null) {
            return null;
        }
        try {
            if (stream._isExternalResourceStream()) {
                this.env.exception("Cannot import module form external stream: " + stream.getPath(), new Object[0]);
                ModuleEntity moduleEntity = null;
                return moduleEntity;
            }
            Context context = this.fetchContext(stream);
            ModuleEntity module = compiled ? this.env.importCompiledModule(context, true) : this.env.importModule(context);
            module.setTrace(new TraceInfo(context));
            ModuleEntity moduleEntity = module;
            return moduleEntity;
        }
        finally {
            this.env.invokeMethod(stream, "close", new Memory[0]);
        }
    }

    public Context fetchContext(Stream stream) throws Throwable {
        if (stream instanceof FileStream) {
            return new Context(new BufferedInputStream(Stream.getInputStream(this.env, stream)), stream.getPath(), this.env.getDefaultCharset());
        }
        return new Context(new BufferedInputStream(Stream.getInputStream(this.env, stream)), stream.getPath(), this.env.getDefaultCharset());
    }

    protected Stream fetchStream(String path) throws Throwable {
        try {
            return Stream.create(this.env, path, "r");
        }
        catch (WrapIOException e) {
            return null;
        }
    }

    public ModuleEntity findModule(String path) {
        return this.modules.get(path);
    }

    public void addModule(String path, ModuleEntity module) {
        this.modules.put(path, module);
    }

    public ModuleEntity findModule(TraceInfo traceInfo) {
        if (traceInfo == null || traceInfo == TraceInfo.UNKNOWN) {
            return null;
        }
        return this.findModule(traceInfo.getFileName());
    }

    public boolean hasModule(String path) {
        return this.modules.containsKey(path);
    }

    public Collection<String> getCachedPaths() {
        return this.modules.keySet();
    }
}

